/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.file;

import com.installshield.util.FileAttributes;

public class UnixFileAttrs {
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;

    public static FileAttributes getAttributeObject(int n) {
        FileAttributes fileAttributes = new FileAttributes();
        if ((n & 0x100) == 256) {
            fileAttributes.setAttributeState(1, true);
        }
        if ((n & 0x20) == 32) {
            fileAttributes.setAttributeState(8, true);
        }
        if ((n & 4) == 4) {
            fileAttributes.setAttributeState(64, true);
        }
        if ((n & 0x80) == 128) {
            fileAttributes.setAttributeState(2, true);
        }
        if ((n & 0x10) == 16) {
            fileAttributes.setAttributeState(16, true);
        }
        if ((n & 2) == 2) {
            fileAttributes.setAttributeState(128, true);
        }
        if ((n & 0x40) == 64) {
            fileAttributes.setAttributeState(4, true);
        }
        if ((n & 8) == 8) {
            fileAttributes.setAttributeState(32, true);
        }
        if ((n & 1) == 1) {
            fileAttributes.setAttributeState(256, true);
        }
        return fileAttributes;
    }

    public static FileAttributes getAttributeObject(String string, int n) {
        FileAttributes fileAttributes = UnixFileAttrs.getAttributeObject(n);
        if (string.charAt(0) == '.') {
            fileAttributes.setAttributeState(512, true);
        }
        return fileAttributes;
    }

    public static String getAttributeString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0x100) == 256) {
            stringBuffer.append("rU");
        }
        if ((n & 0x20) == 32) {
            stringBuffer.append("rG");
        }
        if ((n & 4) == 4) {
            stringBuffer.append("rO");
        }
        if ((n & 0x80) == 128) {
            stringBuffer.append("wU");
        }
        if ((n & 0x10) == 16) {
            stringBuffer.append("wG");
        }
        if ((n & 2) == 2) {
            stringBuffer.append("wO");
        }
        if ((n & 0x40) == 64) {
            stringBuffer.append("xU");
        }
        if ((n & 8) == 8) {
            stringBuffer.append("xG");
        }
        if ((n & 1) == 1) {
            stringBuffer.append("xO");
        }
        if ((n & 0x800) == 2048) {
            stringBuffer.append("s");
        }
        if ((n & 0x400) == 1024) {
            stringBuffer.append("g");
        }
        return stringBuffer.toString();
    }

    public static int getMode(FileAttributes fileAttributes) {
        int n = 0;
        if (fileAttributes.getAttributeState(1)) {
            n |= 0x100;
        }
        if (fileAttributes.getAttributeState(8)) {
            n |= 0x20;
        }
        if (fileAttributes.getAttributeState(64)) {
            n |= 4;
        }
        if (fileAttributes.getAttributeState(2)) {
            n |= 0x80;
        }
        if (fileAttributes.getAttributeState(16)) {
            n |= 0x10;
        }
        if (fileAttributes.getAttributeState(128)) {
            n |= 2;
        }
        if (fileAttributes.getAttributeState(4)) {
            n |= 0x40;
        }
        if (fileAttributes.getAttributeState(32)) {
            n |= 8;
        }
        if (fileAttributes.getAttributeState(256)) {
            n |= 1;
        }
        return n;
    }

    public static int getMode(String string) {
        int n = 0;
        if (string.indexOf("rU") != -1) {
            n |= 0x100;
        }
        if (string.indexOf("rG") != -1) {
            n |= 0x20;
        }
        if (string.indexOf("rO") != -1) {
            n |= 4;
        }
        if (string.indexOf("wU") != -1) {
            n |= 0x80;
        }
        if (string.indexOf("wG") != -1) {
            n |= 0x10;
        }
        if (string.indexOf("wO") != -1) {
            n |= 2;
        }
        if (string.indexOf("xU") != -1) {
            n |= 0x40;
        }
        if (string.indexOf("xG") != -1) {
            n |= 8;
        }
        if (string.indexOf("xO") != -1) {
            n |= 1;
        }
        if (string.indexOf("s") != -1) {
            n |= 0x800;
        }
        if (string.indexOf("g") != -1) {
            n |= 0x400;
        }
        return n;
    }
}

