/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.registry;

import com.installshield.product.DynamicSuite;
import com.installshield.product.Product;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductFeature;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.StaticSuite;
import com.installshield.product.service.registry.PureJavaRegistryServiceImpl;
import com.installshield.product.service.registry.RegistryServiceImplementor;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.platform.hpux.HpuxUtils;
import com.installshield.wizard.platform.hpux.service.registry.HpuxSoftObj;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class HpuxRegistryServiceImpl
extends PureJavaRegistryServiceImpl
implements RegistryServiceImplementor {
    private static int score = -1;
    private long socp;

    public void addParentSoftwareObjects(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey[] softwareObjectKeyArray) throws ServiceException {
        this.say("addParentSoftwareObjects(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ", )");
        HpuxSoftObj hpuxSoftObj = this.getHpuxSoftObj(softwareObjectKey);
        if (hpuxSoftObj != null) {
            hpuxSoftObj.addParents(softwareObjectKeyArray);
        }
    }

    public void addRequiredSoftwareObjects(SoftwareObjectKey softwareObjectKey, SoftwareObjectReference[] softwareObjectReferenceArray) throws ServiceException {
        this.say("addRequiredSoftwareObjects(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ", )");
        HpuxSoftObj hpuxSoftObj = this.getHpuxSoftObj(softwareObjectKey);
        if (hpuxSoftObj != null) {
            hpuxSoftObj.addRequired(softwareObjectReferenceArray);
        }
    }

    private native HpuxSoftObj addSoftObj(String var1, String var2) throws ServiceException;

    private HpuxSoftObj createHpuxSoftObjLike(SoftwareObject softwareObject, String string) throws ServiceException {
        String string2 = null;
        HpuxSoftObj hpuxSoftObj = null;
        if (softwareObject instanceof ProductComponent) {
            string2 = "fileset";
        } else if (softwareObject instanceof ProductFeature) {
            string2 = "subproduct";
        } else if (softwareObject instanceof StaticSuite || softwareObject instanceof DynamicSuite) {
            string2 = "bundle";
        } else if (softwareObject instanceof Product) {
            string2 = "product";
        } else if (softwareObject instanceof HpuxSoftObj) {
            HpuxSoftObj hpuxSoftObj2 = (HpuxSoftObj)softwareObject;
            string2 = hpuxSoftObj2.getStringAttrib("object_class");
        }
        if (string2 == null || string2.length() == 0) {
            throw new ServiceException(399, "unknown software object type");
        }
        this.say("createHpuxSoftObjLike(, " + string + ")  type " + string2);
        hpuxSoftObj = this.addSoftObj(string2, string);
        hpuxSoftObj.setAttributes(softwareObject, false);
        return hpuxSoftObj;
    }

    public native void finalizeRegistry() throws ServiceException;

    public native String[] getAllSoftwareObjectUIDs() throws ServiceException;

    private native HpuxSoftObj getHpuxSoftObj(SoftwareObjectKey var1) throws ServiceException;

    private native HpuxSoftObj[] getHpuxSoftObjs(String var1) throws ServiceException;

    public int getInstalledInstance(SoftwareObjectKey softwareObjectKey, String string) throws ServiceException {
        FileService fileService = null;
        this.say("getInstalledInstance(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ", " + string + ")");
        try {
            fileService = (FileService)this.getServices().getService("fileService");
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        SoftwareObjectKey softwareObjectKey2 = (SoftwareObjectKey)softwareObjectKey.clone();
        int n = this.getNewestInstance(softwareObjectKey);
        while (n != -1) {
            softwareObjectKey2.setInstance(n);
            HpuxSoftObj hpuxSoftObj = this.getHpuxSoftObj(softwareObjectKey2);
            String string2 = hpuxSoftObj.getInstallLocation();
            boolean bl = false;
            if (fileService != null) {
                try {
                    bl = fileService.comparePaths(string2, string);
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", serviceException);
                    bl = FileUtils.comparePaths(string2, string);
                }
            } else {
                bl = FileUtils.comparePaths(string2, string);
            }
            if (bl) break;
            n = this.getNextNewestInstance(softwareObjectKey, n);
        }
        return n;
    }

    public int getNewestInstance(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        this.say("getNewestInstance(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ")");
        return this.getNextNewestInstance(softwareObjectKey, Integer.MAX_VALUE);
    }

    public native int getNextNewestInstance(SoftwareObjectKey var1, int var2) throws ServiceException;

    public SoftwareObject getSoftwareObject(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        this.say("getSoftwareObject(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ")");
        return this.getHpuxSoftObj(softwareObjectKey);
    }

    public native SoftwareObjectKey[] getSoftwareObjectKeysWithParent(SoftwareObjectKey var1);

    public native SoftwareObjectKey[] getSoftwareObjectKeysWithRequired(SoftwareObjectKey var1);

    public SoftwareObject[] getSoftwareObjects(String string) throws ServiceException {
        this.say("getSoftwareObjects(" + string + ")");
        return this.getHpuxSoftObjs(string);
    }

    public int getSystemCompatibility() {
        block8: {
            this.say("getSystemCompatibility()");
            if (score == -1 && (score = HpuxUtils.getCompatibilityScore()) > 0) {
                if (!System.getProperty("user.name").equals("root")) {
                    score = 0;
                    this.say("You have to be root to use reg service");
                } else {
                    try {
                        String string;
                        String string2 = "^.\\.10\\.20";
                        String string3 = "^.\\.11\\.00";
                        String string4 = System.getProperty("os.version");
                        this.say("os.version: " + string4);
                        if (!Rex.matches(string4, "^.\\.10\\.20") && !Rex.matches(string4, "^.\\.11\\.00")) break block8;
                        this.say("exec(\"/usr/bin/what /usr/sbin/swmodify\");");
                        Process process = Runtime.getRuntime().exec("/usr/bin/what /usr/sbin/swmodify");
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        String string5 = "SD-UX/";
                        String string6 = ", \t\r\n";
                        while ((string = bufferedReader.readLine()) != null) {
                            this.say("what: " + string);
                            int n = string.indexOf("SD-UX/");
                            if (n == -1) continue;
                            int n2 = string.length();
                            int n3 = n += "SD-UX/".length();
                            while (n3 < n2) {
                                char c = string.charAt(n3);
                                if (", \t\r\n".indexOf(c) != -1) break;
                                ++n3;
                            }
                            String string7 = string.substring(n, n3);
                            this.say("what: " + string7);
                            if (Rex.matches(string7, "^.\\.10\\.20") || Rex.matches(string7, "^.\\.11\\.00")) {
                                score = 0;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        this.logEvent(this, "err", exception);
                    }
                }
            }
        }
        this.say("return score " + score);
        return score;
    }

    public native String getVPDFileName() throws ServiceException;

    public native void initializeRegistry() throws ServiceException;

    public void initialized() {
        this.say("initialized()");
        HpuxUtils.loadLibrary(this.getServices());
        try {
            String string = System.getProperty("is.debug");
            if (string != null && string.length() > 0) {
                this.setDebug(Integer.parseInt(string));
            }
            this.initializeRegistry();
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    public static void main(String[] stringArray) {
        System.load("/opt/InstallShield/MP50/ppksdk/hpuxppk/ia64/libhpuxppk.1");
        System.load("/opt/InstallShield/MP50/ppksdk/hpuxppk/ia64/libJudy.1");
        HpuxRegistryServiceImpl hpuxRegistryServiceImpl = new HpuxRegistryServiceImpl();
        try {
            int n = hpuxRegistryServiceImpl.getSystemCompatibility();
            hpuxRegistryServiceImpl.say("system compat score: " + n);
            hpuxRegistryServiceImpl.initializeRegistry();
            SoftwareVersion softwareVersion = new SoftwareVersion();
            softwareVersion.setMajor("3");
            softwareVersion.setMinor("1");
            SoftwareObjectKey softwareObjectKey = new SoftwareObjectKey();
            softwareObjectKey.setUID("NeatoFeature_uid");
            softwareObjectKey.setVersion(softwareVersion);
            ProductFeature productFeature = new ProductFeature();
            productFeature.setKey(softwareObjectKey);
            productFeature.setPubliclyShareable(true);
            productFeature.setReplaceOption(4);
            productFeature.setVendor("Rex Barzee");
            hpuxRegistryServiceImpl.setSoftwareObject(productFeature);
            SoftwareObject softwareObject = hpuxRegistryServiceImpl.getSoftwareObject(softwareObjectKey);
            if (softwareObject != null) {
                hpuxRegistryServiceImpl.say("found software object: " + softwareObject.getKey().getUID());
            } else {
                hpuxRegistryServiceImpl.say("can't find software object: " + softwareObjectKey.getUID());
            }
            SoftwareVersion softwareVersion2 = new SoftwareVersion();
            softwareVersion2.setMajor("2");
            SoftwareObjectKey softwareObjectKey2 = new SoftwareObjectKey();
            softwareObjectKey2.setUID("RadicalComp_uid");
            softwareObjectKey2.setVersion(softwareVersion2);
            ProductComponent productComponent = new ProductComponent();
            productComponent.setKey(softwareObjectKey2);
            hpuxRegistryServiceImpl.setSoftwareObject(productComponent);
            SoftwareVersion softwareVersion3 = new SoftwareVersion();
            softwareVersion3.setMajor("1");
            SoftwareObjectKey softwareObjectKey3 = new SoftwareObjectKey();
            softwareObjectKey3.setUID("RollickingProduct_uid");
            softwareObjectKey3.setVersion(softwareVersion3);
            Product product = new Product();
            product.setKey(softwareObjectKey3);
            hpuxRegistryServiceImpl.setSoftwareObject(product);
            SoftwareObjectKey[] softwareObjectKeyArray = new SoftwareObjectKey[]{softwareObjectKey};
            hpuxRegistryServiceImpl.addParentSoftwareObjects(softwareObjectKey2, softwareObjectKeyArray);
            softwareObjectKeyArray[0] = softwareObjectKey3;
            hpuxRegistryServiceImpl.addParentSoftwareObjects(softwareObjectKey, softwareObjectKeyArray);
            softwareObject = hpuxRegistryServiceImpl.getSoftwareObject(softwareObjectKey3);
            if (softwareObject != null) {
                hpuxRegistryServiceImpl.say("found software object: " + softwareObject.getKey().getUID());
            } else {
                hpuxRegistryServiceImpl.say("can't find software object: " + softwareObjectKey3.getUID());
            }
            softwareVersion2.setMajor("1");
            softwareObject = hpuxRegistryServiceImpl.getSoftwareObject(softwareObjectKey2);
            if (softwareObject != null) {
                hpuxRegistryServiceImpl.say("found software object: " + softwareObject.getKey().getUID());
            } else {
                hpuxRegistryServiceImpl.say("can't find software object: " + softwareObjectKey2.getUID());
            }
            hpuxRegistryServiceImpl.finalizeRegistry();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeParentSoftwareObjects(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey[] softwareObjectKeyArray) throws ServiceException {
        this.say("removeParentSoftwareObjects(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ", )");
        HpuxSoftObj hpuxSoftObj = this.getHpuxSoftObj(softwareObjectKey);
        if (hpuxSoftObj != null) {
            hpuxSoftObj.removeParents(softwareObjectKeyArray);
        }
    }

    public void removeRequiredSoftwareObjects(SoftwareObjectKey softwareObjectKey, SoftwareObjectReference[] softwareObjectReferenceArray) throws ServiceException {
        this.say("removeRequiredSoftwareObjects(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ", )");
        HpuxSoftObj hpuxSoftObj = this.getHpuxSoftObj(softwareObjectKey);
        if (hpuxSoftObj != null) {
            hpuxSoftObj.removeRequired(softwareObjectReferenceArray);
        }
    }

    public native void removeSoftObj(SoftwareObjectKey var1) throws ServiceException;

    public void removeSoftwareObject(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        this.say("removeSoftwareObject(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ")");
        if (this.getHpuxSoftObj(softwareObjectKey) != null) {
            this.removeSoftObj(softwareObjectKey);
            softwareObjectKey.setInstance(0);
        }
    }

    private void say(String string) {
        String string2 = System.getProperty("is.debug");
        if (string2 != null && string2.length() > 0) {
            System.out.println("HpuxRegServImpl: " + string);
        }
    }

    private native void setDebug(int var1);

    public SoftwareObjectKey setSoftwareObject(SoftwareObject softwareObject) throws ServiceException {
        HpuxSoftObj hpuxSoftObj;
        SoftwareObjectKey softwareObjectKey = softwareObject.getKey();
        this.say("setSoftwareObject(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ")");
        if (softwareObjectKey.getInstance() == 0) {
            SoftwareObjectKey softwareObjectKey2 = (SoftwareObjectKey)softwareObjectKey.clone();
            int n = this.getNewestInstance(softwareObjectKey);
            n = n == -1 ? 1 : ++n;
            softwareObjectKey.setInstance(n);
            hpuxSoftObj = this.createHpuxSoftObjLike(softwareObject, softwareObjectKey.getUID());
        } else {
            hpuxSoftObj = this.getHpuxSoftObj(softwareObjectKey);
            if (hpuxSoftObj == null) {
                throw new ServiceException(399, "no such software object: " + HpuxSoftObj.makeKeyString(softwareObjectKey));
            }
            hpuxSoftObj.setAttributes(softwareObject, true);
        }
        return hpuxSoftObj.getKey();
    }

    public void updateParentSoftwareObject(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey softwareObjectKey2) {
        block4: {
            this.say("updateParentSoftwareObject(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ", " + HpuxSoftObj.makeKeyString(softwareObjectKey2) + ")");
            try {
                HpuxSoftObj hpuxSoftObj = this.getHpuxSoftObj(softwareObjectKey);
                if (hpuxSoftObj == null) break block4;
                boolean bl = false;
                SoftwareObjectKey[] softwareObjectKeyArray = hpuxSoftObj.getParents();
                if (softwareObjectKeyArray == null) break block4;
                int n = 0;
                while (n < softwareObjectKeyArray.length) {
                    if (softwareObjectKeyArray[n].equals(softwareObjectKey2)) {
                        bl = true;
                        hpuxSoftObj.updateParent(n, softwareObjectKey2);
                        break;
                    }
                    ++n;
                }
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    public void updateRequiredSoftwareObject(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey softwareObjectKey2) {
        block4: {
            this.say("updateRequiredSoftwareObject(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ", " + HpuxSoftObj.makeKeyString(softwareObjectKey2) + ")");
            try {
                HpuxSoftObj hpuxSoftObj = this.getHpuxSoftObj(softwareObjectKey);
                if (hpuxSoftObj == null) break block4;
                boolean bl = false;
                SoftwareObjectReference[] softwareObjectReferenceArray = hpuxSoftObj.getRequired();
                if (softwareObjectReferenceArray == null) break block4;
                int n = 0;
                while (n < softwareObjectReferenceArray.length) {
                    if (softwareObjectReferenceArray[n].getKey().equals(softwareObjectKey2)) {
                        bl = true;
                        hpuxSoftObj.updatePrereq(n, softwareObjectKey2);
                        break;
                    }
                    ++n;
                }
            }
            catch (ServiceException serviceException) {
                this.say("Unable to get the hpux software object: " + serviceException);
            }
        }
    }

    public SoftwareObjectKey updateSoftwareObjectKeyVersion(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey softwareObjectKey2) throws ServiceException {
        this.say("updateSoftwareObjectKeyVersion(" + HpuxSoftObj.makeKeyString(softwareObjectKey) + ", " + HpuxSoftObj.makeKeyString(softwareObjectKey2) + ")");
        SoftwareObjectKey softwareObjectKey3 = (SoftwareObjectKey)softwareObjectKey2.clone();
        if (softwareObjectKey.getInstance() != 0) {
            SoftwareObjectKey softwareObjectKey4 = (SoftwareObjectKey)softwareObjectKey.clone();
            SoftwareObject softwareObject = this.getSoftwareObject(softwareObjectKey);
            SoftwareObject softwareObject2 = this.getSoftwareObject(softwareObjectKey2);
            if (softwareObject != null) {
                if (softwareObjectKey.getVersion().compareTo(softwareObjectKey2.getVersion()) != 0) {
                    if (softwareObject2 != null) {
                        softwareObjectKey3 = (SoftwareObjectKey)softwareObject2.getKey().clone();
                    } else {
                        softwareObject2 = this.createHpuxSoftObjLike(softwareObject, softwareObjectKey.getUID());
                        softwareObjectKey2.setInstance(0);
                        int n = this.getNewestInstance(softwareObjectKey2);
                        if (n < 0) {
                            softwareObjectKey2.setInstance(1);
                        } else {
                            softwareObjectKey2.setInstance(n + 1);
                        }
                        ((HpuxSoftObj)softwareObject2).setKey(softwareObjectKey2);
                        softwareObjectKey3 = (SoftwareObjectKey)softwareObject2.getKey().clone();
                    }
                    SoftwareObjectKey[] softwareObjectKeyArray = softwareObject.getParents();
                    SoftwareObjectReference[] softwareObjectReferenceArray = softwareObject.getRequired();
                    this.addParentSoftwareObjects(softwareObjectKey2, softwareObjectKeyArray);
                    this.addRequiredSoftwareObjects(softwareObjectKey2, softwareObjectReferenceArray);
                    SoftwareObjectKey[] softwareObjectKeyArray2 = this.getSoftwareObjectKeysWithParent(softwareObjectKey4);
                    int n = 0;
                    while (n < softwareObjectKeyArray2.length) {
                        this.removeParentSoftwareObjects(softwareObjectKeyArray2[n], new SoftwareObjectKey[]{softwareObjectKey4});
                        this.addParentSoftwareObjects(softwareObjectKeyArray2[n], new SoftwareObjectKey[]{softwareObjectKey3});
                        ++n;
                    }
                    SoftwareObjectKey[] softwareObjectKeyArray3 = this.getSoftwareObjectKeysWithRequired(softwareObjectKey4);
                    SoftwareObjectReference[] softwareObjectReferenceArray2 = new SoftwareObjectReference[]{new SoftwareObjectReference(softwareObject)};
                    SoftwareObjectReference[] softwareObjectReferenceArray3 = new SoftwareObjectReference[]{new SoftwareObjectReference(softwareObject2)};
                    int n2 = 0;
                    while (n2 < softwareObjectKeyArray3.length) {
                        this.removeRequiredSoftwareObjects(softwareObjectKeyArray3[n2], softwareObjectReferenceArray2);
                        this.addRequiredSoftwareObjects(softwareObjectKeyArray3[n2], softwareObjectReferenceArray3);
                        ++n2;
                    }
                    this.removeSoftwareObject((SoftwareObjectKey)softwareObject.getKey().clone());
                } else {
                    softwareObjectKey3.setInstance(softwareObject.getKey().getInstance());
                }
            } else {
                throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaRegistryServiceImpl.updateObjectNotFound", new String[]{softwareObjectKey.toString()}));
            }
        }
        return softwareObjectKey3;
    }
}

