/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.registry;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.Product;
import com.installshield.product.ProductBean;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.SoftwareVersion;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizard.platform.hpux.extras.HpuxComponentInfoExtra;
import com.installshield.wizard.platform.hpux.extras.HpuxFeatureInfoExtra;
import com.installshield.wizard.platform.hpux.extras.HpuxProductInfoExtra;
import com.installshield.wizard.service.ServiceException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class HpuxSoftObj
extends ProductBean
implements SoftwareObject,
PropertyAccessible {
    private static final String KEY = "hpuxppk";
    public static final String bundle_str = "bundle";
    public static final String product_str = "product";
    public static final String subproduct_str = "subproduct";
    public static final String fileset_str = "fileset";
    public static final String description_str = "description";
    public static final String directory_str = "directory";
    public static final String object_class_str = "object_class";
    public static final String revision_str = "revision";
    public static final String tag_str = "tag";
    public static final String title_str = "title";
    public static final String vendor_tag_str = "vendor_tag";
    public static final String ismp_compat_vers_str = "ismp_compat_vers";
    public static final String ismp_date_built_str = "ismp_date_built";
    public static final String ismp_install_fail_opt_str = "ismp_install_fail_opt";
    public static final String ismp_replace_fail_opt_str = "ismp_replace_fail_opt";
    public static final String ismp_is_active_str = "ismp_is_active";
    public static final String ismp_is_shareable_str = "ismp_is_shareable";
    public static final String ismp_locale_str = "ismp_locale";
    public static final String ismp_location_str = "ismp_location";
    public static final String ismp_name_str = "ismp_name";
    public static final String ismp_parents_str = "ismp_parents";
    public static final String ismp_product_num_str = "ismp_product_num";
    public static final String ismp_remove_opt_str = "ismp_remove_opt";
    public static final String ismp_replace_opt_str = "ismp_replace_opt";
    public static final String ismp_required_str = "ismp_required";
    public static final String ismp_sources_str = "ismp_sources";
    public static final String ismp_status_str = "ismp_status";
    public static final String ismp_uninstaller_str = "ismp_uninstaller";
    public static final String ismp_vendor_str = "ismp_vendor";
    public static final String ismp_vendor_site_str = "ismp_vendor_site";
    public static final String always_prompt_str = "always_prompt";
    public static final String always_remove_str = "always_remove";
    public static final String always_replace_str = "always_replace";
    public static final String cancel_str = "cancel";
    public static final String cancel_and_rollback_str = "cancel_and_rollback";
    public static final String continue_str = "continue";
    public static final String default_str = "default";
    public static final String failed_str = "failed";
    public static final String installed_str = "installed";
    public static final String installing_str = "installing";
    public static final String never_remove_str = "never_remove";
    public static final String never_replace_str = "never_replace";
    public static final String prompt_if_modified_str = "prompt_if_modified";
    public static final String prompt_if_older_str = "prompt_if_older";
    public static final String ready_to_install_str = "ready_to_install";
    public static final String remove_if_unmodified_str = "remove_if_unmodified";
    public static final String replace_if_newer_str = "replace_if_newer";
    public static final String succeeded_str = "succeeded";
    public static final String uninstalled_str = "uninstalled";
    private long hpuxSOp;
    private boolean activeForUninstall = true;

    public HpuxSoftObj(long l) {
        this.hpuxSOp = l;
    }

    private native void addCompatVersion(SoftwareVersion var1) throws ServiceException;

    public native void addParent(SoftwareObjectKey var1) throws ServiceException;

    public void addParents(SoftwareObjectKey[] softwareObjectKeyArray) throws ServiceException {
        if (softwareObjectKeyArray == null || softwareObjectKeyArray.length == 0) {
            return;
        }
        HpuxSoftObj.say("addParents()  num " + softwareObjectKeyArray.length);
        SoftwareObjectKey[] softwareObjectKeyArray2 = this.getParents();
        int n = 0;
        while (n < softwareObjectKeyArray.length) {
            boolean bl = false;
            SoftwareObjectKey softwareObjectKey = softwareObjectKeyArray[n];
            HpuxSoftObj.say("addParents()  " + HpuxSoftObj.makeKeyString(softwareObjectKey));
            if (softwareObjectKeyArray2 != null) {
                int n2 = 0;
                while (n2 < softwareObjectKeyArray2.length) {
                    if (softwareObjectKeyArray2[n2].equals(softwareObjectKey)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl) {
                this.addParent(softwareObjectKey);
            }
            ++n;
        }
    }

    private native void addPrereq(SoftwareObjectKey var1) throws ServiceException;

    public void addRequired(SoftwareObjectReference[] softwareObjectReferenceArray) throws ServiceException {
        int n;
        SoftwareObjectReference[] softwareObjectReferenceArray2 = null;
        SoftwareObjectKey[] softwareObjectKeyArray = null;
        if (softwareObjectReferenceArray == null || softwareObjectReferenceArray.length == 0) {
            return;
        }
        HpuxSoftObj.say(String.valueOf(HpuxSoftObj.makeKeyString(this.getKey())) + ".addRequired()");
        softwareObjectReferenceArray2 = this.getRequired();
        if (softwareObjectReferenceArray2 != null && softwareObjectReferenceArray2.length > 0) {
            softwareObjectKeyArray = new SoftwareObjectKey[softwareObjectReferenceArray2.length];
            n = 0;
            while (n < softwareObjectReferenceArray2.length) {
                softwareObjectKeyArray[n] = softwareObjectReferenceArray2[n].getKey();
                ++n;
            }
        }
        n = 0;
        while (n < softwareObjectReferenceArray.length) {
            SoftwareObjectKey softwareObjectKey = softwareObjectReferenceArray[n].getKey();
            boolean bl = false;
            if (softwareObjectKeyArray != null) {
                int n2 = 0;
                while (n2 < softwareObjectKeyArray.length) {
                    if (softwareObjectKeyArray[n2].equals(softwareObjectKey)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl) {
                this.addPrereq(softwareObjectKey);
            }
            ++n;
        }
    }

    private native void addStringAttrib(String var1, String var2);

    private native boolean getBoolAttrib(String var1);

    private native SoftwareVersion getCompatVersion(int var1) throws ServiceException;

    public SoftwareVersion[] getCompatibleVersions() {
        SoftwareVersion[] softwareVersionArray;
        HpuxSoftObj.say("getCompatibleVersions()");
        try {
            int n = this.getNumValues(ismp_compat_vers_str);
            softwareVersionArray = new SoftwareVersion[n];
            int n2 = 0;
            while (n2 < n) {
                softwareVersionArray[n2] = this.getCompatVersion(n2);
                ++n2;
            }
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
            softwareVersionArray = new SoftwareVersion[]{};
        }
        return softwareVersionArray;
    }

    public Date getDateBuilt() {
        Date date = null;
        HpuxSoftObj.say("getDateBuilt()");
        try {
            String string = this.getStringAttrib(ismp_date_built_str);
            if (string != null) {
                DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.US);
                date = dateFormat.parse(string);
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return date;
    }

    public String getDescription() {
        return this.getStringAttrib(description_str);
    }

    public String getDisplayName() {
        return this.getStringAttrib(title_str);
    }

    public int getInstallFailureOption() {
        int n = -1;
        String string = this.getStringAttrib(ismp_install_fail_opt_str);
        if (string != null) {
            if (string.equals(always_prompt_str)) {
                n = 5;
            } else if (string.equals(cancel_str)) {
                n = 2;
            } else if (string.equals(cancel_and_rollback_str)) {
                n = 3;
            } else if (string.equals(continue_str)) {
                n = 1;
            } else if (string.equals(default_str)) {
                n = 0;
            }
        }
        HpuxSoftObj.say("getInstallFailureOption()  option " + n);
        return n;
    }

    public String getInstallLocation() {
        return this.getStringAttrib(ismp_location_str);
    }

    public int getInstallStatus() {
        int n = -1;
        String string = this.getStringAttrib(ismp_status_str);
        if (string != null) {
            if (string.equals(failed_str)) {
                n = 5;
            } else if (string.equals(installed_str)) {
                n = 3;
            } else if (string.equals(installing_str)) {
                n = 2;
            } else if (string.equals(ready_to_install_str)) {
                n = 1;
            } else if (string.equals(succeeded_str)) {
                n = 0;
            } else if (string.equals(uninstalled_str)) {
                n = 4;
            }
        }
        HpuxSoftObj.say("getInstallStatus()  status " + n);
        return n;
    }

    private native int getIntAttrib(String var1);

    public native SoftwareObjectKey getKey();

    public String getLocale() {
        return this.getStringAttrib(ismp_locale_str);
    }

    public String getName() {
        return this.getStringAttrib(ismp_name_str);
    }

    private native int getNumValues(String var1);

    private native SoftwareObjectKey getParent(int var1) throws ServiceException;

    public SoftwareObjectKey[] getParents() {
        SoftwareObjectKey[] softwareObjectKeyArray;
        HpuxSoftObj.say("getParents()");
        try {
            int n = this.getNumValues(ismp_parents_str);
            softwareObjectKeyArray = new SoftwareObjectKey[n];
            int n2 = 0;
            while (n2 < n) {
                softwareObjectKeyArray[n2] = this.getParent(n2);
                ++n2;
            }
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
            softwareObjectKeyArray = new SoftwareObjectKey[]{};
        }
        return softwareObjectKeyArray;
    }

    public String getProductNumber() {
        return this.getStringAttrib(ismp_product_num_str);
    }

    public int getRemoveOption() {
        int n = -1;
        HpuxSoftObj.say("getRemoveOption()");
        String string = this.getStringAttrib(ismp_remove_opt_str);
        if (string != null) {
            if (string.equals(always_prompt_str)) {
                n = 5;
            } else if (string.equals(always_remove_str)) {
                n = 1;
            } else if (string.equals(default_str)) {
                n = 0;
            } else if (string.equals(never_remove_str)) {
                n = 2;
            } else if (string.equals(prompt_if_modified_str)) {
                n = 4;
            } else if (string.equals(remove_if_unmodified_str)) {
                n = 3;
            }
        }
        return n;
    }

    public int getReplaceFailureOption() {
        int n = -1;
        String string = this.getStringAttrib(ismp_replace_fail_opt_str);
        if (string != null) {
            if (string.equals(always_prompt_str)) {
                n = 5;
            } else if (string.equals(cancel_str)) {
                n = 2;
            } else if (string.equals(cancel_and_rollback_str)) {
                n = 3;
            } else if (string.equals(continue_str)) {
                n = 1;
            } else if (string.equals(default_str)) {
                n = 0;
            }
        }
        HpuxSoftObj.say("getReplaceFailureOption()  option " + n);
        return n;
    }

    public int getReplaceOption() {
        int n = -1;
        HpuxSoftObj.say("getReplaceOption()");
        String string = this.getStringAttrib(ismp_replace_opt_str);
        if (string != null) {
            if (string.equals(always_prompt_str)) {
                n = 5;
            } else if (string.equals(always_replace_str)) {
                n = 1;
            } else if (string.equals(default_str)) {
                n = 0;
            } else if (string.equals(never_replace_str)) {
                n = 2;
            } else if (string.equals(prompt_if_older_str)) {
                n = 4;
            } else if (string.equals(replace_if_newer_str)) {
                n = 3;
            }
        }
        return n;
    }

    public SoftwareObjectReference[] getRequired() {
        SoftwareObjectReference[] softwareObjectReferenceArray;
        try {
            int n = this.getNumValues(ismp_required_str);
            HpuxSoftObj.say(String.valueOf(HpuxSoftObj.makeKeyString(this.getKey())) + ".getRequired()  num " + n);
            softwareObjectReferenceArray = new SoftwareObjectReference[n];
            int n2 = 0;
            while (n2 < n) {
                SoftwareObjectKey softwareObjectKey = this.getRequired(n2);
                softwareObjectReferenceArray[n2] = new SoftwareObjectReference();
                softwareObjectReferenceArray[n2].setKey(softwareObjectKey);
                HpuxSoftObj.say("  " + HpuxSoftObj.makeKeyString(softwareObjectKey));
                ++n2;
            }
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
            softwareObjectReferenceArray = new SoftwareObjectReference[]{};
        }
        return softwareObjectReferenceArray;
    }

    private native SoftwareObjectKey getRequired(int var1) throws ServiceException;

    public native String[] getSources();

    public native String getStringAttrib(String var1);

    public String getUninstaller() {
        return this.getStringAttrib(ismp_uninstaller_str);
    }

    public String getVendor() {
        return this.getStringAttrib(ismp_vendor_str);
    }

    public String getVendorWebsite() {
        return this.getStringAttrib(ismp_vendor_site_str);
    }

    public boolean isActive() {
        return this.getBoolAttrib(ismp_is_active_str);
    }

    public boolean isActiveForUninstall() {
        return this.activeForUninstall;
    }

    public boolean isPubliclyShareable() {
        return this.getBoolAttrib(ismp_is_shareable_str);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{" J[k", "Jk", "Jk ", "J[k ", ""};
        String[] stringArray3 = new String[]{"/opt/ctt", "/opt/c tt", "/opt/ctt ", "/opt/ctt /", "/opt/ctt/ ", "/", "/ ", " /", ""};
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("`" + stringArray2[n] + "' -> `" + HpuxSoftObj.makeTag(stringArray2[n]) + "'");
            ++n;
        }
        n = 0;
        while (n < stringArray3.length) {
            System.out.println("`" + stringArray3[n] + "' -> `" + HpuxSoftObj.makeDirectory(stringArray3[n]) + "'");
            ++n;
        }
    }

    private static String makeDirectory(String string) {
        String string2 = " \t\r\n[]*?!";
        String string3 = null;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (" \t\r\n[]*?!".indexOf(c) != -1) {
                string3 = string.substring(0, n2);
                int n3 = string3.lastIndexOf(47);
                if (n3 == -1) {
                    string3 = "/";
                    break;
                }
                if (n3 == 0) {
                    string3 = "/";
                    break;
                }
                string3 = string3.substring(0, n3);
                break;
            }
            ++n2;
        }
        if (string3 == null) {
            string3 = string;
        }
        if (string3 == "") {
            string3 = "/";
        }
        return string3;
    }

    public static String makeKeyString(SoftwareObjectKey softwareObjectKey) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(softwareObjectKey.getUID());
        SoftwareVersion softwareVersion = softwareObjectKey.getVersion();
        boolean bl = true;
        String string = softwareVersion.getMajor();
        if (string != null && string.length() > 0) {
            stringBuffer.append("(");
            bl = false;
            stringBuffer.append("major=");
            stringBuffer.append(string);
        }
        if ((string = softwareVersion.getMinor()) != null && string.length() > 0) {
            stringBuffer.append(bl ? "(" : ",");
            bl = false;
            stringBuffer.append("minor=");
            stringBuffer.append(string);
        }
        if ((string = softwareVersion.getMaintenance()) != null && string.length() > 0) {
            stringBuffer.append(bl ? "(" : ",");
            bl = false;
            stringBuffer.append("maint=");
            stringBuffer.append(string);
        }
        if ((string = softwareVersion.getUpdate()) != null && string.length() > 0) {
            stringBuffer.append(bl ? "(" : ",");
            bl = false;
            stringBuffer.append("update=");
            stringBuffer.append(string);
        }
        if ((string = softwareVersion.getFormatted()) != null && string.length() > 0) {
            stringBuffer.append(bl ? "(" : ",");
            bl = false;
            stringBuffer.append("format=");
            stringBuffer.append(string);
        }
        if ((n = softwareObjectKey.getInstance()) != 0) {
            stringBuffer.append(bl ? "(" : ",");
            bl = false;
            stringBuffer.append("instan=");
            stringBuffer.append(n);
        }
        if (!bl) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private static String makeTag(String string) {
        String string2 = " \t\r\n[]*?!/.,:#;&(){}|<>\"`'\\";
        int n = 63;
        StringBuffer stringBuffer = new StringBuffer(40);
        String string3 = string.trim();
        String string4 = null;
        int n2 = string3.length();
        int n3 = 0;
        while (n3 < n2 && stringBuffer.length() < 63) {
            char c = string3.charAt(n3);
            if (" \t\r\n[]*?!/.,:#;&(){}|<>\"`'\\".indexOf(c) == -1) {
                stringBuffer.append(c);
            }
            ++n3;
        }
        if (stringBuffer.length() > 0) {
            string4 = stringBuffer.toString();
        }
        return string4;
    }

    public native void removeParent(int var1) throws ServiceException;

    public void removeParents(SoftwareObjectKey[] softwareObjectKeyArray) throws ServiceException {
        HpuxSoftObj.say("removeParents()");
        if (softwareObjectKeyArray == null || softwareObjectKeyArray.length == 0) {
            return;
        }
        SoftwareObjectKey[] softwareObjectKeyArray2 = this.getParents();
        if (softwareObjectKeyArray2 == null) {
            SoftwareObjectKey softwareObjectKey = softwareObjectKeyArray[0];
        } else {
            SoftwareObjectKey softwareObjectKey = null;
            int n = 0;
            while (n < softwareObjectKeyArray.length) {
                boolean bl = false;
                SoftwareObjectKey softwareObjectKey2 = softwareObjectKeyArray[n];
                int n2 = 0;
                while (n2 < softwareObjectKeyArray2.length) {
                    SoftwareObjectKey softwareObjectKey3 = softwareObjectKeyArray2[n2];
                    if (softwareObjectKey2.equals(softwareObjectKey3)) {
                        bl = true;
                        this.removeParent(n2);
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    softwareObjectKey = softwareObjectKey2;
                }
                ++n;
            }
        }
    }

    public native void removePrereq(int var1) throws ServiceException;

    public void removeRequired(SoftwareObjectReference[] softwareObjectReferenceArray) throws ServiceException {
        HpuxSoftObj.say("removeRequired()");
        if (softwareObjectReferenceArray == null || softwareObjectReferenceArray.length == 0) {
            return;
        }
        HpuxSoftObj.say(String.valueOf(HpuxSoftObj.makeKeyString(this.getKey())) + ".removeRequired()");
        SoftwareObjectReference[] softwareObjectReferenceArray2 = this.getRequired();
        if (softwareObjectReferenceArray2 == null) {
            SoftwareObjectKey softwareObjectKey = softwareObjectReferenceArray[0].getKey();
        } else {
            SoftwareObjectKey softwareObjectKey = null;
            int n = 0;
            while (n < softwareObjectReferenceArray.length) {
                boolean bl = false;
                SoftwareObjectKey softwareObjectKey2 = softwareObjectReferenceArray[n].getKey();
                int n2 = 0;
                while (n2 < softwareObjectReferenceArray2.length) {
                    SoftwareObjectKey softwareObjectKey3 = softwareObjectReferenceArray2[n2].getKey();
                    if (softwareObjectKey2.equals(softwareObjectKey3)) {
                        bl = true;
                        this.removePrereq(n2);
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    softwareObjectKey = softwareObjectKey2;
                }
                ++n;
            }
        }
    }

    private native void removeStringAttrib(String var1);

    private static void say(String string) {
        String string2 = System.getProperty("is.debug");
        if (string2 != null && string2.length() > 0) {
            System.out.println("HpuxSoftObj: " + string);
        }
    }

    public void setActive(boolean bl) {
        try {
            this.setBoolAttrib(ismp_is_active_str, bl);
        }
        catch (ServiceException serviceException) {}
    }

    public void setActiveForUninstall(boolean bl) {
        this.activeForUninstall = bl;
    }

    public void setAttributes(SoftwareObject softwareObject, boolean bl) throws ServiceException {
        int n;
        int n2;
        String string;
        Object object;
        SoftwareVersion[] softwareVersionArray;
        String[] stringArray;
        HpuxSoftObj.say("setAttributes()");
        this.setKey(softwareObject.getKey());
        String string2 = null;
        String string3 = null;
        if (softwareObject instanceof GenericSoftwareObject) {
            stringArray = ((ProductBean)((Object)softwareObject)).getExtendedProperties();
            softwareVersionArray = stringArray.keys();
            while (softwareVersionArray.hasMoreElements()) {
                PropertyAccessible propertyAccessible;
                object = softwareVersionArray.nextElement();
                Object v = stringArray.get(object);
                HpuxSoftObj.say("Extra key: " + object.toString());
                if (object.equals("HpuxProductInfo")) {
                    propertyAccessible = (HpuxProductInfoExtra)v;
                    string = ((HpuxProductInfoExtra)propertyAccessible).getTag();
                    if (string != null && string.length() > 0) {
                        string3 = string;
                    }
                    if ((string = ((HpuxProductInfoExtra)propertyAccessible).getVendorTag()) == null || string.length() <= 0) continue;
                    string2 = string;
                    continue;
                }
                if (object.equals("HpuxFeatureInfo")) {
                    propertyAccessible = (HpuxFeatureInfoExtra)v;
                    string = ((HpuxFeatureInfoExtra)propertyAccessible).getTag();
                    if (string == null || string.length() <= 0) continue;
                    string3 = string;
                    continue;
                }
                if (!object.equals("HpuxComponentInfo") || (string = ((HpuxComponentInfoExtra)(propertyAccessible = (HpuxComponentInfoExtra)v)).getTag()) == null || string.length() <= 0) continue;
                string3 = string;
            }
        }
        this.setActive(softwareObject.isActive());
        Date date = softwareObject.getDateBuilt();
        if (date != null && date.after(new Date(0L))) {
            this.setDateBuilt(date);
        }
        if ((string = softwareObject.getDescription()) != null && string.length() > 0) {
            this.setStringAttrib(description_str, string);
        }
        if ((string = softwareObject.getDisplayName()) != null && string.length() > 0) {
            this.setDisplayName(string);
        }
        if ((n2 = softwareObject.getInstallFailureOption()) != -1) {
            this.setInstallFailureOption(n2);
        }
        if ((n2 = softwareObject.getReplaceFailureOption()) != -1) {
            this.setReplaceFailureOption(n2);
        }
        if (softwareObject instanceof GenericSoftwareObject) {
            stringArray = (GenericSoftwareObject)softwareObject;
            string = stringArray.getProductTree().getInstallLocation((ProductBean)stringArray);
        } else {
            string = softwareObject.getInstallLocation();
        }
        if (string != null && string.length() > 0) {
            if (softwareObject instanceof Product) {
                stringArray = HpuxSoftObj.makeDirectory(string);
                this.setStringAttrib(directory_str, (String)stringArray);
            }
            this.setStringAttrib(ismp_location_str, string);
        }
        if ((n2 = softwareObject.getInstallStatus()) != -1) {
            this.setInstallStatus(n2);
        }
        if ((string = softwareObject.getLocale()) != null && string.length() > 0) {
            this.setStringAttrib(ismp_locale_str, string);
        }
        if ((string = softwareObject.getProductNumber()) != null && string.length() > 0) {
            this.setStringAttrib(ismp_product_num_str, string);
        }
        this.setBoolAttrib(ismp_is_shareable_str, softwareObject.isPubliclyShareable());
        string = softwareObject.getName();
        if (string != null && string.length() > 0) {
            this.setStringAttrib(ismp_name_str, string);
            if (string3 == null) {
                string3 = HpuxSoftObj.makeTag(string);
            }
        }
        if (string3 == null) {
            string = softwareObject.getKey().getUID();
            string3 = HpuxSoftObj.makeTag(string);
        }
        this.setStringAttrib(tag_str, string3);
        n2 = softwareObject.getRemoveOption();
        if (n2 != -1) {
            this.setRemoveOption(n2);
        }
        if ((n2 = softwareObject.getReplaceOption()) != -1) {
            this.setReplaceOption(n2);
        }
        if ((string = softwareObject.getUninstaller()) != null && string.length() > 0) {
            this.setStringAttrib(ismp_uninstaller_str, string);
        }
        if ((string = softwareObject.getVendor()) != null && string.length() > 0) {
            this.setStringAttrib(ismp_vendor_str, string);
            if (string2 == null) {
                string2 = HpuxSoftObj.makeTag(string);
            }
        }
        if (string2 != null && string2.length() > 0) {
            this.setStringAttrib(vendor_tag_str, string2);
        }
        if ((string = softwareObject.getVendorWebsite()) != null && string.length() > 0) {
            this.setStringAttrib(ismp_vendor_site_str, string);
        }
        if ((stringArray = softwareObject.getSources()) != null && stringArray.length > 0) {
            this.removeStringAttrib(ismp_sources_str);
            n = 0;
            while (n < stringArray.length) {
                this.addStringAttrib(ismp_sources_str, stringArray[n]);
                ++n;
            }
        }
        if ((softwareVersionArray = softwareObject.getCompatibleVersions()) != null && softwareVersionArray.length > 0) {
            this.removeStringAttrib(ismp_compat_vers_str);
            n = 0;
            while (n < softwareVersionArray.length) {
                this.addCompatVersion(softwareVersionArray[n]);
                ++n;
            }
        }
        if (bl && (object = softwareObject.getParents()) != null && ((K)object).length > 0) {
            this.addParents((SoftwareObjectKey[])object);
        }
        if ((object = softwareObject.getRequired()) != null && ((K)object).length > 0) {
            this.addRequired((SoftwareObjectReference[])object);
        }
    }

    private native void setBoolAttrib(String var1, boolean var2) throws ServiceException;

    private void setDateBuilt(Date date) throws ServiceException {
        HpuxSoftObj.say("setDateBuilt()");
        if (date.after(new Date(0L))) {
            DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.US);
            String string = dateFormat.format(date);
            this.setStringAttrib(ismp_date_built_str, string);
        }
    }

    public void setDisplayName(String string) {
        block2: {
            if (string.length() <= 0) break block2;
            try {
                this.setStringAttrib(title_str, string);
            }
            catch (ServiceException serviceException) {}
        }
    }

    private void setInstallFailureOption(int n) throws ServiceException {
        String string = null;
        switch (n) {
            case 5: {
                string = always_prompt_str;
                break;
            }
            case 2: {
                string = cancel_str;
                break;
            }
            case 3: {
                string = cancel_and_rollback_str;
                break;
            }
            case 1: {
                string = continue_str;
                break;
            }
            case 0: {
                string = default_str;
                break;
            }
        }
        if (string == null) {
            throw new ServiceException(399, "unknown install failure option: " + n);
        }
        this.setStringAttrib(ismp_install_fail_opt_str, string);
    }

    public void setInstallStatus(int n) {
        block10: {
            String string = null;
            switch (n) {
                case 5: {
                    string = failed_str;
                    break;
                }
                case 3: {
                    string = installed_str;
                    break;
                }
                case 2: {
                    string = installing_str;
                    break;
                }
                case 1: {
                    string = ready_to_install_str;
                    break;
                }
                case 0: {
                    string = succeeded_str;
                    break;
                }
                case 4: {
                    string = uninstalled_str;
                    break;
                }
            }
            if (string == null) break block10;
            try {
                this.setStringAttrib(ismp_status_str, string);
            }
            catch (ServiceException serviceException) {}
        }
    }

    private native void setIntAttrib(String var1, int var2) throws ServiceException;

    protected native void setKey(SoftwareObjectKey var1);

    private void setRemoveOption(int n) throws ServiceException {
        String string = null;
        switch (n) {
            case 5: {
                string = always_prompt_str;
                break;
            }
            case 1: {
                string = always_remove_str;
                break;
            }
            case 0: {
                string = default_str;
                break;
            }
            case 2: {
                string = never_remove_str;
                break;
            }
            case 4: {
                string = prompt_if_modified_str;
                break;
            }
            case 3: {
                string = remove_if_unmodified_str;
                break;
            }
        }
        if (string == null) {
            throw new ServiceException(399, "unknown remove option: " + n);
        }
        this.setStringAttrib(ismp_remove_opt_str, string);
    }

    private void setReplaceFailureOption(int n) throws ServiceException {
        String string = null;
        switch (n) {
            case 5: {
                string = always_prompt_str;
                break;
            }
            case 2: {
                string = cancel_str;
                break;
            }
            case 3: {
                string = cancel_and_rollback_str;
                break;
            }
            case 1: {
                string = continue_str;
                break;
            }
            case 0: {
                string = default_str;
                break;
            }
        }
        if (string == null) {
            throw new ServiceException(399, "unknown replace failure option: " + n);
        }
        this.setStringAttrib(ismp_replace_fail_opt_str, string);
    }

    private void setReplaceOption(int n) throws ServiceException {
        String string = null;
        switch (n) {
            case 5: {
                string = always_prompt_str;
                break;
            }
            case 1: {
                string = always_replace_str;
                break;
            }
            case 0: {
                string = default_str;
                break;
            }
            case 2: {
                string = never_replace_str;
                break;
            }
            case 4: {
                string = prompt_if_older_str;
                break;
            }
            case 3: {
                string = replace_if_newer_str;
                break;
            }
        }
        if (string == null) {
            throw new ServiceException(399, "unknown replace option: " + n);
        }
        this.setStringAttrib(ismp_replace_opt_str, string);
    }

    private native void setStringAttrib(String var1, String var2) throws ServiceException;

    public native void updateParent(int var1, SoftwareObjectKey var2) throws ServiceException;

    public native void updatePrereq(int var1, SoftwareObjectKey var2) throws ServiceException;
}

