/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.security;

import com.installshield.wizard.platform.hpux.HpuxUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityServiceImplementor;
import com.installshield.wizard.service.security.UserSpecification;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HpuxSecurityServiceImpl
extends PureJavaSecurityServiceImpl
implements SecurityServiceImplementor {
    public void createGroup(GroupSpecification groupSpecification) throws ServiceException {
        StringBuffer stringBuffer = new StringBuffer("/usr/sbin/groupadd ");
        stringBuffer.append(groupSpecification.getGroupName());
        try {
            Process process = Runtime.getRuntime().exec(stringBuffer.toString());
            int n = process.waitFor();
            switch (n) {
                default: {
                    this.throwJavaServExcep(process, "Could not add group " + groupSpecification.getGroupName());
                    break;
                }
                case 0: 
                case 4: 
                case 9: {
                    return;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceException(interruptedException);
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    public void createUser(UserSpecification userSpecification) throws ServiceException {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer("/usr/sbin/useradd ");
        if (userSpecification.getUserFullName() != null) {
            stringBuffer.append("-c " + userSpecification.getUserFullName() + " ");
        }
        if (userSpecification.getHomeDirectory() != null) {
            stringBuffer.append("-d " + userSpecification.getHomeDirectory() + " ");
        }
        if (userSpecification.getAccountExpirationDate() > 0L) {
            stringBuffer.append("-e ");
            stringBuffer.append(new SimpleDateFormat("MM/dd/yyyy").format(new Date(userSpecification.getAccountExpirationDate())));
            stringBuffer.append(" ");
        }
        if (userSpecification.getGroups() != null) {
            stringBuffer.append("-G ");
            object = userSpecification.getGroups();
            n = 0;
            while (n < ((String[])object).length) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(object[n]);
                ++n;
            }
            stringBuffer.append(" ");
        }
        if (userSpecification.getHomeDirectory() != null) {
            stringBuffer.append("-m ");
        }
        stringBuffer.append(String.valueOf(userSpecification.getUserName()) + " ");
        System.out.println(stringBuffer.toString());
        try {
            object = Runtime.getRuntime().exec(stringBuffer.toString());
            n = ((Process)object).waitFor();
            if (n != 0) {
                this.throwJavaServExcep((Process)object, "Could not add user " + userSpecification.getUserName());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceException(interruptedException);
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    public void deleteGroup(String string) throws ServiceException {
        try {
            Process process = Runtime.getRuntime().exec("/usr/sbin/groupdel " + string);
            int n = process.waitFor();
            switch (n) {
                default: {
                    this.throwJavaServExcep(process, "Could not delete group " + string);
                    break;
                }
                case 0: 
                case 6: {
                    return;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceException(interruptedException);
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    public void deleteUser(String string) throws ServiceException {
        try {
            Process process = Runtime.getRuntime().exec("/usr/sbin/userdel " + string);
            int n = process.waitFor();
            if (n != 0) {
                this.throwJavaServExcep(process, "Could not delete user " + string);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceException(interruptedException);
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    public int getSystemCompatibility() {
        return HpuxUtils.getCompatibilityScore();
    }

    protected void initialized() {
        super.initialized();
        HpuxUtils.loadLibrary(this.getServices());
    }

    public native boolean isCurrentUserAdmin() throws ServiceException;

    private void throwJavaServExcep(Process process, String string) throws ServiceException {
        String string2;
        try {
            InputStream inputStream = process.getErrorStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new ServiceException(2, string);
        }
        throw new ServiceException(2, String.valueOf(string) + ": " + string2);
    }
}

