/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris;

import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.solaris.util.LibraryLoader;
import com.installshield.wizard.platform.solaris.util.MountedFileSystemTable;
import com.installshield.wizard.platform.solaris.util.SystemCompatability;
import com.installshield.wizard.platform.solaris.util.UnixAttributes;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SolarisFileServiceImpl
extends PureJavaFileServiceImpl {
    private String mnttabname = String.valueOf(File.separator) + "etc" + File.separator + "mnttab";
    private MountedFileSystemTable mnttab = null;
    private Vector readableDeferredList;

    void addToDeferredList(String string) {
        if (this.readableDeferredList == null) {
            this.readableDeferredList = new Vector();
        }
        this.readableDeferredList.addElement(string);
    }

    private native void chown(String var1, String var2, String var3) throws ServiceException;

    public void cleanup() throws ServiceException {
        if (this.readableDeferredList != null) {
            Enumeration enumeration = this.readableDeferredList.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                FileAttributes fileAttributes = this.getFileAttributes(string);
                fileAttributes.setAttributeState(73, true);
                this.setFileAttributes(string, fileAttributes);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String var1_1, boolean var2_2, boolean var3_3) throws ServiceException {
        var4_4 = 0;
        var5_5 = false;
        var6_6 = "";
        var7_7 = this.createFileName(this.getCurrentDirectory(), var1_1);
        if (this.fileExists(var7_7) && this.isDirectory(var7_7) && this.getParent(var7_7) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(var7_7)) {
            if (!var2_2 && !var3_3) {
                try {
                    var8_8 = String.valueOf(FileUtils.appendSeparator(var7_7, this.getSeparator())) + "*";
                    var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f \"" + var8_8 + "\""});
                    if (var9_14.getExitCode() == 0) {
                        var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + var7_7 + "\""});
                        if (var9_14.getExitCode() == 0) ** GOTO lbl42
                        var5_5 = true;
                        var6_6 = var9_14.getStderr();
                    }
                    var5_5 = true;
                    var6_6 = var9_14.getStderr();
                }
                catch (Exception var8_9) {
                    throw new ServiceException(var8_9);
                }
            } else if (var2_2 && !var3_3) {
                try {
                    var8_10 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + var7_7 + "\""});
                    if (var8_10.getExitCode() == 0) ** GOTO lbl42
                    var5_5 = true;
                    var6_6 = var8_10.getStderr();
                }
                catch (Exception var8_11) {
                    throw new ServiceException(var8_11);
                }
            } else if (!var2_2 && var3_3) {
                try {
                    var8_12 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf \"" + var7_7 + "\""});
                    if (var8_12.getExitCode() == 0) ** GOTO lbl42
                    var5_5 = true;
                    var6_6 = var8_12.getStderr();
                }
                catch (Exception var8_13) {
                    throw new ServiceException(var8_13);
                }
            } else {
                var4_4 = super.deleteDirectory(var1_1, var2_2, var3_3);
            }
        }
lbl42:
        // 10 sources

        if (var5_5) {
            throw new ServiceException(2, "Error deleting directory: " + var6_6);
        }
        return var4_4;
    }

    public FileAttributes getFileAttributes(String string) throws ServiceException {
        return UnixAttributes.getAttributeObject(string, this.getFileMode(string));
    }

    private native int getFileMode(String var1) throws ServiceException;

    public native String getFileOwner(String var1) throws ServiceException;

    public native String getFileOwnerGroup(String var1) throws ServiceException;

    protected String getLibraryDirectory() throws ServiceException {
        return String.valueOf(File.separator) + "usr" + File.separator + "lib";
    }

    private MountedFileSystemTable getMnttab() throws ServiceException {
        if (this.mnttab == null) {
            this.mnttab = new MountedFileSystemTable();
            this.mnttab.setFilename(this.mnttabname);
            try {
                this.mnttab.load();
            }
            catch (IOException iOException) {
                throw new ServiceException(iOException);
            }
        }
        return this.mnttab;
    }

    public String getPartitionFormat(String string) throws ServiceException {
        int n = 0;
        try {
            while (!this.mnttab.getMountPoint(n).equals(string)) {
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ServiceException(314, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "solaris.ppk.invalid.parameter", new String[]{string}));
        }
        String string2 = this.mnttab.getFstype(n);
        return string2;
    }

    public native long getPartitionFreeSpace(String var1) throws ServiceException;

    public String[] getPartitionNames() throws ServiceException {
        return this.getMnttab().getMountPoint();
    }

    public int getPartitionType(String string) throws ServiceException {
        return !(string = string.trim()).startsWith("/dev/") || !string.substring(5).endsWith("cd") && !string.substring(5).endsWith("fd") && !string.substring(5).endsWith("rmt") ? 1 : 2;
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        return String.valueOf(File.separator) + "opt";
    }

    public int getSystemCompatibility() {
        return SystemCompatability.getScore();
    }

    public native int getSystemUMask() throws ServiceException;

    protected String getTempDirectory() throws ServiceException {
        return String.valueOf(File.separator) + "tmp";
    }

    protected void initialized() {
        super.initialized();
        LibraryLoader.loadLibrary(this.getServices());
    }

    public boolean isPartitionWritable(String string) throws ServiceException {
        int n = 0;
        try {
            while (!this.mnttab.getMountPoint(n).equals(string)) {
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ServiceException(314, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "solaris.ppk.invalid.parameter", new String[]{string}));
        }
        String[] stringArray = this.mnttab.getOptions(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("rw")) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    void removeFromDeferredList(String string) {
        if (this.readableDeferredList != null && this.readableDeferredList.size() > 0) {
            this.readableDeferredList.removeElement(string);
        }
    }

    public void setFileAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        this.setFileMode(string, UnixAttributes.getMode(fileAttributes));
    }

    public void setFileCreated(String string, long l) throws ServiceException {
        this.setFileModified(string, l);
    }

    public void setFileExecutable(String string) throws ServiceException {
        FileAttributes fileAttributes = this.getFileAttributes(string);
        int n = 292;
        fileAttributes.setAttributeState(n, true);
        this.setFileMode(string, UnixAttributes.getMode(fileAttributes));
    }

    private native void setFileMode(String var1, int var2) throws ServiceException;

    public native void setFileModified(String var1, long var2) throws ServiceException;

    public void setFileOwner(String string, String string2) throws ServiceException {
        this.chown(string, string2, null);
    }

    public void setFileOwnerGroup(String string, String string2) throws ServiceException {
        this.chown(string, null, string2);
    }

    public native void setFileTimes(String var1, long var2, long var4, long var6) throws ServiceException;

    public native void setSystemUMask(int var1) throws ServiceException;

    public boolean supportsLongFileNames(String string) throws ServiceException {
        return true;
    }

    public void validateFileName(String string) throws ServiceException {
        String string2 = ":*?\"<>|";
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.charAt(n)) != -1) {
                throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{string2}));
            }
            ++n;
        }
    }
}

