/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris;

import com.installshield.wizard.platform.solaris.util.SystemCompatability;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.jvm.PureJavaJVMServiceImpl;
import java.io.File;

public class SolarisJVMServiceImpl
extends PureJavaJVMServiceImpl {
    private String getLauncherSubdir() {
        if (SystemCompatability.isX86System()) {
            return "x86";
        }
        return "sparc";
    }

    public String getPlatformId() throws ServiceException {
        return "solaris.platform." + this.getLauncherSubdir();
    }

    public String getPlatformLauncherResource() throws ServiceException {
        return "solarisppk" + File.separator + this.getLauncherSubdir() + File.separator + "launcher";
    }

    public int getSystemCompatibility() {
        return SystemCompatability.getScore();
    }

    public String getVerifyClassResource() throws ServiceException {
        return "solarisppk" + File.separator + "Verify.jar";
    }
}

