/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.service.registry.PureJavaRegistryServiceImpl;
import com.installshield.util.FileUtils;
import com.installshield.wizard.platform.solaris.extra.SolarisPkginfoExtra;
import com.installshield.wizard.platform.solaris.util.GenericTokenizer;
import com.installshield.wizard.platform.solaris.util.SystemCompatability;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisRegistryServiceImpl
extends PureJavaRegistryServiceImpl {
    private static final String solarisProductRegistry;
    private Vector deleted = new Vector();
    private static final String spaceSeparator;
    private static final String DISPLAY = "DSP";
    private static final String DISPLAY_DELIM = "DSP=";
    private boolean removeForUpdate = false;

    static {
        spaceSeparator = new String(new byte[]{32});
        solarisProductRegistry = new File(String.valueOf(File.separator) + "var" + File.separator + "sadm" + File.separator + "pkg").getAbsolutePath();
    }

    private Object assertNotNull(Object object) {
        if (object != null) {
            return object;
        }
        return "";
    }

    public void finalizeRegistry() throws ServiceException {
        this.writeVPD();
    }

    private String getNextToken(StringTokenizer stringTokenizer) {
        String string = "";
        try {
            string = stringTokenizer.nextToken();
        }
        catch (Exception exception) {}
        return string;
    }

    private String getSolarisPackageName(SoftwareObject softwareObject) {
        String string = "";
        if (softwareObject != null) {
            Dictionary dictionary = ((GenericSoftwareObject)softwareObject).getExtendedProperties();
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                if (!k.equals("solaris_pkginfo") || !(v instanceof SolarisPkginfoExtra)) continue;
                string = ((SolarisPkginfoExtra)v).getPkg();
            }
        }
        return string;
    }

    public int getSystemCompatibility() {
        if (System.getProperty("user.name", "notroot").equals("root")) {
            return SystemCompatability.getScore();
        }
        return 0;
    }

    public void initializeRegistry() throws ServiceException {
        this.readVPD();
    }

    private String keyToString(SoftwareObjectKey softwareObjectKey) {
        SoftwareVersion softwareVersion = softwareObjectKey.getVersion();
        return " uid = " + softwareObjectKey.getUID() + ", major = " + softwareVersion.getMajor() + ", minor = " + softwareVersion.getMinor() + ", maint = " + softwareVersion.getMaintenance() + ", update = " + softwareVersion.getUpdate();
    }

    private void load(Properties properties, InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine().trim();
        int n = -1;
        while (string != null) {
            n = string.indexOf("=");
            if (!string.startsWith("#") && !string.startsWith("!") && n > 0) {
                ((Hashtable)properties).put(string.substring(0, n).trim(), string.substring(n + 1).trim());
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    private SoftwareVersion[] loadCompatibleVersions(Properties properties) {
        return new SoftwareVersion[0];
    }

    private SoftwareObjectKey[] loadParents(Properties properties) {
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("ISJE_PARENTS"));
        Vector<SoftwareObjectKey> vector = new Vector<SoftwareObjectKey>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(this.loadSoftwareObjectKey(stringTokenizer.nextToken()));
        }
        Object[] objectArray = new SoftwareObjectKey[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private SoftwareObjectReference[] loadRequired(Properties properties) {
        int n = Integer.parseInt(properties.getProperty("ISJE_REQUIRED_COUNT", Integer.toString(0)));
        if (n == 0) {
            return new SoftwareObjectReference[0];
        }
        SoftwareObjectReference[] softwareObjectReferenceArray = new SoftwareObjectReference[n];
        int n2 = 0;
        while (n2 < n) {
            softwareObjectReferenceArray[n2] = this.loadSoftwareObjectReference(properties.getProperty("ISJE_REQUIRED." + (n2 + 1)));
            ++n2;
        }
        return softwareObjectReferenceArray;
    }

    private SoftwareObject loadSoftwareObject(Properties properties) {
        GenericSoftwareObject genericSoftwareObject = new GenericSoftwareObject();
        genericSoftwareObject.setName(properties.getProperty("NAME", ""));
        genericSoftwareObject.setDisplayName(properties.getProperty("ISJE_NAME", ""));
        genericSoftwareObject.setDescription(properties.getProperty("DESC", ""));
        genericSoftwareObject.setVendor(properties.getProperty("VENDOR", ""));
        genericSoftwareObject.setVendorWebsite(properties.getProperty("ISJE_WEB", ""));
        genericSoftwareObject.setProductNumber(properties.getProperty("ISJE_PRODUCT_NUMBER", ""));
        genericSoftwareObject.setInstallLocation(properties.getProperty("BASEDIR", ""));
        genericSoftwareObject.setSources(this.loadSources(properties.getProperty("ISJE_SOURCES")));
        genericSoftwareObject.setRequired(this.loadRequired(properties));
        genericSoftwareObject.setParents(this.loadParents(properties));
        genericSoftwareObject.setCompatibleVersions(this.loadCompatibleVersions(properties));
        genericSoftwareObject.setPubliclyShareable(Boolean.valueOf(properties.getProperty("ISJE_IS_PUBLICLY_SHAREABLE", new Boolean(false).toString())));
        genericSoftwareObject.setUninstaller(properties.getProperty("ISJE_UNINSTALLER"));
        genericSoftwareObject.setActive(Boolean.valueOf(properties.getProperty("ISJE_IS_ACTIVE", new Boolean(true).toString())));
        genericSoftwareObject.setInstallStatus(Integer.parseInt(properties.getProperty("ISJE_INSTALL_STATUS", Integer.toString(0))));
        genericSoftwareObject.setKey(this.loadSoftwareObjectKey(properties));
        this.setSolarisPackageName(properties, genericSoftwareObject);
        return genericSoftwareObject;
    }

    private SoftwareObjectKey loadSoftwareObjectKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        SoftwareObjectKey softwareObjectKey = new SoftwareObjectKey();
        softwareObjectKey.setUID(this.getNextToken(stringTokenizer));
        softwareObjectKey.setVersion(this.loadSoftwareVersion(this.getNextToken(stringTokenizer)));
        try {
            softwareObjectKey.setInstance(Integer.parseInt(this.getNextToken(stringTokenizer)));
        }
        catch (NumberFormatException numberFormatException) {
            softwareObjectKey.setInstance(1);
        }
        return softwareObjectKey;
    }

    private SoftwareObjectKey loadSoftwareObjectKey(Properties properties) {
        SoftwareObjectKey softwareObjectKey = new SoftwareObjectKey();
        softwareObjectKey.setUID(properties.getProperty("ISJE_UID"));
        softwareObjectKey.setVersion(this.loadSoftwareVersion(properties.getProperty("VERSION")));
        String string = properties.getProperty("PKGINST");
        int n = 1;
        if (string.indexOf(".") > 0) {
            try {
                n = Integer.parseInt(string.substring(string.indexOf(".") + 1));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        softwareObjectKey.setInstance(n);
        return softwareObjectKey;
    }

    private SoftwareObjectReference loadSoftwareObjectReference(String string) {
        GenericTokenizer genericTokenizer = new GenericTokenizer(string, 4, "|");
        SoftwareObjectReference softwareObjectReference = new SoftwareObjectReference();
        softwareObjectReference.setKey(this.loadSoftwareObjectKey(genericTokenizer.nextToken()));
        softwareObjectReference.setSources(this.loadSources(genericTokenizer.nextToken()));
        try {
            softwareObjectReference.setResolutionPreference(Integer.parseInt(genericTokenizer.nextToken()));
        }
        catch (NumberFormatException numberFormatException) {
            softwareObjectReference.setResolutionPreference(2);
        }
        softwareObjectReference.setDisplayName(genericTokenizer.nextToken());
        return softwareObjectReference;
    }

    private SoftwareVersion loadSoftwareVersion(String string) {
        GenericTokenizer genericTokenizer = new GenericTokenizer(string, 5, ".");
        SoftwareVersion softwareVersion = new SoftwareVersion();
        softwareVersion.setMajor(genericTokenizer.nextToken());
        softwareVersion.setMinor(genericTokenizer.nextToken());
        softwareVersion.setUpdate(genericTokenizer.nextToken());
        softwareVersion.setMaintenance(genericTokenizer.nextToken());
        String string2 = "";
        String string3 = genericTokenizer.nextToken();
        int n = string3.indexOf(DISPLAY_DELIM);
        if (n != -1) {
            string2 = string3.substring(n + DISPLAY_DELIM.length());
        }
        softwareVersion.setFormatted(string2);
        return softwareVersion;
    }

    private String[] loadSources(String string) {
        return new String[0];
    }

    private void readVPD() {
        File file = new File(solarisProductRegistry);
        String[] stringArray = file.list();
        FileInputStream fileInputStream = null;
        Properties properties = new Properties();
        int n = 0;
        while (n < stringArray.length) {
            try {
                ((Hashtable)properties).clear();
                File file2 = new File(new File(file.getAbsolutePath(), stringArray[n]).getAbsolutePath(), "pkginfo");
                if (file2.exists() && file2.isFile()) {
                    fileInputStream = new FileInputStream(file2);
                    this.load(properties, fileInputStream);
                    fileInputStream.close();
                    if (properties.getProperty("ISJE_NAME") != null) {
                        SoftwareObject softwareObject = this.loadSoftwareObject(properties);
                        this.insertIntoVPD(softwareObject.getKey(), softwareObject, false);
                    }
                }
            }
            catch (Exception exception) {
                this.logEvent(this, "err", exception);
            }
            ++n;
        }
    }

    public void removeSoftwareObject(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        SoftwareObject softwareObject = this.getSoftwareObject(softwareObjectKey);
        super.removeSoftwareObject(softwareObjectKey);
        if (softwareObject != null && !this.removeForUpdate) {
            this.deleted.addElement(softwareObject);
        }
    }

    private void save(Properties properties, OutputStream outputStream, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("# " + string);
        printWriter.println("# " + Calendar.getInstance().getTime().toString());
        Enumeration enumeration = ((Hashtable)properties).keys();
        String[] stringArray = new String[((Hashtable)properties).size()];
        int n = 0;
        while (n < stringArray.length) {
            String string2 = (String)enumeration.nextElement();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] == null) {
                    stringArray[n2] = string2;
                    break;
                }
                if (string2.compareTo(stringArray[n2]) < 0) {
                    int n3 = stringArray.length - 1;
                    while (n3 > n2) {
                        stringArray[n3] = stringArray[n3 - 1];
                        --n3;
                    }
                    stringArray[n2] = string2;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            printWriter.println(String.valueOf(stringArray[n4]) + "=" + properties.getProperty(stringArray[n4]));
            ++n4;
        }
        printWriter.flush();
        printWriter.close();
    }

    private void setSolarisPackageName(Properties properties, SoftwareObject softwareObject) {
        SolarisPkginfoExtra solarisPkginfoExtra = new SolarisPkginfoExtra();
        solarisPkginfoExtra.setPkg(properties.getProperty("PKG"));
        ((GenericSoftwareObject)softwareObject).getExtendedProperties().put("solaris_pkginfo", solarisPkginfoExtra);
    }

    public SoftwareObjectKey updateSoftwareObjectKeyVersion(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey softwareObjectKey2) throws ServiceException {
        this.removeForUpdate = true;
        SoftwareObjectKey softwareObjectKey3 = super.updateSoftwareObjectKeyVersion(softwareObjectKey, softwareObjectKey2);
        this.removeForUpdate = false;
        return softwareObjectKey3;
    }

    private void writeCompatibleVersions(Properties properties, SoftwareVersion[] softwareVersionArray) {
    }

    private void writeParents(Properties properties, SoftwareObjectKey[] softwareObjectKeyArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < softwareObjectKeyArray.length) {
            stringBuffer.append(this.writeSoftwareObjectKey(softwareObjectKeyArray[n])).append(spaceSeparator);
            ++n;
        }
        ((Hashtable)properties).put("ISJE_PARENTS", stringBuffer.toString());
    }

    private void writePreremoveScript(File file, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#!/bin/sh").append('\n');
        stringBuffer.append("echo \"ISMP Multiplatform...\"").append('\n');
        if (string != null && new File(string).exists()) {
            stringBuffer.append("echo \"This Solaris Package should be uninstalled only using the Multiplatform product uninstaller located at " + string + "\"").append('\n');
        } else {
            stringBuffer.append("echo \"This Solaris Package should be uninstalled only using the Multiplatform product uninstaller\"").append('\n');
        }
        stringBuffer.append("exit 1").append('\n');
        FileOutputStream fileOutputStream = new FileOutputStream(new File(file, "preremove"));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        FileUtils.copy(byteArrayInputStream, fileOutputStream);
        byteArrayInputStream.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private void writeRequired(Properties properties, SoftwareObjectReference[] softwareObjectReferenceArray) {
        if (softwareObjectReferenceArray.length > 0) {
            ((Hashtable)properties).put("ISJE_REQUIRED_COUNT", Integer.toString(softwareObjectReferenceArray.length));
            int n = 0;
            while (n < softwareObjectReferenceArray.length) {
                ((Hashtable)properties).put("ISJE_REQUIRED." + (n + 1), this.writeSoftwareObjectReference(softwareObjectReferenceArray[n]));
                ++n;
            }
        } else {
            ((Hashtable)properties).put("ISJE_REQUIRED_COUNT", Integer.toString(0));
        }
    }

    private void writeSoftwareObject(Properties properties, SoftwareObject softwareObject) {
        block5: {
            if (this.deleted.contains(softwareObject)) break block5;
            ((Hashtable)properties).put("NAME", (String)this.assertNotNull(softwareObject.getName()));
            ((Hashtable)properties).put("ISJE_NAME", (String)this.assertNotNull(softwareObject.getDisplayName()));
            ((Hashtable)properties).put("DESC", (String)this.assertNotNull(softwareObject.getDescription()));
            ((Hashtable)properties).put("VENDOR", (String)this.assertNotNull(softwareObject.getVendor()));
            ((Hashtable)properties).put("ISJE_WEB", (String)this.assertNotNull(softwareObject.getVendorWebsite()));
            ((Hashtable)properties).put("ISJE_PRODUCT_NUMBER", (String)this.assertNotNull(softwareObject.getProductNumber()));
            ((Hashtable)properties).put("BASEDIR", (String)this.assertNotNull(softwareObject.getInstallLocation()));
            ((Hashtable)properties).put("ISJE_SOURCES", this.writeSources(softwareObject.getSources()));
            this.writeRequired(properties, softwareObject.getRequired());
            this.writeParents(properties, softwareObject.getParents());
            this.writeCompatibleVersions(properties, softwareObject.getCompatibleVersions());
            ((Hashtable)properties).put("ISJE_IS_PUBLICLY_SHAREABLE", new Boolean(softwareObject.isPubliclyShareable()).toString());
            ((Hashtable)properties).put("ISJE_UNINSTALLER", (String)this.assertNotNull(softwareObject.getUninstaller()));
            ((Hashtable)properties).put("ISJE_IS_ACTIVE", new Boolean(softwareObject.isActive()).toString());
            ((Hashtable)properties).put("ISJE_INSTALL_STATUS", Integer.toString(softwareObject.getInstallStatus()));
            this.writeSoftwareObjectKey(properties, softwareObject.getKey());
            ((Hashtable)properties).put("CATEGORY", "application");
            ((Hashtable)properties).put("ARCH", System.getProperty("os.arch"));
            ((Hashtable)properties).put("ISJE_VPD_VERSION", "4.5");
            ((Hashtable)properties).put("CLASSES", "none");
            try {
                File file = new File(new File(solarisProductRegistry, properties.getProperty("PKGINST")).getAbsolutePath(), "pkginfo");
                File file2 = new File(file.getParent());
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
                this.save(properties, fileOutputStream, "VPD  created by InstallShield MultiPlatform Edition");
                fileOutputStream.close();
                file = new File(new File(solarisProductRegistry, properties.getProperty("PKGINST")).getAbsolutePath(), "install");
                file.mkdir();
                if (file.exists() && file.isDirectory()) {
                    this.writePreremoveScript(file, softwareObject.getUninstaller());
                } else {
                    this.logEvent(this, "wrn", "'install' directory can't be created while registering the solaris software package - " + softwareObject.getName());
                }
                file = new File(new File(solarisProductRegistry, properties.getProperty("PKGINST")).getAbsolutePath(), "save");
                file.mkdir();
            }
            catch (Exception exception) {
                this.logEvent(this, "wrn", exception);
            }
        }
    }

    private String writeSoftwareObjectKey(SoftwareObjectKey softwareObjectKey) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(softwareObjectKey.getUID()).append(":");
        stringBuffer.append(this.writeSoftwareVersion(softwareObjectKey.getVersion())).append(":");
        stringBuffer.append(Integer.toString(softwareObjectKey.getInstance()));
        return stringBuffer.toString();
    }

    private void writeSoftwareObjectKey(Properties properties, SoftwareObjectKey softwareObjectKey) {
        ((Hashtable)properties).put("ISJE_UID", softwareObjectKey.getUID().trim());
        ((Hashtable)properties).put("VERSION", this.writeSoftwareVersion(softwareObjectKey.getVersion()));
        try {
            String string = this.getSolarisPackageName(this.getSoftwareObject(softwareObjectKey));
            if (string.length() == 0) {
                string = "IS" + softwareObjectKey.getUID().substring(0, 7);
            }
            if (softwareObjectKey.getInstance() > 1) {
                ((Hashtable)properties).put("PKGINST", String.valueOf(string) + "." + softwareObjectKey.getInstance());
            } else {
                ((Hashtable)properties).put("PKGINST", string);
            }
            ((Hashtable)properties).put("PKG", string);
        }
        catch (ServiceException serviceException) {}
    }

    private String writeSoftwareObjectReference(SoftwareObjectReference softwareObjectReference) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.writeSoftwareObjectKey(softwareObjectReference.getKey())).append("|");
        stringBuffer.append(this.writeSources(softwareObjectReference.getSources())).append("|");
        stringBuffer.append(Integer.toString(softwareObjectReference.getResolutionPreference())).append("|");
        stringBuffer.append(softwareObjectReference.getDisplayName());
        return stringBuffer.toString();
    }

    private String writeSoftwareVersion(SoftwareVersion softwareVersion) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(softwareVersion.getMajor()).append(".");
        stringBuffer.append(softwareVersion.getMinor()).append(".");
        stringBuffer.append(softwareVersion.getUpdate()).append(".");
        stringBuffer.append(softwareVersion.getMaintenance()).append(".").append(DISPLAY).append("=");
        stringBuffer.append(softwareVersion.getFormatted());
        return stringBuffer.toString();
    }

    private String writeSources(String[] stringArray) {
        return "";
    }

    private void writeVPD() {
        try {
            Object object;
            FileService fileService = (FileService)this.getServices().getService("fileService");
            Enumeration enumeration = this.deleted.elements();
            while (enumeration.hasMoreElements()) {
                int n;
                object = (GenericSoftwareObject)enumeration.nextElement();
                String string = this.getSolarisPackageName((SoftwareObject)object);
                if (string.length() == 0) {
                    string = "IS" + ((GenericSoftwareObject)object).getKey().getUID().substring(0, 7);
                }
                if ((n = ((GenericSoftwareObject)object).getKey().getInstance()) > 1) {
                    string = String.valueOf(string) + "." + n;
                }
                fileService.deleteDirectory(new File(solarisProductRegistry, string).getAbsolutePath(), false, true);
            }
            object = new Properties();
            enumeration = this.getModifiedSoftwarePackages();
            while (enumeration.hasMoreElements()) {
                ((Hashtable)object).clear();
                this.writeSoftwareObject((Properties)object, (GenericSoftwareObject)enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }
}

