/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.solaris.util.SystemCompatability;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityServiceImplementor;
import com.installshield.wizard.service.security.UserSpecification;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SolarisSecurityServiceImpl
extends PureJavaSecurityServiceImpl
implements SecurityServiceImplementor {
    public boolean canCurrentUserWrite(String string) throws ServiceException {
        return new File(string).canWrite();
    }

    public void createGroup(GroupSpecification groupSpecification) throws ServiceException {
        try {
            Process process = Runtime.getRuntime().exec("/usr/sbin/groupadd " + groupSpecification.getGroupName());
            int n = process.waitFor();
            switch (n) {
                default: {
                    throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "security.createGroupError", new String[]{Integer.toString(n)}));
                }
                case 0: 
                case 9: {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceException(interruptedException);
        }
    }

    public void createUser(UserSpecification userSpecification) throws ServiceException {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/usr/sbin/useradd ");
        if (userSpecification.getUserFullName() != null) {
            stringBuffer.append("-c " + userSpecification.getUserFullName() + " ");
        }
        if (userSpecification.getHomeDirectory() != null) {
            stringBuffer.append("-d " + userSpecification.getHomeDirectory() + " ");
        }
        if (userSpecification.getAccountExpirationDate() > 0L) {
            stringBuffer.append("-e ");
            stringBuffer.append(new SimpleDateFormat("MM/dd/yyyy").format(new Date(userSpecification.getAccountExpirationDate())));
            stringBuffer.append(" ");
        }
        if (userSpecification.getGroups() != null) {
            stringBuffer.append("-G ");
            object = userSpecification.getGroups();
            n = 0;
            while (n < ((String[])object).length) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(object[n]);
                ++n;
            }
            stringBuffer.append(" ");
        }
        if (userSpecification.getHomeDirectory() != null) {
            stringBuffer.append("-m ");
        }
        stringBuffer.append(String.valueOf(userSpecification.getUserName()) + " ");
        try {
            object = Runtime.getRuntime().exec(stringBuffer.toString());
            n = ((Process)object).waitFor();
            if (n != 0) {
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "security.addUserError"));
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceException(interruptedException);
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    public void deleteGroup(String string) throws ServiceException {
        try {
            Process process = Runtime.getRuntime().exec("/usr/sbin/groupdel " + string);
            int n = process.waitFor();
            switch (n) {
                default: {
                    throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "security.deleteGroupError", new String[]{Integer.toString(n)}));
                }
                case 0: 
                case 6: {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceException(interruptedException);
        }
    }

    public void deleteUser(String string) throws ServiceException {
        try {
            Process process = Runtime.getRuntime().exec("/usr/sbin/userdel " + string);
            int n = process.waitFor();
            if (n != 0) {
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "security.deleteUserError", new String[]{Integer.toString(n)}));
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceException(interruptedException);
        }
    }

    public int getSystemCompatibility() {
        return SystemCompatability.getScore();
    }

    public boolean isCurrentUserAdmin() throws ServiceException {
        return System.getProperty("user.name").equals("root");
    }
}

