/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.LockedFilesHandler;
import com.installshield.wizard.platform.common.environment.BashShellManager;
import com.installshield.wizard.platform.common.environment.BourneShellManager;
import com.installshield.wizard.platform.common.environment.CShellManager;
import com.installshield.wizard.platform.common.environment.EnvironmentVariableManagerGroup;
import com.installshield.wizard.platform.common.environment.ScriptEnvironmentVariableManager;
import com.installshield.wizard.platform.solaris.util.Environment;
import com.installshield.wizard.platform.solaris.util.LibraryLoader;
import com.installshield.wizard.platform.solaris.util.LockedFileUtils;
import com.installshield.wizard.platform.solaris.util.ProcessEnvironmentVariableManager;
import com.installshield.wizard.platform.solaris.util.SystemCompatability;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilServiceImplementor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class SolarisSystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl
implements SystemUtilServiceImplementor,
LockedFilesHandler {
    public static final String PLATFORM_ID = "solaris";
    private static final String systemCshScript = "/etc/.login";
    private static final String userCshScript = ".login";
    private static final String systemBourneScript = "/etc/profile";
    private static final String userBourneScript = ".profile";
    private static final String userBashProfileScript = ".bash_profile";
    private static final String userBashLoginScript = ".bash_login";
    private static EnvironmentVariableManagerGroup userEnvVarGroup;
    private static EnvironmentVariableManagerGroup systemEnvVarGroup;
    private static boolean envVarsCleanedUp;
    private ProcessEnvironmentVariableManager currentProcessEnvVarManager;

    static {
        envVarsCleanedUp = false;
    }

    public void appendEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.appendVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.appendVariable(string, string2, string3);
    }

    public void cleanup() throws ServiceException {
        if (!envVarsCleanedUp) {
            if (userEnvVarGroup != null) {
                userEnvVarGroup.makeUpdatePersistent();
            }
            if (systemEnvVarGroup != null) {
                systemEnvVarGroup.makeUpdatePersistent();
            }
            envVarsCleanedUp = true;
        }
    }

    public void deleteEnvironmentVariable(String string) throws ServiceException {
        this.deleteEnvironmentVariable(string, 2);
    }

    public void deleteEnvironmentVariable(String string, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.deleteVariable(string);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.deleteVariable(string);
    }

    public void deleteFilesAfterExit() {
        this.say("deleteFilesAfterExit()");
        String string = LockedFileUtils.getLockedFileRemover();
        if (!new File(string).exists()) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Cleanup script does not exist: " + string);
            }
            return;
        }
        FileUtils.clearTempFile(string);
        this.removeFileToDeleteOnExit(string);
        String string2 = this.writeDirsToDelete();
        FileUtils.clearTempFile(string2);
        this.removeFileToDeleteOnExit(string2);
        Enumeration enumeration = this.filesToDeleteOnExit();
        if (enumeration.hasMoreElements()) {
            FileOutputStream fileOutputStream = null;
            PrintWriter printWriter = null;
            try {
                try {
                    String string3 = FileUtils.createTempFile();
                    fileOutputStream = new FileOutputStream(string3);
                    printWriter = new PrintWriter(fileOutputStream);
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        printWriter.println(string4);
                        this.removeFileToDeleteOnExit(string4);
                    }
                    printWriter.println(string);
                    printWriter.println(string3);
                    printWriter.println(string2);
                    printWriter.flush();
                    printWriter.close();
                    printWriter = null;
                    FileUtils.clearTempFile(string3);
                    Vector<String> vector = new Vector<String>(10);
                    vector.addElement(string);
                    vector.addElement("-F");
                    vector.addElement(string3);
                    if (string2 != null && string2.length() > 0) {
                        vector.addElement("-R");
                        vector.addElement(string2);
                    }
                    if (System.getProperty("is.debug") != null) {
                        vector.addElement("-d");
                    }
                    String[] stringArray = new String[vector.size()];
                    this.say("running cmdArray:");
                    int n = 0;
                    while (n < vector.size()) {
                        stringArray[n] = (String)vector.elementAt(n);
                        this.say("  " + stringArray[n]);
                        ++n;
                    }
                    Process process = Runtime.getRuntime().exec(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var7_13 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Throwable throwable) {
                Object var7_14 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
        }
    }

    private EnvironmentVariableManagerGroup getEnvVarGroup(int n) throws ServiceException {
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = null;
        ScriptEnvironmentVariableManager scriptEnvironmentVariableManager = null;
        if (this.currentProcessEnvVarManager == null) {
            this.currentProcessEnvVarManager = new ProcessEnvironmentVariableManager();
        }
        try {
            if (n == 1 && System.getProperty("user.name").equals("root")) {
                if (systemEnvVarGroup == null) {
                    systemEnvVarGroup = new EnvironmentVariableManagerGroup();
                    String string = systemBourneScript;
                    if (new File(string).exists()) {
                        scriptEnvironmentVariableManager = new BourneShellManager(string);
                        scriptEnvironmentVariableManager.initialize();
                        systemEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if (new File(string = systemCshScript).exists()) {
                        scriptEnvironmentVariableManager = new CShellManager(string);
                        scriptEnvironmentVariableManager.initialize();
                        systemEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                }
                environmentVariableManagerGroup = systemEnvVarGroup;
            } else if (n == 2) {
                if (userEnvVarGroup == null) {
                    userEnvVarGroup = new EnvironmentVariableManagerGroup();
                    File file = new File(System.getProperty("user.home"), userBourneScript);
                    if (file.exists()) {
                        scriptEnvironmentVariableManager = new BourneShellManager(file.getAbsolutePath());
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if ((file = new File(System.getProperty("user.home"), userBashProfileScript)).exists()) {
                        scriptEnvironmentVariableManager = new BashShellManager(file.getAbsolutePath());
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if ((file = new File(System.getProperty("user.home"), userBashLoginScript)).exists()) {
                        scriptEnvironmentVariableManager = new BashShellManager(file.getAbsolutePath());
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if ((file = new File(System.getProperty("user.home"), userCshScript)).exists()) {
                        scriptEnvironmentVariableManager = new CShellManager(file.getAbsolutePath());
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                }
                environmentVariableManagerGroup = userEnvVarGroup;
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        return environmentVariableManagerGroup;
    }

    public String getEnvironmentVariable(String string) throws ServiceException {
        return Environment.getProcessEnvironmentVariable(string);
    }

    protected String getPlatformIdImpl() {
        return PLATFORM_ID;
    }

    public String getRawEnvironmentVariable(String string, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            return environmentVariableManagerGroup.getVariable(string);
        }
        return null;
    }

    public int getSystemCompatibility() {
        return SystemCompatability.getScore();
    }

    protected void initialized() {
        super.initialized();
        LockedFileUtils.initializeLockedFileSupport(this.getServices());
        LibraryLoader.loadLibrary(this.getServices());
    }

    public void prependEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.prependVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.prependVariable(string, string2, string3);
    }

    private void say(String string) {
        if (System.getProperty("is.debug") != null) {
            System.out.println("SolarisSystemUtilServiceImpl: " + string);
        }
    }

    public void setEnvironmentVariable(String string, String string2) throws ServiceException {
        this.setEnvironmentVariable(string, string2, 2);
    }

    public void setEnvironmentVariable(String string, String string2, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.setVariable(string, string2);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.setVariable(string, string2);
    }

    public void unAppendEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.unAppendVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unAppendVariable(string, string2, string3);
    }

    public void unPrependEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.unPrependVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unPrependVariable(string, string2, string3);
    }

    private void verifyVariableName(String string) throws ServiceException {
        if (string == null || string.length() == 0) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "systemUtil.variableNameRequired"));
        }
    }

    private String writeDirsToDelete() {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        String string = "";
        try {
            block7: {
                try {
                    Enumeration enumeration = super.directoriesToRecursivelyDeleteOnExit();
                    string = FileUtils.createTempFile();
                    fileOutputStream = new FileOutputStream(string);
                    printWriter = new PrintWriter(fileOutputStream);
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        printWriter.println(string2);
                        this.removeFileToDeleteOnExit(string2);
                    }
                }
                catch (IOException iOException) {
                    if (System.getProperty("is.debug") == null) break block7;
                    System.out.println("Unable to write file containing directories to recursively delete: " + iOException);
                    iOException.printStackTrace();
                }
            }
            Object var5_7 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
        return string;
    }
}

