/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris.util;

import java.util.Enumeration;
import java.util.Vector;

public class SystemCompatability {
    private static int score = -1;
    private static Vector osName = new Vector();
    private static Vector osArchSparc = new Vector();
    private static Vector osArchx86 = new Vector();

    static {
        osName.addElement("solaris");
        osName.addElement("sunos");
        osArchSparc.addElement("sparc");
        osArchx86.addElement("x86");
    }

    private SystemCompatability() {
    }

    public static int getScore() {
        if (score == -1) {
            score = SystemCompatability.isSystemCompatible(osArchSparc) || SystemCompatability.isSystemCompatible(osArchx86) ? 5 : 0;
        }
        return score;
    }

    public static int getSolarisSparcCompatibilityScore() {
        return SystemCompatability.isSparcSystem() ? 5 : 0;
    }

    public static int getSolarisx86CompatibilityScore() {
        return SystemCompatability.isX86System() ? 5 : 0;
    }

    private static boolean isPresent(String string, Enumeration enumeration) {
        boolean bl = false;
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string.regionMatches(true, 0, string2, 0, string2.length())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isSparcSystem() {
        return SystemCompatability.isSystemCompatible(osArchSparc);
    }

    private static boolean isSystemCompatible(Vector vector) {
        return !(!SystemCompatability.isPresent(System.getProperty("os.name").toLowerCase(), osName.elements()) || !SystemCompatability.isPresent(System.getProperty("os.arch").toLowerCase(), vector.elements()) || !System.getProperty("os.version").equals("2.x") && Double.valueOf(System.getProperty("os.version")) < 2.6);
    }

    public static boolean isX86System() {
        return SystemCompatability.isSystemCompatible(osArchx86);
    }

    public static void main(String[] stringArray) {
        System.out.println(SystemCompatability.getScore());
    }
}

