/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductTree;
import com.installshield.product.service.product.ProductServiceImplementor;
import com.installshield.product.service.product.PureJavaProductServiceImpl;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;

public class Win32ProductServiceImpl
extends PureJavaProductServiceImpl
implements ProductServiceImplementor {
    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{"productService", Win32Utils.getJNIDLLName()}));
            exception.printStackTrace();
        }
    }

    public void registerUninstaller(ProductTree productTree) throws ServiceException {
        FileService fileService;
        String string = productTree.getUninstallerLauncher().getInstalledFileName();
        if (string != null && string.trim().length() != 0 && (fileService = (FileService)this.getServices().getService("fileService")).fileExists(string)) {
            ProductBean productBean = productTree.getRoot();
            String string2 = productBean.getDisplayName();
            String string3 = productBean.getBeanId();
            if (productBean instanceof GenericSoftwareObject) {
                String string4 = ((GenericSoftwareObject)productBean).getLocalizedDisplayName();
                if (string4 != null && string4.trim().length() > 0) {
                    string2 = string4;
                }
                string3 = ((GenericSoftwareObject)productBean).getKey().getUID();
            }
            this.win32RegisterUninstaller(string3, this.getServices().resolveString(string2), string);
        }
    }

    public void unregisterUninstaller(ProductTree productTree) throws ServiceException {
        if (this.canDeleteUninstaller(productTree)) {
            ProductBean productBean = productTree.getRoot();
            String string = productBean.getDisplayName();
            String string2 = productBean.getBeanId();
            if (productBean instanceof GenericSoftwareObject) {
                String string3 = ((GenericSoftwareObject)productBean).getLocalizedDisplayName();
                if (string3 != null && string3.trim().length() > 0) {
                    string = string3;
                }
                string2 = ((GenericSoftwareObject)productBean).getKey().getUID();
            }
            this.win32UnregisterUninstaller(string2, this.getServices().resolveString(string));
        }
    }

    public native void win32RegisterUninstaller(String var1, String var2, String var3) throws ServiceException;

    public native void win32UnregisterUninstaller(String var1, String var2) throws ServiceException;
}

