/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.console.ConsoleChoice;
import com.installshield.wizard.console.DefaultConsoleWizardPanelImpl;
import com.installshield.wizardx.panels.UserInputField;
import com.installshield.wizardx.panels.UserInputPanel;

public class UserInputPanelConsoleImpl
extends DefaultConsoleWizardPanelImpl {
    protected void consoleInteraction(TTYDisplay tTYDisplay) {
        super.consoleInteraction(tTYDisplay);
        boolean bl = true;
        int n = 0;
        while (bl && n < this.getUIP().getFields().length) {
            if (n > 0) {
                tTYDisplay.printLine();
            }
            bl = this.consoleInteraction(tTYDisplay, this.getUIP().getFields()[n]);
            ++n;
        }
        this.getUI().setStopped(bl ^ true);
    }

    protected boolean consoleInteraction(TTYDisplay tTYDisplay, UserInputField userInputField) {
        if (userInputField.isEditable()) {
            if (userInputField.isList()) {
                return this.listInteraction(tTYDisplay, userInputField);
            }
            return this.textInteraction(tTYDisplay, userInputField);
        }
        return this.labelInteraction(tTYDisplay, userInputField);
    }

    private UserInputPanel getUIP() {
        return (UserInputPanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.getUIP().setValidateFieldsOnExit(true);
    }

    protected boolean labelInteraction(TTYDisplay tTYDisplay, UserInputField userInputField) {
        String string = this.resolveString(userInputField.getCaption());
        if (string.length() > 0) {
            tTYDisplay.printLine(MnemonicString.stripMn(string));
        }
        tTYDisplay.printLine(this.resolveString(userInputField.getValue()));
        return true;
    }

    protected boolean listInteraction(TTYDisplay tTYDisplay, UserInputField userInputField) {
        String string = this.resolveString(userInputField.getCaption());
        if (string.length() > 0) {
            tTYDisplay.printLine(MnemonicString.stripMn(string));
            tTYDisplay.printLine();
        }
        ConsoleChoice consoleChoice = new ConsoleChoice();
        consoleChoice.setMultiSelect(userInputField.isMultiSelectList());
        consoleChoice.setOptions(new String[userInputField.getChoices().length]);
        int n = 0;
        while (n < consoleChoice.getOptions().length) {
            consoleChoice.getOptions()[n] = MnemonicString.stripMn(this.resolveString(userInputField.getChoices()[n].getDisplayName()));
            consoleChoice.setSelected(n, userInputField.isChoiceSelected(n));
            ++n;
        }
        consoleChoice.consoleInteraction(tTYDisplay);
        int n2 = 0;
        while (n2 < consoleChoice.getOptions().length) {
            userInputField.setChoiceSelected(n2, consoleChoice.isSelected(n2));
            ++n2;
        }
        return true;
    }

    protected boolean promptToContinue(TTYDisplay tTYDisplay) {
        tTYDisplay.printLine();
        tTYDisplay.printLine("1. " + LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "UserInputPanel.respecifyValue"));
        tTYDisplay.printLine("2. " + LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "UserInputPanel.cancelValue"));
        tTYDisplay.printLine();
        int n = tTYDisplay.promptInt(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "UserInputPanel.enterCommand"), 1, 1, 2);
        tTYDisplay.printLine();
        tTYDisplay.printLine();
        return n == 1;
    }

    protected boolean textInteraction(TTYDisplay tTYDisplay, UserInputField userInputField) {
        String string = this.resolveString(userInputField.getCaption());
        if (string.length() == 0) {
            string = userInputField.getType() == 5 ? LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "UserInputPanel.enterDirectory") : (userInputField.getType() == 4 ? LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "UserInputPanel.enterFile") : (userInputField.getType() == 3 ? LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "UserInputPanel.enterPassword") : LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "UserInputPanel.enterValue")));
        }
        String string2 = userInputField.getValue();
        do {
            String string3;
            userInputField.setValue(string2);
            if (userInputField.getType() == 3) {
                if (tTYDisplay.isAccessibilityEnabled()) {
                    String string4 = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "pressEnterToContinue");
                    tTYDisplay.printLine(MnemonicString.stripMn(string));
                    tTYDisplay.prompt(MnemonicString.stripMn(string4));
                    String string5 = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "PasswordPanel.label");
                    string3 = tTYDisplay.promptPassword(MnemonicString.stripMn(string5));
                } else {
                    string3 = tTYDisplay.promptPassword(MnemonicString.stripMn(string));
                }
            } else {
                string3 = tTYDisplay.prompt(MnemonicString.stripMn(string), this.resolveString(userInputField.getValue()));
            }
            userInputField.setValue(string3);
            tTYDisplay.printLine();
            if (!this.getUIP().validateField(userInputField)) continue;
            return true;
        } while (this.promptToContinue(tTYDisplay));
        return false;
    }
}

