/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.quick.engine;

import com.jxml.quick.QContext;
import com.jxml.quick.QDoc;
import com.jxml.quick.QPE;
import com.jxml.quick.access.QAccess;
import com.jxml.quick.engine.QElementFactory;
import com.jxml.quick.tf.QTargetFactory;
import java.util.Hashtable;
import java.util.Vector;

public final class QDocImpl
implements QDoc {
    QContext context = null;
    Object root = null;
    long walkCounter = 0L;
    Hashtable idMap = new Hashtable();
    Hashtable valueMap = new Hashtable();
    Mark lastMark = null;
    Object lastValue = null;
    Hashtable unresolved = new Hashtable();
    long gen;

    public QDocImpl() {
    }

    public QDocImpl(QContext qContext) {
        this.context = qContext;
    }

    void beginWalk() {
        ++this.walkCounter;
        this.gen = System.currentTimeMillis();
    }

    void end() throws QPE {
        if (this.unresolved.size() > 0) {
            this.context.throwPE("Unresolved idref: " + this.unresolved.keys().nextElement());
        }
        this.context = null;
        this.unresolved = null;
    }

    public String getId(Object object) throws QPE {
        if (this.isKnown(object)) {
            Mark mark = this.getMark(object);
            return mark.id;
        }
        String string = "genid_" + this.gen++;
        this.setId(string, object);
        return string;
    }

    Mark getMark(Object object) {
        if (object == this.lastValue) {
            return this.lastMark;
        }
        this.lastMark = (Mark)this.valueMap.get(object);
        this.lastValue = object;
        return this.lastMark;
    }

    public Object getRoot() {
        return this.root;
    }

    boolean isKnown(Object object) {
        return this.getMark(object) != null;
    }

    boolean isMarked(Object object) {
        return this.getMark((Object)object).walkCount == this.walkCounter;
    }

    void mark(Object object) {
        this.getMark((Object)object).walkCount = this.walkCounter;
    }

    void resolve(String string, QAccess qAccess, Object object, QTargetFactory qTargetFactory, QElementFactory.QElement qElement) throws QPE {
        Object v = this.idMap.get(string);
        if (v != null) {
            if (qElement.matchClasses(v) == null) {
                this.context.throwPE("ref type mismatch: " + string);
            }
            qAccess.add(object, qTargetFactory, v, this.context);
            return;
        }
        Put put = new Put(qAccess, object, qTargetFactory, qElement, this.context);
        Vector<Put> vector = (Vector<Put>)this.unresolved.get(string);
        if (vector == null) {
            vector = new Vector<Put>();
            this.unresolved.put(string, vector);
        }
        vector.addElement(put);
    }

    public void setId(String string, Object object) throws QPE {
        Object object2;
        if ("".equals(string)) {
            this.context.throwPE("ID may not be empty");
        }
        if ((object2 = this.idMap.put(string, object)) != null) {
            this.context.throwPE("duplicate ID: " + string);
        }
        this.lastValue = object;
        this.lastMark = new Mark(string);
        this.valueMap.put(object, this.lastMark);
        if (this.unresolved == null) {
            return;
        }
        Vector vector = (Vector)this.unresolved.remove(string);
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Put put = (Put)vector.elementAt(n2);
            put.add(string, object, this.context);
            ++n2;
        }
    }

    public void setRoot(Object object) {
        this.root = object;
    }

    static final class Put {
        QAccess access;
        Object parent;
        QTargetFactory parentFactory;
        QElementFactory.QElement element;
        int reserved;

        Put(QAccess qAccess, Object object, QTargetFactory qTargetFactory, QElementFactory.QElement qElement, QContext qContext) throws QPE {
            this.access = qAccess;
            this.parent = object;
            this.parentFactory = qTargetFactory;
            this.element = qElement;
            this.reserved = qAccess.reserve(object, qContext);
        }

        void add(String string, Object object, QContext qContext) throws QPE {
            if (this.element.matchClasses(object) == null) {
                qContext.throwPE("ref type mismatch: " + string);
            }
            this.access.set(this.reserved, this.parent, this.parentFactory, object, qContext);
        }
    }

    public static class Mark {
        String id;
        long walkCount = 0L;

        public Mark(String string) {
            this.id = string;
        }
    }
}

