/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Box;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.VisDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

final class BoxWord
extends Box {
    private int base_line;
    private int add_base;
    private int text_width;
    private int space_width;
    private int font_idx;
    private String text;
    private boolean doLeadingSpace;
    private boolean is_space = false;
    private boolean underline = false;
    private boolean strikeout = false;

    BoxWord(DocContainer docContainer, int n, String string, boolean bl) {
        super(docContainer);
        this.text = string;
        this.font_idx = n;
        this.is_space = bl;
        this.height = -1;
    }

    void setUnderline() {
        this.underline = true;
    }

    void setStrikeout() {
        this.strikeout = true;
    }

    void setVerticalPosition(int n) {
        this.add_base = 8 * n;
    }

    void setSelected(boolean bl) {
        if (bl != this.selected) {
            super.setSelected(bl);
            this.doc.repaintBox(this);
        }
    }

    void paint(Graphics graphics) {
        if (this.selected) {
            graphics.setColor(this.doc.getSelBackColor());
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(this.doc.getSelColor());
        } else {
            if (this.backColor != null) {
                graphics.setColor(this.backColor);
                graphics.fillRect(0, 0, this.width, this.height);
            }
            graphics.setColor(this.color);
        }
        graphics.setFont(this.doc.getFont(this.font_idx));
        int n = this.base_line - this.add_base;
        if (this.doLeadingSpace) {
            graphics.drawString(" " + this.text, 0, n);
        } else {
            graphics.drawString(this.text, 0, n);
        }
        if (this.underline) {
            graphics.drawLine(0, n + 1, this.width, n + 1);
        }
        if (this.strikeout) {
            graphics.drawLine(0, n - 4, this.width, n - 4);
        }
    }

    void paint(Graphics graphics, VisDocument visDocument) {
        Color color = this.color;
        Font font = this.doc.getFont(this.font_idx);
        if (this.selected) {
            graphics.setColor(this.doc.getSelBackColor());
            graphics.fillRect(this.ox, this.oy, this.width, this.height);
            color = this.doc.getSelColor();
        }
        if (this.doLeadingSpace) {
            visDocument.drawString(graphics, " " + this.text, font, color, this.ox, this.oy + this.base_line - this.add_base, this.width, this.underline, this.strikeout, this.selected);
            return;
        }
        visDocument.drawString(graphics, this.text, font, color, this.ox, this.oy + this.base_line - this.add_base, this.width, this.underline, this.strikeout, this.selected);
    }

    int getBaseLine() {
        return this.base_line;
    }

    void layout(int n, boolean bl) {
        try {
            boolean bl2 = this.doLeadingSpace = !bl && this.is_space;
            if (this.height < 0) {
                FontMetrics fontMetrics = this.doc.getFontMetrics(this.font_idx);
                this.height = fontMetrics.getHeight() + 2;
                this.base_line = fontMetrics.getHeight() - fontMetrics.getDescent() + this.add_base;
                this.space_width = fontMetrics.stringWidth(" ");
                this.text_width = fontMetrics.stringWidth(this.text);
            }
            if (this.doLeadingSpace) {
                this.width = this.text_width + this.space_width;
                return;
            }
            this.width = this.text_width;
            return;
        }
        catch (Exception exception) {
            System.out.println("Could not layout text: \"" + this.text + "\"");
            return;
        }
    }

    String getSelectedText() {
        if (this.doLeadingSpace) {
            return " " + this.text;
        }
        return this.text;
    }
}

