/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Cookie;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Vector;

class CookieSupport {
    static boolean enabled = true;
    private Vector cookies = new Vector();

    boolean extractCookies(URL uRL, URLConnection uRLConnection) {
        if (!enabled) {
            return false;
        }
        boolean bl = false;
        String string = "";
        int n = 1;
        while (string != null) {
            Cookie cookie;
            string = uRLConnection.getHeaderFieldKey(n);
            String string2 = uRLConnection.getHeaderField(n);
            if (string != null && string2 != null && "set-cookie".equalsIgnoreCase(string) && (cookie = Cookie.parseFromString(uRL, string2)) != null) {
                this.addCookie(cookie);
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private void addCookie(Cookie cookie) {
        if (cookie.expires != null && cookie.expires.before(new Date())) {
            return;
        }
        int n = this.cookies.size();
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie2 = (Cookie)this.cookies.elementAt(n2);
            if (cookie.domain.equals(cookie2.domain) && cookie.path.equals(cookie2.path) && cookie.name.equals(cookie2.name)) {
                this.cookies.setElementAt(cookie, n2);
                return;
            }
            ++n2;
        }
        this.cookies.addElement(cookie);
    }

    void applyCookies(URL uRL, URLConnection uRLConnection) {
        Object object;
        if (!enabled) {
            return;
        }
        String string = uRL.getHost();
        if (string == null || !"http".equals(uRL.getProtocol())) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        int n = this.cookies.size();
        int n2 = 0;
        while (n2 < n) {
            object = (Cookie)this.cookies.elementAt(n2);
            if ((((Cookie)object).expires == null || !((Cookie)object).expires.before(new Date())) && string.endsWith(((Cookie)object).domain)) {
                vector.addElement(object);
            }
            ++n2;
        }
        if (vector.size() < 1) {
            return;
        }
        object = "";
        n = vector.size();
        n2 = 0;
        while (n2 < n) {
            Cookie cookie = (Cookie)vector.elementAt(n2);
            if (n2 != 0) {
                object = String.valueOf(object) + "; ";
            }
            object = String.valueOf(object) + cookie.name + "=" + cookie.value;
            ++n2;
        }
        uRLConnection.setRequestProperty("Cookie", (String)object);
    }

    void writeCookies(ObjectOutput objectOutput) {
        if (!enabled) {
            return;
        }
        try {
            Vector<Cookie> vector = new Vector<Cookie>();
            int n = 0;
            while (n < this.cookies.size()) {
                Cookie cookie = (Cookie)this.cookies.elementAt(n);
                if (cookie.expires != null && cookie.expires.after(new Date())) {
                    vector.addElement(cookie);
                }
                ++n;
            }
            objectOutput.writeObject(vector);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void readCookies(ObjectInput objectInput) {
        if (!enabled) {
            return;
        }
        try {
            Vector vector = (Vector)objectInput.readObject();
            int n = 0;
            while (n < vector.size()) {
                this.addCookie((Cookie)vector.elementAt(n));
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    CookieSupport() {
    }
}

