/*******************************************************************************
 *     Copyright(c) 2002 - 2003  Intel Corporation. All Rights Reserved.
 *
 *
 *     Watchdog timer driver for Intel(R) ESB.
 *
 *     This program is free software; you can redistribute it and/or modify 
 *     it under the terms of the GNU General Public License as published by 
 *     the Free Software Foundation; either version 2 of the License, or 
 *     any later version.
 *		
 *     Intel does not admit liability nor provide warranty for this software. 
 *     This material is provided "AS-IS" and at no charge.
 *
 *
 *     Module Name:      esbwdt.c
 *
 *     Abstract:         This module support Intel ESB watchdog timer. 
 *                       All of the driver functions is provided in this file.
 * 
 *     Environment:      This file is intended to be specific to Linux 
 *                       operating system.
 *
 *
 *     Version 1.0      1st drop for beta linux driver packages for esb
 *     Jun 23 2003
 *******************************************************************************/

#ifndef ESBWDT_H
#define ESBWDT_H

#include <linux/ioctl.h>
#include <linux/watchdog.h>

#ifndef  PCI_DEVICE_ID_INTEL_CICH2_WDT
#define  PCI_DEVICE_ID_INTEL_CICH2_WDT  0x25AB 
#endif
#define WDT_VENDOR_OFFSET 0x00
#define WDT_DEVICE_OFFSET 0x02
#define WDT_CMD_OFFSET    0x04
#define WDT_CONFIG_OFFSET 0x60
#define WDT_DC_OFFSET     0x64
#define WDT_LOCK_OFFSET   0x68
#define WDT_LOCK          0x01     
#define WDT_ENABLE        0x02
#define WDT_CLEAR_STS     0x0200
#define TIMER_MARGIN      60000
unsigned long wdt_base;
unsigned long wdt_addr;
#define WDT_PRELD1        (wdt_addr + 0x00)
#define WDT_PRELD2        (wdt_addr + 0x04)
#define WDT_INT_STS       (wdt_addr + 0x08)
#define WDT_RLD           (wdt_addr + 0x0C)
#define WDT_MASK          0xfd
#define MODE_MASK         0xfb
#define MOSC_TEST         0x04
#define OPIN_MASK         0x20
#define	WDIOF_SETMODE	    0x0100	
#define WDIOF_SETTIMEOUT2   0x0200  
#define	WDIOC_SETTIMEOUT2   _IOWR(WATCHDOG_IOCTL_BASE,8, unsigned long)
#define	WDIOC_SETMODE       _IOWR(WATCHDOG_IOCTL_BASE,9, unsigned long)
#define	WDIOC_GETTIMEOUT2   _IOR(WATCHDOG_IOCTL_BASE, 10, unsigned long)
#define WDIOC_SETSCALE      _IOWR(WATCHDOG_IOCTL_BASE,11, unsigned long)
#define WDIOC_LOCK          _IOWR(WATCHDOG_IOCTL_BASE,14, unsigned long)
#define WDIOC_NOTIFY        _IOWR(WATCHDOG_IOCTL_BASE,15, unsigned long)
#define WDIOC_ENABLE        _IOWR(WATCHDOG_IOCTL_BASE,16, unsigned long)
#define WDIOC_DISABLE       _IOWR(WATCHDOG_IOCTL_BASE,17, unsigned long)
#define WDIOC_GETSCALE      _IOR(WATCHDOG_IOCTL_BASE,18, unsigned long)
#define WDIOC_GETMODE       _IOR(WATCHDOG_IOCTL_BASE,19, unsigned long)
#define WDIOC_GETIRQSTAT    _IOR(WATCHDOG_IOCTL_BASE,20, unsigned long)
#define WDIOC_CLRIRQSTAT    _IOWR(WATCHDOG_IOCTL_BASE,21, unsigned long)
#define WDIOC_SETOPIN       _IOWR(WATCHDOG_IOCTL_BASE,22, unsigned long)
#define WDIOC_GETOPIN       _IOR(WATCHDOG_IOCTL_BASE,23, unsigned long)
#define WDIOC_GETDC         _IOR(WATCHDOG_IOCTL_BASE,24, unsigned long)
#define WDIOC_GETIRQVEC     _IOR(WATCHDOG_IOCTL_BASE,25, unsigned long)
#define WDIOC_CLRSTATUS     _IOR(WATCHDOG_IOCTL_BASE,26, unsigned long)
#define WDIOC_CLRNOTIFY     _IOWR(WATCHDOG_IOCTL_BASE,27, unsigned long)
#define WDIOC_GETWDTENABLE  _IOR(WATCHDOG_IOCTL_BASE,28, unsigned long)
enum {
        WDT_MODE,
        FREE_MODE,
};  
enum {
        HIGH_SCALE,
        LOW_SCALE,
};
enum {
  OPIN0_EN,
  OPIN1_DIS,
};
        
#endif


