#!/usr/bin/perl
$LOG = "/opt/bldlog";
$KERN_ERR = "/opt/errlog";
$PKGBASE = "/opt/esb-rhas30-gold_1_rc1";
$TARGET = "-20.ELesb";

print "\nPRIOR to running this script you must perform following steps:\n";
print "1 Set \$PKGBASE to match name of esb-rhas33-xxxx you are trying to install\n";
print "  > Edit this file (bldkernel.pl) to change the \$PKGBASE variable <\n";
print "2 Copy kernel-source-2.4.21-20.EL.i386.rpm...\n";
print "  FROM: YOUR Red Hat Advanced Server v3.3 CDROMS\n";
print "  TO:   \${PKGBASE}/sources/kernel directory\n\n";
print "Press Y to continue or N to exit...\n";
$tmp1 = <STDIN>;
chomp $tmp1;

if (($tmp1 eq "Y") || ($tmp1 eq "y")) {
  goto START;
}
goto EXIT;

START:
 
#remove old log files

chdir ( "/opt" );

if ( -f "${LOG}" ) {
    system ( "rm -f ${LOG}" );
}
if ( -f "${KERN_ERR}" ) {
    system ( "rm -f ${KERN_ERR}" );
}

#create new log files

if ( ! -f "${LOG}" ) {
    system ( "touch ${LOG}" );
}
if ( ! -f "${KERN_ERR}" ) {
    system ( "touch ${KERN_ERR}" );
}

#goto WDT1;

KERN1:

chdir ("/usr/src");
print "Deleting /usr/src/linux-2.4.21-20.EL...\n";
system ( "rpm -e kernel-source-2.4.21-20.EL" );

print "Installing kernel sources from kernel-source-2.4.21-20.EL.i386.rpm...\n"; 
chdir ("${PKGBASE}/sources/kernel");
system ( "rpm -i kernel-source-2.4.21-20.EL.i386.rpm" );

KERN2:

chdir ("/usr/src/linux-2.4.21-20.EL");

print "patch -p0 < ${PKGBASE}/patches/ide-sata/piix.c-hr.patch\n";
system ( "patch -p0 < ${PKGBASE}/patches/ide-sata/piix.c-hr.patch >>$LOG 2>>$KERN_ERR");

print "patch -p0 < ${PKGBASE}/patches/smbus/i2c-hr.patch\n"; 
system ( "patch -p0 < ${PKGBASE}/patches/smbus/i2c-hr.patch >>$LOG 2>>$KERN_ERR" );

print "patch -p0 < ${PKGBASE}/patches/ioapic/hw_irq.h-hr.patch\n"; 
system ( "patch -p0 < ${PKGBASE}/patches/ioapic/hw_irq.h-hr.patch >>$LOG 2>>$KERN_ERR" );


print "BEGIN kernel build process...\n";
print "make mrproper...\n";
system ("make mrproper >>$LOG 2>>$KERN_ERR");

print "Setting kernel Makefile EXTRAVERSION = $TARGET\n";
system ( "perl -pi~ -e 's/EXTRAVERSION = -20.ELcustom/EXTRAVERSION = $TARGET/' Makefile");

print "Creating .config file ...\n";
system ("cp ${PKGBASE}/sources/kernel/config-2.4.21-20.EL-p4-upapic-i2c .config");


KERN3:

print "Building the kernel...\n";

print "make mrproper menuconfig dep clean bzImage modules modules_install install\n";
#system ("make mrproper >>$LOG 2>>$KERN_ERR");
system ("make oldconfig >>$LOG 2>>$KERN_ERR");
system ("make dep >>$LOG 2>>$KERN_ERR");
system ("make clean >>$LOG 2>>$KERN_ERR");
system ("make bzImage >>$LOG 2>>$KERN_ERR");
system ("make modules >>$LOG 2>>$KERN_ERR");
system ("make modules_install >>$LOG 2>>$KERN_ERR");
system ("make install >>$LOG 2>>$KERN_ERR");

KERN4:
# not needed in RHAS v3.3, as it is handled during make install
#chdir ("/boot");
#print "mkinitrd initrd-2.4.9${TARGET}.img 2.4.9${TARGET}\n"; 
#system ( "mkinitrd initrd-2.4.9${TARGET}.img 2.4.9${TARGET}" );
#print "Configuring grub.conf to force boot with newly built kernel...\n";
#system ( "patch -p0 < ${PKGBASE}/sources/kernel/install-2.4.9-e.24esb-grub.conf.patch >>$LOG 2>>$KERN_ERR");

print "Installing newly built pci.ids file to /usr/src/pci.ids...\n";
system ( "cp /usr/src/linux-2.4.21-20.EL/drivers/pci/pci.ids /usr/share/pci.ids" );

goto EXIT;

###########################################################################################

SMBUS1:
    
print "Building SMBUS: i2c-core drivers...\n";
chdir ("${PKGBASE}/sources/smbus");
system ( "tar -xzvf i2c-2.7.0.tar.gz >>$LOG 2>>$KERN_ERR" );
chdir ("i2c-2.7.0");
print "Fixing up i2c Makefile...\n"; 
system ( "patch -p0 < ${PKGBASE}/patches/smbus/i2c-2.7.0-Makefile.patch >>$LOG 2>>$KERN_ERR" );
system ( "perl -pi~ -e 's/KERNELVERSION := 2.4.20-hrich5/KERNELVERSION := 2.4.9${TARGET}/' Makefile" );
system ( "perl -pi~ -e 's/linux-2.4.20/linux-2.4.9-e.3/' Makefile" );
system ( "make >>$LOG 2>>$KERN_ERR" );
print "Installing SMBUS: i2c-core drivers...\n";
system ( "make install >>$LOG 2>>$KERN_ERR" );
system ( "depmod -a" );

SMBUS2:

print "Building SMBUS: lm_sensors smbus controller driver, sensor drivers and i2c utilities...\n";
chdir ("${PKGBASE}/sources/smbus");
system ( "tar -xzvf lm_sensors-2.7.0.tar.gz >>$LOG 2>>$KERN_ERR" );
chdir ("lm_sensors-2.7.0");
print "Fixing up lm_sensors Makefile...\n"; 
system ( "patch -p0 < ${PKGBASE}/patches/smbus/lm_sensors-2.7.0-Makefile.patch >>$LOG 2>>$KERN_ERR" );
system ( "perl -pi~ -e 's/KERNELVERSION := 2.4.20-hrich5/KERNELVERSION := 2.4.9${TARGET}/' Makefile" );
system ( "perl -pi~ -e 's/linux-2.4.20/linux-2.4.9-e.3/' Makefile" );
print "patch kernel/busses/i2c-i801.c ${PKGBASE}/patches/smbus/i2c-hr.patch\n"; 
system ( "patch kernel/busses/i2c-i801.c ${PKGBASE}/patches/smbus/i2c-hr.patch >>$LOG 2>>$KERN_ERR" );
print "patch -p0 < ${PKGBASE}/patches/smbus/lm_sensors-2.7.0-Module.mk-patch\n"; 
system ( "patch -p0 < ${PKGBASE}/patches/smbus/lm_sensors-2.7.0-Module.mk-patch >>$LOG 2>>$KERN_ERR" );
system ( "make >>$LOG 2>>$KERN_ERR" );
print "Installing SMBUS: lm_sensors smbus controller driver, sensor drivers and i2c utilities...\n";
system ( "make install >>$LOG 2>>$KERN_ERR" );
system ( "depmod -a" );
#    goto BYEBYE;

ALSA1:

print "Building alsa ac97 modules...\n";
chdir ("${PKGBASE}/sources/ac97");
system ( "tar -xjf alsa-driver-0.9.0rc5.tar.bz2 >>$LOG 2>>$KERN_ERR" );
system ( "tar -xjf alsa-lib-0.9.0rc5.tar.bz2 >>$LOG 2>>$KERN_ERR" );
system ( "tar -xjf alsa-utils-0.9.0rc5.tar.bz2 >>$LOG 2>>$KERN_ERR" );
chdir ("alsa-driver-0.9.0rc5");
print "patching alsa-kernel/pci/intel8x0.c to add support for hr...\n";
system ("patch alsa-kernel/pci/intel8x0.c < ${PKGBASE}/patches/ac97/alsa-hr.patch >>$LOG 2>>$KERN_ERR" );
print "building alsa-driver-0.9.0rc5...\n"; 
system ("./configure --with-kernel=/usr/src/linux-2.4.9-e.3 --with-oss=yes --with-cards=intel8x0 >>$LOG 2>>$KERN_ERR" );
system ("make install >>$LOG 2>>$KERN_ERR" );
system ("./snddevices >>$LOG 2>>$KERN_ERR" );
 
chdir ("../alsa-lib-0.9.0rc5");
print "building alsa-lib-0.9.0rc5...\n";
system ("./configure >>$LOG 2>>$KERN_ERR" );
system ("make install >>$LOG 2>>$KERN_ERR" );  

chdir ("../alsa-utils-0.9.0rc5");
print "building alsa-utils-0.9.0rc5...\n";
system ("./configure >>$LOG 2>>$KERN_ERR" );
system ("make install >>$LOG 2>>$KERN_ERR" );

GBNIC1:

print "Building e1000 GbNIC drivers ...\n";
chdir ("${PKGBASE}/sources/GbNIC");
system ( "tar -xzvf e1000-5.0.25.tar.gz >>$LOG 2>>$KERN_ERR" );
chdir ("e1000-5.0.25/src");
system ("make install >>$LOG 2>>$KERN_ERR" );

WDT1:

print "WDT Driver not supported in this release...\n";

goto EXIT;

print "Building & Installing HR WDT Driver (icich2_wdt.o)...\n";
chdir ("${PKGBASE}/sources/wdt/driver");
system ( "tar -xzvf icich2_wdt-0.0.1.s.tar.gz >>$LOG 2>>$KERN_ERR" );
chdir ("icich2_wdt-0.0.1.s");
system ("make install >>$LOG 2>>$KERN_ERR");

EXIT:

print "all done...\n";

