#!/usr/bin/perl
$LOG = "/opt/bldlog";
$KERN_ERR = "/opt/errlog";
$PKGBASE = "/opt/esb-rhas30-gold_1_rc1";
$TARGET = "-20.ELesb";

print "\nPRIOR to running this script you must perform following steps:\n";
print "1 Run the bldkernel.pl script to build, install, and boot the 2.4.21-20.ELesb kernel\n";
print "2 Set \$PKGBASE to match name of esb-rhas33-xxxx you are trying to install\n";
print "  > Edit this file (bldsrcs.pl) to change the \$PKGBASE variable <\n";
print "Press Y to continue or N to exit...\n";
$tmp1 = <STDIN>;
chomp $tmp1;

if (($tmp1 eq "Y") || ($tmp1 eq "y")) {
  goto START;
}
goto EXIT;

START:
 
#remove old log files

chdir ( "/opt" );

if ( -f "${LOG}" ) {
    system ( "rm -f ${LOG}" );
}
if ( -f "${KERN_ERR}" ) {
    system ( "rm -f ${KERN_ERR}" );
}

#create new log files

if ( ! -f "${LOG}" ) {
    system ( "touch ${LOG}" );
}
if ( ! -f "${KERN_ERR}" ) {
    system ( "touch ${KERN_ERR}" );
}

goto WDT1;

SMBUS1:
    
print "Building SMBUS: i2c-core drivers...\n";
chdir ("${PKGBASE}/sources/smbus");
system ( "tar -xzvf i2c-2.7.0.tar.gz >>$LOG 2>>$KERN_ERR" );
chdir ("i2c-2.7.0");
print "Fixing up i2c Makefile...\n"; 
system ( "patch -p0 < ${PKGBASE}/patches/smbus/i2c-2.7.0-Makefile.patch >>$LOG 2>>$KERN_ERR" );
system ( "perl -pi~ -e 's/KERNELVERSION := 2.4.20-hrich5/KERNELVERSION := 2.4.9${TARGET}/' Makefile" );
system ( "perl -pi~ -e 's/linux-2.4.20/linux-2.4.9-e.3/' Makefile" );
system ( "make >>$LOG 2>>$KERN_ERR" );
print "Installing SMBUS: i2c-core drivers...\n";
system ( "make install >>$LOG 2>>$KERN_ERR" );
system ( "depmod -a" );

SMBUS2:

print "Building SMBUS: lm_sensors smbus controller driver, sensor drivers and i2c utilities...\n";
chdir ("${PKGBASE}/sources/smbus");
system ( "tar -xzvf lm_sensors-2.7.0.tar.gz >>$LOG 2>>$KERN_ERR" );
chdir ("lm_sensors-2.7.0");
print "Fixing up lm_sensors Makefile...\n"; 
system ( "patch -p0 < ${PKGBASE}/patches/smbus/lm_sensors-2.7.0-Makefile.patch >>$LOG 2>>$KERN_ERR" );
system ( "perl -pi~ -e 's/KERNELVERSION := 2.4.20-hrich5/KERNELVERSION := 2.4.9${TARGET}/' Makefile" );
system ( "perl -pi~ -e 's/linux-2.4.20/linux-2.4.9-e.3/' Makefile" );
print "patch kernel/busses/i2c-i801.c ${PKGBASE}/patches/smbus/i2c-hr.patch\n"; 
system ( "patch kernel/busses/i2c-i801.c ${PKGBASE}/patches/smbus/i2c-hr.patch >>$LOG 2>>$KERN_ERR" );
print "patch -p0 < ${PKGBASE}/patches/smbus/lm_sensors-2.7.0-Module.mk-patch\n"; 
system ( "patch -p0 < ${PKGBASE}/patches/smbus/lm_sensors-2.7.0-Module.mk-patch >>$LOG 2>>$KERN_ERR" );
system ( "make >>$LOG 2>>$KERN_ERR" );
print "Installing SMBUS: lm_sensors smbus controller driver, sensor drivers and i2c utilities...\n";
system ( "make install >>$LOG 2>>$KERN_ERR" );
system ( "depmod -a" );
#    goto BYEBYE;

ALSA1:

print "Building alsa ac97 modules...\n";
chdir ("${PKGBASE}/sources/ac97");
system ( "tar -xjf alsa-driver-0.9.0rc5.tar.bz2 >>$LOG 2>>$KERN_ERR" );
system ( "tar -xjf alsa-lib-0.9.0rc5.tar.bz2 >>$LOG 2>>$KERN_ERR" );
system ( "tar -xjf alsa-utils-0.9.0rc5.tar.bz2 >>$LOG 2>>$KERN_ERR" );
chdir ("alsa-driver-0.9.0rc5");
print "patching alsa-kernel/pci/intel8x0.c to add support for hr...\n";
system ("patch alsa-kernel/pci/intel8x0.c < ${PKGBASE}/patches/ac97/alsa-hr.patch >>$LOG 2>>$KERN_ERR" );
print "building alsa-driver-0.9.0rc5...\n"; 
system ("./configure --with-kernel=/usr/src/linux-2.4.9-e.3 --with-oss=yes --with-cards=intel8x0 >>$LOG 2>>$KERN_ERR" );
system ("make install >>$LOG 2>>$KERN_ERR" );
system ("./snddevices >>$LOG 2>>$KERN_ERR" );
 
chdir ("../alsa-lib-0.9.0rc5");
print "building alsa-lib-0.9.0rc5...\n";
system ("./configure >>$LOG 2>>$KERN_ERR" );
system ("make install >>$LOG 2>>$KERN_ERR" );  

chdir ("../alsa-utils-0.9.0rc5");
print "building alsa-utils-0.9.0rc5...\n";
system ("./configure >>$LOG 2>>$KERN_ERR" );
system ("make install >>$LOG 2>>$KERN_ERR" );

GBNIC1:

print "Building e1000 GbNIC drivers ...\n";
chdir ("${PKGBASE}/sources/GbNIC");
system ( "tar -xzvf e1000-5.0.25.tar.gz >>$LOG 2>>$KERN_ERR" );
chdir ("e1000-5.0.25/src");
system ("make install >>$LOG 2>>$KERN_ERR" );

WDT1:

print "Building & Installing HR WDT Driver (esbwdt.o)...\n";
chdir ("${PKGBASE}/sources/esbwdt/driver");
print "make clean install...\n";
system ("make clean >>$LOG 2>>$KERN_ERR");
system ("make install >>$LOG 2>>$KERN_ERR");

WDT2:

print "Building ESB WDT Driver Demo App (esbwdt-demo)...\n";
chdir ("${PKGBASE}/sources/esbwdt/demoapp");
system ("gcc -o esbwdt-demo esbwdt-demo.c -DMODULE -I/usr/src/linux-2.4.21-20.EL/include -lcurses -lpthread >>$ LOG 2>>$KERN_ERR");

EXIT:

print "all done...\n";

