#!/bin/bash

set -e

cdate=20011127
localdir=/root/initrd.local.${cdate}
localsaved=/root/lhn_initrd.extra/
if [ "X$1" == "X" ] ; then
	echo "must give parameter"
	exit 1
fi
todisk=$1

#
###### here we go
#
if [ -e /${todisk} ] ; then
	if [ ! -d /${todisk} ] ; then
		echo "ERROR:  /${todisk} is not a directory...exiting"
		exit 1
	else
		umount /dev/${todisk}3 || echo "Un-Mount failed...ignoring"
	fi
else
	mkdir /${todisk}
fi
mke2fs -F /dev/${todisk}3
mount /dev/${todisk}3 /${todisk}
cp -p ${localdir}.raw.gz /${todisk}/lhn_initrd.${cdate}.raw.gz
cp -p ${localsaved}/boot/* /${todisk}
for afile in boot.b message us.klt System.map-2.4.14 vmlinuz-2.4.14  ; do
	cp -p /boot/${afile} /${todisk}/${afile}
done
lilo -C /${todisk}/lilo.conf.${todisk}




umount /dev/md199 || echo "Un-Mount failed...ignoring"
umount /dev/md200 || echo "Un-Mount failed...ignoring"
/sbin/raidstop --configfile /root/lhn_initrd.extra/boot/raidtab.hda /dev/md199 || echo "Raidstop failed...ignoring"
/sbin/raidstop --configfile /root/lhn_initrd.extra/boot/raidtab.hda /dev/md200 || echo "Raidstop failed...ignoring"
/sbin/mkraid --really-force --configfile /${todisk}/raidtab.${todisk}.imager /dev/md199
/sbin/mkraid --really-force --configfile /${todisk}/raidtab.${todisk}.imager /dev/md200
mkfs.xfs -f /dev/md199
mkfs.xfs -f /dev/md200

if [ -e /mnt/${todisk} ] ; then
	if [ ! -d /mnt/${todisk} ] ; then
		echo "ERROR:  /mnt/${todisk} is not a directory...exiting"
		exit 1
	fi
else
	mkdir /mnt/${todisk}
fi
mount /dev/md200 /mnt/${todisk}
mkdir /mnt/${todisk}/var
mount /dev/md199 /mnt/${todisk}/var
cd /mnt/${todisk}
echo "Installing os...."
gunzip -c /root/imager/0.112.19/lhn_os.cpio.gz | cpio --extract --no-absolute-filenames -m --make-directories --unconditional
echo "Updateing os /boot directory..."
if [ -e /mnt/${todisk}/boot ] ; then
	if [ ! -d /mnt/${todisk}/boot ] ; then
		echo "ERROR:  /mnt/${todisk}/boot is not a directory...exiting"
		exit 1
	fi
else
	mkdir /mnt/${todisk}/boot
fi
cd /${todisk}
find . -print | cpio --make-directories --unconditional -m --pass-through /mnt/${todisk}/boot/

echo "OK ALL DONE!!!!"

