#!/bin/bash -x

set -e

cdate=20011127
localdir=/root/initrd.local.${cdate}
localsaved=/root/lhn_initrd.extra/

rm -rf ${localdir}*
#
###### here we go
#
mkdir ${localdir}

cat << EOF1 > ${localsave}/files.list.fromos
.
./bin
./bin/cat
./bin/echo
./bin/ls
./bin/mount
./bin/umount
./dev
./etc
./etc/devfsd.conf
./etc/ld.so.conf
#./lib
#./lib/ld-2.1.3.so
##./lib/ld-2.2.4.so
#./lib/ld-linux.so.1
#./lib/ld-linux.so.1.9.11
#./lib/ld-linux.so.2
#./lib/libc-2.1.3.so
#./lib/libc.so.6
#./lib/libcom_err.so.2
#./lib/libcom_err.so.2.0
#./lib/libcrypt-2.1.3.so
##./lib/libcrypt-2.2.4.so
#./lib/libcrypt.so.1
#./lib/libdl-2.1.3.so
##./lib/libdl-2.2.4.so
#./lib/libdl.so.2
#./lib/libhistory.so.4
#./lib/libhistory.so.4.1
#./lib/libpam.so.0
#./lib/libpam.so.0.72
#./lib/libreadline.so.4
#./lib/libreadline.so.4.1
#./lib/libtermcap.so
#./lib/libtermcap.so.2
#./lib/libtermcap.so.2.0.8
./lib/modules/2.4.14
./lib/modules/2.4.14/kernel
./lib/modules/2.4.14/kernel/arch
./lib/modules/2.4.14/kernel/arch/i386
./lib/modules/2.4.14/kernel/arch/i386/kernel
./lib/modules/2.4.14/kernel/arch/i386/kernel/cpuid.o
./lib/modules/2.4.14/kernel/arch/i386/kernel/microcode.o
./lib/modules/2.4.14/kernel/drivers
./lib/modules/2.4.14/kernel/drivers/md
./lib/modules/2.4.14/kernel/drivers/md/linear.o
./lib/modules/2.4.14/kernel/drivers/md/lvm-mod.o
./lib/modules/2.4.14/kernel/drivers/md/md.o
./lib/modules/2.4.14/kernel/drivers/md/multipath.o
./lib/modules/2.4.14/kernel/drivers/md/raid0.o
./lib/modules/2.4.14/kernel/drivers/md/raid1.o
./lib/modules/2.4.14/kernel/drivers/md/raid5.o
./lib/modules/2.4.14/kernel/drivers/md/xor.o
./lib/modules/2.4.14/kernel/drivers/net
./lib/modules/2.4.14/kernel/drivers/net/sis900.o
./lib/modules/2.4.14/misc
./lib/modules/2.4.14/modules.dep
./lib/modules/2.4.14/modules.pcimap
./proc
./sbin/devfsd
./sbin/insmod
./sbin/lsmod
./sbin/raidstart
EOF1

cd /
cat ${localsave}/files.list.fromos | cpio --make-directories --unconditional -m --pass-through ${localdir}

##use cpio##cat << EOF2 > ${localsave}/files.list.forinitrd
##use cpio#####./lost+found
##use cpio##./bin/bash
##use cpio##./etc/fstab
##use cpio##./etc/mtab
##use cpio##./lib
##use cpio##./lib/ld-2.1.3.so
##use cpio####./lib/ld-2.2.4.so
##use cpio##./lib/ld-linux.so.1
##use cpio##./lib/ld-linux.so.1.9.11
##use cpio##./lib/ld-linux.so.2
##use cpio##./lib/libc-2.1.3.so
##use cpio##./lib/libc.so.6
##use cpio##./lib/libcom_err.so.2
##use cpio##./lib/libcom_err.so.2.0
##use cpio##./lib/libcrypt-2.1.3.so
##use cpio####./lib/libcrypt-2.2.4.so
##use cpio##./lib/libcrypt.so.1
##use cpio##./lib/libdl-2.1.3.so
##use cpio####./lib/libdl-2.2.4.so
##use cpio##./lib/libdl.so.2
##use cpio##./lib/libhistory.so.4
##use cpio##./lib/libhistory.so.4.1
##use cpio##./lib/libpam.so.0
##use cpio##./lib/libpam.so.0.72
##use cpio##./lib/libreadline.so.4
##use cpio##./lib/libreadline.so.4.1
##use cpio##./lib/libtermcap.so
##use cpio##./lib/libtermcap.so.2
##use cpio##./lib/libtermcap.so.2.0.8
##use cpio##./boot/raidtab.hda
##use cpio##./boot/raidtab.hdb
##use cpio##./boot/raidtab.hdc
##use cpio##./boot/raidtab.hdd
##use cpio##./linuxrc
##use cpio##./execute_cmds
##use cpio##./execute_pivot
##use cpio##EOF2
##use cpio##
##use cpio##cd ${localsaved}
##use cpio##cat ${localsave}/files.list.forinitrd | cpio --make-directories --unconditional -m --pass-through ${localdir}
cd ${localsaved}
find . -print | cpio --make-directories --unconditional -m --pass-through ${localdir}


dd if=/dev/zero of=${localdir}.raw bs=1024 count=8192
mke2fs -F ${localdir}.raw
mkdir ${localdir}.mounted
mount -o loop ${localdir}.raw ${localdir}.mounted
cd ${localdir}
find . -print | cpio --make-directories --unconditional -m --pass-through ${localdir}.mounted
echo "Syncing..."
sync
echo "Unmounting..."
umount ${localdir}.raw
echo "Syncing..."
sync
echo "Compressing..."
gzip -9 -c ${localdir}.raw > ${localdir}.raw.gz

echo "OK ALL DONE!!!!"

