/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.database;

import com.ascendo.fitness.util.IntVector;
import com.ascendo.fitness.util.StringVector;
import javax.microedition.rms.RecordStore;

public abstract class MicroDatabase {
    protected final String recordStoreName;
    protected RecordStore recordStore;
    public final IntVector recordIDs = new IntVector();
    public final StringVector displayNames = new StringVector();
    public int found = 0;

    public MicroDatabase(String string) {
        this.recordStoreName = string;
        try {
            this.recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final int addRecord(byte[] byArray) throws Exception {
        int n = -1;
        n = this.recordStore.addRecord(byArray, 0, byArray.length);
        return n;
    }

    public final void editRecord(int n, byte[] byArray) throws Exception {
        this.recordStore.setRecord(n, byArray, 0, byArray.length);
    }

    public final void deleteRecord(int n) throws Exception {
        this.recordStore.deleteRecord(n);
    }

    public final byte[] getRawRecord(int n) {
        byte[] byArray = null;
        try {
            byArray = this.recordStore.getRecord(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public final int recordID(int n) {
        return this.recordIDs.intAt(n);
    }

    public final String displayName(int n) {
        return this.displayNames.elementAt(n);
    }

    public final void close() {
        if (this.recordStore != null) {
            try {
                this.recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

