/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.activity;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.database.activity.ActivityDailyDatabase;
import com.ascendo.fitness.database.activity.ActivityDailyRecord;
import com.ascendo.fitness.database.activity.ActivityMasterRecord;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.database.others.UserSettingsRecord;
import com.ascendo.fitness.util.ConversionUtils;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public final class ActivityEntryForm
extends Form
implements CommandListener {
    private final int mode;
    private final DateField dateEditor;
    private final TextField unitsField;
    private final StringItem caloriesItem;
    private final TextField labelField;
    private final TextField valueField;

    public ActivityEntryForm(int n) {
        super("");
        this.mode = n;
        if (n == 40 || n == 50) {
            this.setTitle("New Entry");
        } else {
            this.setTitle("Edit Entry");
        }
        this.append((Item)new StringItem("Item: ", ActivityMasterRecord.description));
        this.dateEditor = new DateField("Date: ", 1);
        Date date = new Date();
        if (n == 30) {
            date.setTime(ActivityDailyRecord.milliSeconds);
        }
        this.dateEditor.setDate(date);
        this.append((Item)this.dateEditor);
        this.unitsField = new TextField("Duration (" + ActivityMasterRecord.unit + "): ", n == 30 ? "" + ActivityDailyRecord.quantity : "1", 5, 2);
        this.append((Item)this.unitsField);
        this.caloriesItem = new StringItem("Calories:", "");
        this.append((Item)this.caloriesItem);
        this.labelField = new TextField("Label:", n == 30 ? "" + ActivityDailyRecord.userLabel : "", 30, 0);
        this.valueField = new TextField("Value:", n == 30 ? "" + ActivityDailyRecord.userValue : "", 30, 0);
        this.append((Item)this.labelField);
        this.append((Item)this.valueField);
        this.addCommand(FitnessCommands.CANCEL_COMMAND);
        this.addCommand(FitnessCommands.SAVE_COMMAND);
        this.addCommand(FitnessCommands.CALCULATE_COMMAND);
        this.setCommandListener(this);
        this.calculateCalories();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == DisplayController.MESSAGE_ALERT && command == Alert.DISMISS_COMMAND) {
            DisplayController.showMenu(2);
            return;
        }
        if (command == FitnessCommands.CANCEL_COMMAND) {
            if (this.mode == 30) {
                DisplayController.showForm(-202);
            } else {
                DisplayController.showForm(-201);
            }
        } else if (command == FitnessCommands.SAVE_COMMAND) {
            this.doSubmit();
        } else if (command == FitnessCommands.CALCULATE_COMMAND) {
            this.calculateCalories();
        }
    }

    private void doSubmit() {
        String string = ConversionUtils.getInvalidField(this);
        if (string != null) {
            DisplayController.error(this.getTitle(), "Invalid (or No) value specified for " + string.substring(0, string.indexOf(58)));
            return;
        }
        try {
            ActivityDailyDatabase activityDailyDatabase = ActivityDailyDatabase.getInstance();
            if (this.mode == 40 || this.mode == 50) {
                activityDailyDatabase.addRecord(("" + this.dateEditor.getDate().getTime() + '|' + ActivityMasterRecord.description + '|' + Integer.parseInt(this.unitsField.getString()) + '|' + ActivityMasterRecord.recordID + '|' + this.labelField.getString() + '|' + this.valueField.getString()).getBytes());
                this.deleteAll();
                if (DefaultsRecord.userOption == 0) {
                    DisplayController.message("Ascendo Fitness v2.7 [Trial]", "You have added a new Entry to the Activities database. Select Activities, Edit Entry to modify or Progress, Calories Out to view a graph.", this);
                } else {
                    DisplayController.showMenu(2);
                }
            } else {
                activityDailyDatabase.editRecord(ActivityDailyRecord.recordID, ("" + this.dateEditor.getDate().getTime() + '|' + ActivityMasterRecord.description + '|' + Integer.parseInt(this.unitsField.getString()) + '|' + ActivityMasterRecord.recordID + '|' + this.labelField.getString() + '|' + this.valueField.getString()).getBytes());
                this.deleteAll();
                if (DefaultsRecord.userOption == 0) {
                    DisplayController.message("Ascendo Fitness v2.7 [Trial]", "You have edited an Activity Entry. Select Progress, Calories Out to view a graph.", this);
                } else {
                    DisplayController.showMenu(2);
                }
            }
        }
        catch (Exception exception) {
            DisplayController.error("Ascendo Fitness v2.7 [Trial]", "Error while updating database.\nMessage: " + exception.toString());
        }
    }

    private void calculateCalories() {
        try {
            int n = Integer.parseInt(this.unitsField.getString());
            if (n <= 0) {
                throw new Exception();
            }
            boolean bl = DefaultsRecord.measurement == 0;
            int n2 = bl ? UserSettingsRecord.weightUS : UserSettingsRecord.weightMetric;
            int n3 = bl ? ActivityMasterRecord.caloriesPerLBs : ActivityMasterRecord.caloriesPerKGs;
            int n4 = n2 / 10;
            int n5 = n2 % 10;
            int n6 = n4 * n3 + n5 * n3 / 10;
            n6 = n * n6;
            this.caloriesItem.setText("" + Integer.toString(n6));
        }
        catch (Exception exception) {
            this.caloriesItem.setText("Invalid Units");
        }
    }
}

