/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.activity;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessMIDlet;
import com.ascendo.fitness.custom.YesNoAlert;
import com.ascendo.fitness.database.activity.ActivityMasterDatabase;
import com.ascendo.fitness.database.activity.ActivityMasterRecord;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.forms.activity.ActivityEntryForm;
import com.ascendo.fitness.forms.activity.ActivitySearchForm;
import com.ascendo.fitness.util.ConversionUtils;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public final class ActivityTypeForm
extends Form
implements CommandListener {
    private Item descriptionField;
    private Item unitTypeField;
    private Item caloriesPerLBs;
    private Item caloriesPerKGs;
    private boolean gotoEntryForm = false;
    private int mode;
    private int preset;

    public ActivityTypeForm(String string) {
        this(string, false);
    }

    public ActivityTypeForm(String string, boolean bl) {
        super("");
        this.gotoEntryForm = bl;
        ActivityMasterRecord.set(-1, string, 1, 1, FitnessMIDlet.ACTIVITY_UNITS[0]);
        this.init(false);
    }

    public ActivityTypeForm(boolean bl) {
        super("");
        this.init(bl);
    }

    private void init(boolean bl) {
        if (bl) {
            this.setTitle("Display");
            this.mode = 20;
        } else if (ActivityMasterRecord.recordID == -1) {
            this.setTitle("New Type");
            this.mode = 40;
        } else {
            this.setTitle("Edit Type");
            this.mode = 30;
        }
        if (bl) {
            this.descriptionField = new StringItem("Description: ", ActivityMasterRecord.description);
            this.unitTypeField = new StringItem("Units: ", ActivityMasterRecord.unit);
            this.caloriesPerLBs = new StringItem("Cals/lb/Duration: ", "" + ActivityMasterRecord.caloriesPerLBs / 10 + "." + ActivityMasterRecord.caloriesPerLBs % 10);
            this.caloriesPerKGs = new StringItem("Cals/kg/Duration: ", "" + ActivityMasterRecord.caloriesPerKGs / 10 + "." + ActivityMasterRecord.caloriesPerKGs % 10);
        } else {
            this.descriptionField = new TextField("Description: ", ActivityMasterRecord.description, 30, 0);
            this.unitTypeField = new ChoiceGroup("Units: ", 4, FitnessMIDlet.ACTIVITY_UNITS, null);
            for (int i = 0; i < FitnessMIDlet.ACTIVITY_UNITS.length; ++i) {
                if (!ActivityMasterRecord.unit.equals(FitnessMIDlet.ACTIVITY_UNITS[i])) continue;
                this.preset = i;
                ((ChoiceGroup)this.unitTypeField).setSelectedIndex(i, true);
                break;
            }
            this.caloriesPerLBs = new TextField("Cals/10lbs/Duration: ", Integer.toString(ActivityMasterRecord.caloriesPerLBs), 5, 2);
            this.caloriesPerKGs = new TextField("Cals/10kgs/Duration: ", Integer.toString(ActivityMasterRecord.caloriesPerKGs), 5, 2);
        }
        this.append(this.descriptionField);
        this.append(this.unitTypeField);
        this.append(this.caloriesPerLBs);
        this.append(this.caloriesPerKGs);
        this.addCommand(FitnessCommands.CANCEL_COMMAND);
        if (bl) {
            this.addCommand(FitnessCommands.ADD_ACTIVITY_COMMAND);
        } else {
            this.addCommand(FitnessCommands.SAVE_COMMAND);
        }
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == DisplayController.MESSAGE_ALERT && command == Alert.DISMISS_COMMAND) {
            DisplayController.showMenu(2);
            return;
        }
        if (command == FitnessCommands.CANCEL_COMMAND) {
            if (this.mode != 40) {
                DisplayController.show((Displayable)new ActivitySearchForm(this.mode));
            } else {
                DisplayController.showMenu(2);
            }
        } else if (command == FitnessCommands.SAVE_COMMAND) {
            this.doSubmit(false);
        } else if (command == FitnessCommands.YES_COMMAND) {
            this.doSubmit(true);
        } else if (command == FitnessCommands.NO_COMMAND) {
            DisplayController.show((Displayable)this);
        } else {
            this.doAddActivity();
        }
    }

    private void doAddActivity() {
        DisplayController.show((Displayable)new ActivityEntryForm(40));
    }

    private void doSubmit(boolean bl) {
        String string = ConversionUtils.getInvalidField(this);
        if (string != null) {
            DisplayController.error(this.getTitle(), "Invalid (or No) value specified for " + string.substring(0, string.indexOf(58)));
            return;
        }
        ActivityMasterDatabase activityMasterDatabase = ActivityMasterDatabase.getInstance();
        if (!bl) {
            ActivityMasterRecord.recordID = -1;
            String string2 = ((TextField)this.descriptionField).getString();
            activityMasterDatabase.search(string2.getBytes(), false);
            if (activityMasterDatabase.found > 0) {
                ActivityMasterRecord.recordID = activityMasterDatabase.recordID(0);
                YesNoAlert yesNoAlert = new YesNoAlert("Activity Type", "Entry \"" + string2 + "\" already exists. Over write?", this);
                DisplayController.show((Displayable)yesNoAlert);
                return;
            }
        }
        try {
            int n = ((ChoiceGroup)this.unitTypeField).getSelectedIndex();
            if (n == -1) {
                n = this.preset;
            }
            ActivityMasterRecord.description = ((TextField)this.descriptionField).getString();
            ActivityMasterRecord.caloriesPerLBs = Integer.parseInt(((TextField)this.caloriesPerLBs).getString());
            ActivityMasterRecord.caloriesPerKGs = Integer.parseInt(((TextField)this.caloriesPerKGs).getString());
            ActivityMasterRecord.unit = ((ChoiceGroup)this.unitTypeField).getString(n);
            byte[] byArray = (ActivityMasterRecord.description + '|' + ActivityMasterRecord.caloriesPerLBs + '|' + ActivityMasterRecord.caloriesPerKGs + '|' + ActivityMasterRecord.unit).getBytes();
            if (ActivityMasterRecord.recordID == -1) {
                ActivityMasterRecord.recordID = ActivityMasterDatabase.getInstance().addRecord(byArray);
            } else {
                activityMasterDatabase.editRecord(ActivityMasterRecord.recordID, byArray);
            }
            if (this.gotoEntryForm) {
                this.deleteAll();
                DisplayController.show((Displayable)new ActivityEntryForm(50));
            } else {
                this.deleteAll();
                if (DefaultsRecord.userOption == 0) {
                    DisplayController.message("Ascendo Fitness v2.7 [Trial]", this.mode == 40 ? "You have added a new Type to the Activities database. Select Activities, Edit Type to modify." : "You have edited an Activity type.", this);
                } else {
                    DisplayController.showMenu(2);
                }
            }
        }
        catch (Exception exception) {
            DisplayController.show((Displayable)new Alert("New Type", "Error while updating database.\nMessage: " + exception.toString(), null, AlertType.ERROR));
        }
    }
}

