/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.assistants;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessObjects;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.database.others.UserSettingsRecord;
import com.ascendo.fitness.forms.assistants.MetabolismDisplayForm;
import com.ascendo.fitness.util.ConversionUtils;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public final class MetabolismForm
extends Form
implements CommandListener {
    private final TextField height1Field = new TextField("Height (" + FitnessObjects.HEIGHT1_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final TextField height2Field = new TextField("Height (" + FitnessObjects.HEIGHT2_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final TextField weightField = new TextField("Weight (" + FitnessObjects.WEIGHT_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final ChoiceGroup genderField = new ChoiceGroup("Gender: ", 4, FitnessObjects.GENDER_TYPES, null);
    private final TextField ageField = new TextField("Age: ", "1", 5, 2);
    private final StringItem bmr = new StringItem("Basal Metabolism Rate: ", "");

    public MetabolismForm() {
        super("Basal Metabolism Rate");
        boolean bl = DefaultsRecord.measurement == 0;
        this.height1Field.setString("" + (bl ? UserSettingsRecord.height1US : UserSettingsRecord.height1Metric));
        this.height2Field.setString("" + (bl ? UserSettingsRecord.height2US : UserSettingsRecord.height2Metric));
        this.weightField.setString("" + (bl ? UserSettingsRecord.weightUS : UserSettingsRecord.weightMetric));
        this.genderField.setSelectedIndex(UserSettingsRecord.genderIndex, true);
        this.ageField.setString("" + UserSettingsRecord.age);
        this.append((Item)this.height1Field);
        this.append((Item)this.height2Field);
        this.append((Item)this.weightField);
        this.append((Item)this.ageField);
        this.append((Item)this.genderField);
        this.append((Item)this.bmr);
        this.addCommand(FitnessCommands.BACK_COMMAND);
        this.addCommand(FitnessCommands.DAILYCALS_COMMAND);
        this.addCommand(FitnessCommands.CALCULATE_COMMAND);
        this.setCommandListener(this);
        this.calculateBMR();
    }

    private void calculateBMR() {
        try {
            int n = 0;
            boolean bl = DefaultsRecord.measurement == 0;
            int n2 = Integer.parseInt(this.height1Field.getString());
            int n3 = Integer.parseInt(this.height2Field.getString());
            int n4 = Integer.parseInt(this.weightField.getString());
            if (n2 < 0 || n3 < 0 || n4 < 0) {
                throw new Exception();
            }
            int n5 = 0;
            if (bl) {
                n5 = (n2 * 12 + n3) * 254 / 100;
                n4 = ConversionUtils.toKGs(n4);
            } else {
                n5 = n3 + n2 * 100;
            }
            if (this.genderField.getSelectedIndex() == 0) {
                n = 66;
                n += 137 * n4 / 10;
                n += 5 * n5;
                n -= 68 * Integer.parseInt(this.ageField.getString()) / 10;
            } else {
                n = 655;
                n += 96 * n4 / 10;
                n += 18 * n5 / 10;
                n -= 47 * Integer.parseInt(this.ageField.getString()) / 10;
            }
            this.bmr.setText("" + n);
        }
        catch (Exception exception) {
            this.bmr.setText("Invalid input(s).");
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.BACK_COMMAND) {
            DisplayController.showMenu(7);
        } else if (command == FitnessCommands.DAILYCALS_COMMAND) {
            this.doDailyCals();
        } else if (command == FitnessCommands.CALCULATE_COMMAND) {
            this.calculateBMR();
        }
    }

    private void doDailyCals() {
        boolean bl;
        boolean bl2 = bl = DefaultsRecord.measurement == 0;
        if (bl) {
            UserSettingsRecord.height1US = Integer.parseInt(this.height1Field.getString());
            UserSettingsRecord.height2US = Integer.parseInt(this.height2Field.getString());
            UserSettingsRecord.height1Metric = ConversionUtils.toMeters(UserSettingsRecord.height1US, UserSettingsRecord.height2US);
            UserSettingsRecord.height2Metric = ConversionUtils.toCentimeters(UserSettingsRecord.height1US, UserSettingsRecord.height2US);
            UserSettingsRecord.weightUS = Integer.parseInt(this.weightField.getString());
            UserSettingsRecord.weightMetric = ConversionUtils.toKGs(UserSettingsRecord.weightUS);
        } else {
            UserSettingsRecord.height1Metric = Integer.parseInt(this.height1Field.getString());
            UserSettingsRecord.height2Metric = Integer.parseInt(this.height2Field.getString());
            UserSettingsRecord.height1US = ConversionUtils.toFeets(UserSettingsRecord.height1Metric, UserSettingsRecord.height2Metric);
            UserSettingsRecord.height2US = ConversionUtils.toInches(UserSettingsRecord.height1Metric, UserSettingsRecord.height2Metric);
            UserSettingsRecord.weightMetric = Integer.parseInt(this.weightField.getString());
            UserSettingsRecord.weightUS = ConversionUtils.toLbs(UserSettingsRecord.weightMetric);
        }
        UserSettingsRecord.genderIndex = this.genderField.getSelectedIndex();
        UserSettingsRecord.age = Integer.parseInt(this.ageField.getString());
        UserSettingsRecord.save();
        DisplayController.show((Displayable)new MetabolismDisplayForm(Integer.parseInt(this.bmr.getText())));
    }
}

