/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.nutrition;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.database.nutrition.NutritionDailyDatabase;
import com.ascendo.fitness.database.nutrition.NutritionDailyRecord;
import com.ascendo.fitness.database.nutrition.NutritionMasterRecord;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.util.ConversionUtils;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public final class NutritionEntryForm
extends Form
implements CommandListener {
    private final int mode;
    private final DateField dateEditor;
    private final TextField unitsField;
    private final StringItem caloriesItem;
    private final StringItem proteinsItem;
    private final StringItem carbohydratesItem;
    private final StringItem fatsItem;

    public NutritionEntryForm(int n) {
        super("");
        this.mode = n;
        if (n == 40 || n == 50) {
            this.setTitle("New Entry");
        } else {
            this.setTitle("Edit Entry");
        }
        this.append((Item)new StringItem("Item: ", NutritionMasterRecord.description));
        this.dateEditor = new DateField("Date: ", 1);
        Date date = new Date();
        if (n == 30) {
            date.setTime(NutritionDailyRecord.milliSeconds);
        }
        this.dateEditor.setDate(date);
        this.append((Item)this.dateEditor);
        System.out.println("NutritionEntryForm 2");
        this.unitsField = new TextField("Servings (" + NutritionMasterRecord.servings + "): ", n == 30 ? "" + NutritionDailyRecord.quantity / 10 + "." + NutritionDailyRecord.quantity % 10 : "1", 3, 5);
        this.append((Item)this.unitsField);
        this.caloriesItem = new StringItem("Calories:", "");
        this.proteinsItem = new StringItem("Proteins: ", "");
        this.carbohydratesItem = new StringItem("Carbohydrates: ", "");
        this.fatsItem = new StringItem("Fats: ", "");
        this.append((Item)this.caloriesItem);
        this.append((Item)this.carbohydratesItem);
        this.append((Item)this.fatsItem);
        this.append((Item)this.proteinsItem);
        System.out.println("NutritionEntryForm 4");
        this.addCommand(FitnessCommands.CANCEL_COMMAND);
        this.addCommand(FitnessCommands.SAVE_COMMAND);
        this.addCommand(FitnessCommands.CALCULATE_COMMAND);
        this.setCommandListener(this);
        this.calculateCalories();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == DisplayController.MESSAGE_ALERT && command == Alert.DISMISS_COMMAND) {
            DisplayController.showMenu(1);
            return;
        }
        if (command == FitnessCommands.CANCEL_COMMAND) {
            if (this.mode == 30) {
                DisplayController.showForm(-102);
            } else {
                DisplayController.showForm(-101);
            }
        } else if (command == FitnessCommands.SAVE_COMMAND) {
            this.doSubmit();
        } else if (command == FitnessCommands.CALCULATE_COMMAND) {
            this.calculateCalories();
        }
    }

    private void doSubmit() {
        String string = ConversionUtils.getInvalidField(this);
        if (string != null) {
            DisplayController.error(this.getTitle(), "Invalid (or No) value specified for " + string.substring(0, string.indexOf(58)));
            return;
        }
        try {
            NutritionDailyDatabase nutritionDailyDatabase = NutritionDailyDatabase.getInstance();
            if (this.mode == 40 || this.mode == 50) {
                nutritionDailyDatabase.addRecord(("" + this.dateEditor.getDate().getTime() + '|' + NutritionMasterRecord.description + '|' + Integer.parseInt(this.getUnitsValue(this.unitsField.getString())) + '|' + NutritionMasterRecord.recordID).getBytes());
                this.deleteAll();
                if (DefaultsRecord.userOption == 0) {
                    DisplayController.message("Ascendo Fitness v2.7 [Trial]", "You have added a new Entry to the Nutrition database. Select Nutrition, Edit Entry to modify or Progress, Calories In to view a graph.", this);
                } else {
                    DisplayController.showMenu(1);
                }
            } else {
                nutritionDailyDatabase.editRecord(NutritionDailyRecord.recordID, ("" + this.dateEditor.getDate().getTime() + '|' + NutritionMasterRecord.description + '|' + Integer.parseInt(this.getUnitsValue(this.unitsField.getString())) + '|' + NutritionMasterRecord.recordID).getBytes());
                this.deleteAll();
                if (DefaultsRecord.userOption == 0) {
                    DisplayController.message("Ascendo Fitness v2.7 [Trial]", "You have edited a Nutrition Entry. Select Progress, Calories In to view a graph.", this);
                } else {
                    DisplayController.showMenu(1);
                }
            }
        }
        catch (Exception exception) {
            DisplayController.show((Displayable)new Alert("Ascendo Fitness v2.7 [Trial]", "Error while updating database.\nMessage: " + exception.toString(), null, AlertType.ERROR));
        }
    }

    private void calculateCalories() {
        try {
            int n = Integer.parseInt(this.getUnitsValue(this.unitsField.getString()));
            if (n <= 0) {
                throw new Exception();
            }
            this.caloriesItem.setText("" + n * NutritionMasterRecord.caloriesPerServing / 10);
            int n2 = n * NutritionMasterRecord.proteins / 10;
            int n3 = n * NutritionMasterRecord.carbohydrates / 10;
            int n4 = n * NutritionMasterRecord.fats / 10;
            this.proteinsItem.setText(n2 / 10 + "." + n2 % 10);
            this.carbohydratesItem.setText(n3 / 10 + "." + n3 % 10);
            this.fatsItem.setText(n4 / 10 + "." + n4 % 10);
        }
        catch (Exception exception) {
            this.caloriesItem.setText("Invalid Input");
            this.carbohydratesItem.setText("Invalid Input");
            this.proteinsItem.setText("Invalid Input");
            this.fatsItem.setText("Invalid Input");
        }
    }

    private String getUnitsValue(String string) {
        int n = 0;
        String string2 = "";
        String string3 = "";
        try {
            n = string.indexOf(46);
            System.out.println("No 1");
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, n + 2);
            System.out.println("No  2");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println("No decimal point");
            return string + "0";
        }
        catch (Exception exception) {
            System.out.println("dont knoe");
        }
        System.out.println("No 3");
        System.out.println("returning number = " + string3 + string2);
        return string3 + string2;
    }
}

