/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.nutrition;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.custom.YesNoAlert;
import com.ascendo.fitness.database.MasterDatabase;
import com.ascendo.fitness.database.nutrition.NutritionMasterDatabase;
import com.ascendo.fitness.forms.SearchForm;
import com.ascendo.fitness.forms.nutrition.NutritionEntryForm;
import com.ascendo.fitness.forms.nutrition.NutritionTypeForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public final class NutritionSearchForm
extends SearchForm {
    public NutritionSearchForm(int n) {
        super(n, 1);
        if (n == 10) {
            this.setTitle("New Entry");
        } else if (n == 30) {
            this.setTitle("Edit Type");
        } else {
            this.setTitle("Browse");
        }
    }

    public void doSearch() {
        NutritionMasterDatabase nutritionMasterDatabase = NutritionMasterDatabase.getInstance();
        byte[] byArray = this.itemField.getString().getBytes();
        try {
            nutritionMasterDatabase.search(byArray, this.mode == 20 || this.mode == 30);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("search found =" + nutritionMasterDatabase.found);
        if (nutritionMasterDatabase.found <= 0) {
            if (this.mode == 20) {
                DisplayController.show((Displayable)new Alert(this.getTitle(), "No entries found", null, AlertType.INFO));
                return;
            }
            DisplayController.show((Displayable)new YesNoAlert("Ascendo Fitness v2.7 [Trial]", "Item \"" + this.itemField.getString() + "\" not found. Do you want to add it to Nutrition database?", this));
        } else {
            if (this.matchingItemsList == null) {
                this.matchingItemsList = new List("", 3);
                if (this.mode == 10) {
                    this.matchingItemsList.setTitle("New Entry");
                } else if (this.mode == 30) {
                    this.matchingItemsList.setTitle("Edit Type");
                } else {
                    this.matchingItemsList.setTitle("Browse");
                }
                System.out.println("Searched for more than one entries");
                this.matchingItemsList.addCommand(FitnessCommands.SELECT_COMMAND);
                this.matchingItemsList.addCommand(FitnessCommands.BACK_COMMAND);
                if (this.mode == 30) {
                    this.matchingItemsList.addCommand(FitnessCommands.DELETE_COMMAND);
                }
                this.matchingItemsList.setCommandListener((CommandListener)this);
            } else if (this.matchingItemsList.size() > 0) {
                this.matchingItemsList.deleteAll();
            }
            int n = nutritionMasterDatabase.displayNames.size();
            int n2 = -1;
            String string = null;
            for (int i = 0; i < n; ++i) {
                string = nutritionMasterDatabase.displayName(i);
                if (this.mode == 20 && n2 == -1 && MasterDatabase.compareBytes(string.getBytes(), byArray) == 0) {
                    n2 = i;
                }
                this.matchingItemsList.append(string, null);
            }
            if (this.mode == 20) {
                if (n2 == -1) {
                    n2 = 0;
                }
                try {
                    this.matchingItemsList.setSelectedIndex(n2 + 7, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.matchingItemsList.setSelectedIndex(n2, true);
            }
            DisplayController.show((Displayable)this.matchingItemsList);
            byArray = null;
        }
    }

    public void doItemSelection(int n) {
        if (this.matchingItemsList != null) {
            this.matchingItemsList.deleteAll();
        }
        NutritionMasterDatabase nutritionMasterDatabase = NutritionMasterDatabase.getInstance();
        nutritionMasterDatabase.fetch(nutritionMasterDatabase.recordID(n));
        if (this.mode == 10) {
            DisplayController.show((Displayable)new NutritionEntryForm(40));
        } else if (this.mode == 30) {
            DisplayController.show((Displayable)new NutritionTypeForm(false));
        } else {
            DisplayController.show((Displayable)new NutritionTypeForm(true));
        }
    }

    public void doDelete(int n) {
        NutritionMasterDatabase nutritionMasterDatabase = NutritionMasterDatabase.getInstance();
        int n2 = nutritionMasterDatabase.recordID(n);
        try {
            nutritionMasterDatabase.deleteRecord(n2);
            this.matchingItemsList.delete(n);
            nutritionMasterDatabase.recordIDs.removeIntAt(n);
            nutritionMasterDatabase.displayNames.removeElementAt(n);
            if (this.matchingItemsList.size() <= 0) {
                DisplayController.showMenu(this.backMenu);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void yes() {
        DisplayController.show((Displayable)new NutritionTypeForm(this.itemField.getString(), true));
    }

    public void no() {
        DisplayController.show((Displayable)this);
    }
}

