/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.journal;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessObjects;
import com.ascendo.fitness.database.journal.JournalDatabase;
import com.ascendo.fitness.database.journal.JournalRecord;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.util.ConversionUtils;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;

public final class JournalEntryForm
extends Form
implements CommandListener {
    private final DateField dateEditor;
    private final TextField weightField;
    private final TextField memoField;
    private final int mode;

    public JournalEntryForm(int n) {
        super("");
        this.mode = n;
        if (n == 40) {
            this.setTitle("New Entry");
        } else {
            this.setTitle("Edit Entry");
        }
        this.dateEditor = new DateField("Date: ", 1);
        Date date = new Date();
        if (n == 30) {
            date.setTime(JournalRecord.milliSeconds);
        }
        this.dateEditor.setDate(date);
        this.weightField = new TextField("Weight (" + FitnessObjects.WEIGHT_UNIT_TYPES[DefaultsRecord.measurement] + "): ", n == 30 ? "" + (DefaultsRecord.measurement == 0 ? JournalRecord.weightUS : JournalRecord.weightMetric) : "" + (DefaultsRecord.measurement == 0 ? 130 : 58), 5, 2);
        this.memoField = new TextField("Memo: ", n == 30 ? JournalRecord.memo : "", 255, 0);
        this.append((Item)this.dateEditor);
        this.append((Item)this.weightField);
        this.append((Item)this.memoField);
        this.addCommand(FitnessCommands.CANCEL_COMMAND);
        this.addCommand(FitnessCommands.SAVE_COMMAND);
        this.setCommandListener(this);
        this.setTicker(new Ticker(FitnessObjects.TICKER_MESSAGES[(int)(System.currentTimeMillis() % (long)FitnessObjects.TICKER_MESSAGES.length)]));
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == DisplayController.MESSAGE_ALERT && command == Alert.DISMISS_COMMAND) {
            DisplayController.showMenu(3);
            return;
        }
        if (command == FitnessCommands.CANCEL_COMMAND) {
            if (this.mode == 30) {
                DisplayController.showForm(-302);
            } else {
                DisplayController.showMenu(3);
            }
        } else if (command == FitnessCommands.SAVE_COMMAND) {
            this.doSubmit();
        }
    }

    private void doSubmit() {
        String string = ConversionUtils.getInvalidField(this);
        if (string != null) {
            DisplayController.error(this.getTitle(), "Invalid (or No) value specified for " + string.substring(0, string.indexOf(58)));
            return;
        }
        try {
            JournalDatabase journalDatabase = JournalDatabase.getInstance();
            int n = Integer.parseInt(this.weightField.getString());
            int n2 = 0;
            int n3 = 0;
            if (DefaultsRecord.measurement == 0) {
                n2 = n;
                n3 = ConversionUtils.toKGs(n2);
            } else {
                n3 = n;
                n2 = ConversionUtils.toLbs(n3);
            }
            if (this.mode == 40) {
                journalDatabase.addRecord(("" + this.dateEditor.getDate().getTime() + '|' + n2 + '|' + n3 + '|' + this.memoField.getString()).getBytes());
                this.deleteAll();
                if (DefaultsRecord.userOption == 0) {
                    DisplayController.message("Ascendo Fitness v2.7 [Trial]", "You have added a new Entry to the Journal database.  Select Journal, Edit Entry to modify or Progress, Weight to view a graph.", this);
                } else {
                    DisplayController.showMenu(3);
                }
            } else {
                journalDatabase.editRecord(JournalRecord.recordID, ("" + this.dateEditor.getDate().getTime() + '|' + n2 + '|' + n3 + '|' + this.memoField.getString()).getBytes());
                this.deleteAll();
                if (DefaultsRecord.userOption == 0) {
                    DisplayController.message("Ascendo Fitness v2.7 [Trial]", "You have edited a Journal Entry. Select Progress, Weight to view a graph.", this);
                } else {
                    DisplayController.showMenu(3);
                }
            }
        }
        catch (Exception exception) {
            DisplayController.show((Displayable)new Alert("Ascendo Fitness v2.7 [Trial]", "Error while updating database.\nMessage: " + exception.toString(), null, AlertType.ERROR));
        }
    }
}

