/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.util;

public final class StringVector {
    private String[] elementData = new String[10];
    private int elementCount;
    private int capacityIncrement = 10;

    public int size() {
        return this.elementCount;
    }

    public boolean contains(String string) {
        return this.indexOf(string, 0) >= 0;
    }

    public int indexOf(String string, int n) {
        if (string == null) {
            for (int i = n; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                if (!string.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public String elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.elementData[n];
    }

    public void removeElementAt(int n) {
        if (n >= this.elementCount || n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    private void ensureCapacityHelper(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            String[] stringArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new String[n3];
            System.arraycopy(stringArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public void addElement(String string) {
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = string;
    }

    public void clear() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public String[] toArray() {
        String[] stringArray = new String[this.elementCount];
        System.arraycopy(this.elementData, 0, stringArray, 0, this.elementCount);
        return stringArray;
    }
}

