/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public class AtomicAI {
    private Board iPlayBoard;
    private Board iScratchBoard;
    public int x;
    public int y;
    public static final int SQUARE_PLAYER1 = 32;
    public static final int SQUARE_PLAYER2 = 64;
    public static final int SQUARE_PLAYER3 = 128;
    public static final int SQUARE_PLAYER4 = 256;
    private int iNumHumans;
    private int iNumComputers;
    private int iAI;
    private Vector iMoves;
    private Random iRandom;

    public AtomicAI(Board board, int n, int n2, int n3) {
        this.iPlayBoard = board;
        this.iScratchBoard = new Board();
        this.iScratchBoard.Init();
        this.iScratchBoard.Stop();
        int n4 = Board.rows * Board.columns;
        this.iMoves = new Vector(n4);
        this.iRandom = new Random();
        this.iNumHumans = n;
        this.iNumComputers = n2;
        this.iAI = n3;
    }

    public boolean ComputerPlayer(int n) {
        switch (n) {
            case 32: {
                return this.iNumHumans < 1;
            }
            case 64: {
                return this.iNumHumans < 2;
            }
            case 128: {
                return this.iNumHumans < 3;
            }
            case 256: {
                return this.iNumHumans < 4;
            }
        }
        return false;
    }

    public void CopyBoard() {
        int n = 0;
        while (n < Board.columns) {
            int n2 = 0;
            while (n2 < Board.rows) {
                this.iScratchBoard.board[n][n2] = this.iPlayBoard.board[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public void InsertMove(AtomicAI$Move atomicAI$Move) {
        if (this.iMoves.size() == 0) {
            this.iMoves.insertElementAt(atomicAI$Move, 0);
        }
        int n = 0;
        while (n < this.iMoves.size()) {
            if (((AtomicAI$Move)this.iMoves.elementAt((int)n)).score <= atomicAI$Move.score) {
                this.iMoves.insertElementAt(atomicAI$Move, n);
                return;
            }
            ++n;
        }
    }

    public void RandomiseMoves() {
        int n = 0;
        int n2 = ((AtomicAI$Move)this.iMoves.elementAt((int)0)).score;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n5 < this.iMoves.size()) {
            int n6 = ((AtomicAI$Move)this.iMoves.elementAt((int)n5)).score;
            if (n2 != n6) {
                ++n;
                n2 = n6;
                n4 = n5 - 1;
                this.Shuffle(n3, n4);
                n3 = n5;
            }
            ++n5;
        }
        if (n == 0) {
            this.Shuffle(0, this.iMoves.size());
        }
    }

    public void ResetMoves() {
        this.iMoves.removeAllElements();
    }

    public void Shuffle(int n, int n2) {
        int n3 = n2 - n;
        if (n2 - n <= 1) {
            return;
        }
        int n4 = 0;
        while (n4 < 200) {
            int n5 = this.iRandom.nextInt() % n3;
            if (n5 < 0) {
                n5 -= n5 * 2;
            }
            n5 += n;
            int n6 = this.iRandom.nextInt() % n3;
            if (n6 < 0) {
                n6 -= n6 * 2;
            }
            AtomicAI$Move atomicAI$Move = (AtomicAI$Move)this.iMoves.elementAt(n5);
            this.iMoves.removeElementAt(n5);
            this.iMoves.insertElementAt(atomicAI$Move, n6 += n);
            ++n4;
        }
    }

    public void getMove(int n) {
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.iScratchBoard.Score(32);
        int n5 = this.iScratchBoard.Score(64);
        int n6 = this.iScratchBoard.Score(128);
        int n7 = this.iScratchBoard.Score(256);
        this.ResetMoves();
        int n8 = 0;
        while (n8 < Board.rows) {
            n3 = 0;
            while (n3 < Board.columns) {
                this.CopyBoard();
                if (this.iScratchBoard.AddAtom(n, n8, n3)) {
                    n2 = 0;
                    while (n2 < 3) {
                        if (!this.iScratchBoard.Stable()) {
                            this.iScratchBoard.Reaction();
                        }
                        ++n2;
                    }
                    int n9 = this.iScratchBoard.Score(n);
                    if (n != 32 & this.iScratchBoard.Score(32) < n4) {
                        n9 += 2;
                    }
                    if (n != 64 & this.iScratchBoard.Score(64) < n5) {
                        n9 += 2;
                    }
                    if (n != 128 & this.iScratchBoard.Score(128) < n6) {
                        n9 += 2;
                    }
                    if (n != 256 & this.iScratchBoard.Score(256) < n7) {
                        n9 += 2;
                    }
                    AtomicAI$Move atomicAI$Move = new AtomicAI$Move(this, n8, n3, n9);
                    this.InsertMove(atomicAI$Move);
                }
                ++n3;
            }
            ++n8;
        }
        n3 = this.iAI;
        if (this.iMoves.size() < n3) {
            n3 = this.iMoves.size();
        }
        this.RandomiseMoves();
        n2 = n3 == 0 ? 0 : this.iRandom.nextInt() % n3;
        if (n2 < 0) {
            n2 -= n2 * 2;
        }
        this.x = ((AtomicAI$Move)this.iMoves.elementAt((int)n2)).x;
        this.y = ((AtomicAI$Move)this.iMoves.elementAt((int)n2)).y;
    }
}

