@echo off

rem This batch file builds and preverifies the code for the examples.
rem it then packages them in a JAR file appropriately.

echo *** Creating directories ***
echo *** (this stage may produce already exist errors. Ignore them). ***

mkdir ..\tmpclasses
mkdir ..\classes
mkdir ..\obfuscated

echo *** Compiling source files ***

javac -bootclasspath C:\Java\J2mewtk\lib\midpapi.zip -d ..\tmpclasses -classpath ..\tmpclasses ..\src\asteroids\*.java
echo *** Obfuscating class files ***
java jode.obfuscator.Main Asteroids.jos

echo *** Verifying class files ***

rem WARNING: When running under windows 9x the JAR may be incomplete
rem due to a bug in windows 98. Simply place a pause statement between
rem the preverify and JAR stages and wait 5 seconds before continuing
rem the build.

C:\Java\J2mewtk\bin\preverify -classpath C:\Java\J2mewtk\lib\midpapi.zip;..\obfuscated -d ..\classes ..\obfuscated

echo *** Jaring verified class files ***
jar cmf MANIFEST.MF Asteroids.jar -C ..\classes .

echo *** Jaring resource files ***
jar umf MANIFEST.MF Asteroids.jar -C ..\res .

echo *** Don't forget to update the JAR file size in the JAD file ***

