/*
 * Decompiled with CFR 0.152.
 */
package game2048.scene;

import game2048.scene.Animable;
import game2048.scene.Drawable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Number
implements Animable,
Drawable {
    public static final int WIDTH = 41;
    public static final int HEIGHT = 41;
    private static final int HALF_WIDTH = 20;
    private static final int HALF_HEIGHT = 20;
    private static final float APPEARING_DEFAULT_HORIZONTAL_MARGIN = 20.0f;
    private static final float APPEARING_DEFAULT_VERTICAL_MARGIN = 20.0f;
    private static final float APPEARING_DURATION = 75.0f;
    private static final float MOVEMENT_DURATION = 100.0f;
    private static final Hashtable IMAGES = new Hashtable(16);
    private final String number;
    private final int foreground;
    private final int background;
    private final int roundness;
    private int currentX;
    private int currentY;
    private final Image numberImage;
    private final int imageOffsetX;
    private final int imageOffsetY;
    private int moveDestinationX;
    private int moveDestinationY;
    private float moveDistance;
    private int moveDirection;
    private Runnable runOnMovementStop = null;
    private float movingSpeed;
    private boolean moving = false;
    private float horizontalClipMargin;
    private float verticalClipMargin;
    private Runnable runOnAppear = null;
    private float verticalAppearingSpeed;
    private float horizontalAppearingSpeed;
    private boolean appeared = false;
    private boolean appearing = false;
    static /* synthetic */ Class class$game2048$scene$Number;

    public Number(int n, int n2, int n3, int n4) {
        this.number = Integer.toString(n);
        this.roundness = n4;
        this.currentX = n2;
        this.currentY = n3;
        switch (n) {
            case 2: {
                this.background = 15656154;
                break;
            }
            case 4: {
                this.background = 15589576;
                break;
            }
            case 8: {
                this.background = 15905145;
                break;
            }
            case 16: {
                this.background = 16094563;
                break;
            }
            case 32: {
                this.background = 16153695;
                break;
            }
            case 64: {
                this.background = 16145979;
                break;
            }
            case 128: {
                this.background = 15585138;
                break;
            }
            case 256: {
                this.background = 15584353;
                break;
            }
            case 512: {
                this.background = 15583312;
                break;
            }
            case 1024: {
                this.background = 15582527;
                break;
            }
            case 2048: {
                this.background = 15581742;
                break;
            }
            default: {
                this.background = 3947058;
            }
        }
        switch (n) {
            case 2: 
            case 4: {
                this.foreground = 0;
                break;
            }
            default: {
                this.foreground = 16381682;
            }
        }
        this.numberImage = Number.getImage(n);
        if (this.numberImage == null) {
            this.imageOffsetX = 0;
            this.imageOffsetY = 0;
        } else {
            this.imageOffsetX = (41 - this.numberImage.getWidth()) / 2;
            this.imageOffsetY = (41 - this.numberImage.getHeight()) / 2;
        }
    }

    private static synchronized Image getImage(int n) {
        try {
            Integer n2 = new Integer(n);
            Image image = (Image)IMAGES.get(n2);
            if (image == null) {
                image = Image.createImage((InputStream)(class$game2048$scene$Number == null ? (class$game2048$scene$Number = Number.class$("game2048.scene.Number")) : class$game2048$scene$Number).getResourceAsStream("images/numbers/" + Integer.toString(n) + ".png"));
                IMAGES.put(n2, image);
            }
            return image;
        }
        catch (IOException iOException) {
            System.err.println("Failed to load image for number " + n + ".");
            iOException.printStackTrace();
            return null;
        }
    }

    public final boolean animate(long l) {
        if (!this.moving && !this.appearing) {
            return false;
        }
        if (this.appearing) {
            this.animateAppearing(l);
        }
        if (this.moving) {
            this.animateMovement(l);
        }
        return true;
    }

    public final void draw(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!this.appeared) {
            if (!this.appearing) {
                return;
            }
            int n5 = (int)this.verticalClipMargin;
            int n6 = (int)this.horizontalClipMargin;
            n = graphics.getClipX();
            n2 = graphics.getClipY();
            n3 = graphics.getClipWidth();
            n4 = graphics.getClipHeight();
            graphics.setClip(this.currentX + n6, this.currentY + n5, 41 - n6 * 2, 41 - n5 * 2);
        }
        this.drawAt(this.currentX, this.currentY, graphics);
        if (!this.appeared && this.appearing) {
            graphics.setClip(n, n2, n3, n4);
        }
    }

    private void drawAt(int n, int n2, Graphics graphics) {
        graphics.setColor(this.background);
        graphics.fillRoundRect(n, n2, 41, 41, this.roundness, this.roundness);
        if (this.numberImage == null) {
            graphics.setColor(this.foreground);
            graphics.drawString(this.number, n + 20, n2 + 20, 65);
        } else {
            graphics.drawImage(this.numberImage, n + this.imageOffsetX, n2 + this.imageOffsetY, 20);
        }
    }

    public final void appear(Runnable runnable) {
        if (this.appeared) {
            return;
        }
        this.appearing = true;
        this.verticalClipMargin = 20.0f;
        this.horizontalClipMargin = 20.0f;
        this.runOnAppear = runnable;
        this.verticalAppearingSpeed = this.verticalClipMargin / 75.0f;
        this.horizontalAppearingSpeed = this.horizontalClipMargin / 75.0f;
    }

    public final void move(int n, int n2, Runnable runnable) {
        this.moving = true;
        this.moveDistance = n;
        this.moveDirection = n2;
        switch (n2) {
            case 1: {
                this.moveDestinationX = this.currentX - n;
                this.moveDestinationY = this.currentY;
                break;
            }
            case 2: {
                this.moveDestinationX = this.currentX;
                this.moveDestinationY = this.currentY - n;
                break;
            }
            case 4: {
                this.moveDestinationX = this.currentX + n;
                this.moveDestinationY = this.currentY;
                break;
            }
            case 8: {
                this.moveDestinationX = this.currentX;
                this.moveDestinationY = this.currentY + n;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction");
            }
        }
        this.movingSpeed = (float)n / 100.0f;
        this.runOnMovementStop = runnable;
    }

    private void animateMovement(long l) {
        float f = (float)l * this.movingSpeed;
        this.moveDistance -= f;
        if (this.moveDistance <= 0.0f) {
            this.currentX = this.moveDestinationX;
            this.currentY = this.moveDestinationY;
            this.moving = false;
            if (this.runOnMovementStop != null) {
                this.runOnMovementStop.run();
            }
            return;
        }
        switch (this.moveDirection) {
            case 1: {
                this.currentX = (int)((float)this.moveDestinationX + this.moveDistance);
                break;
            }
            case 2: {
                this.currentY = (int)((float)this.moveDestinationY + this.moveDistance);
                break;
            }
            case 4: {
                this.currentX = (int)((float)this.moveDestinationX - this.moveDistance);
                break;
            }
            case 8: {
                this.currentY = (int)((float)this.moveDestinationY - this.moveDistance);
            }
        }
    }

    private void animateAppearing(long l) {
        float f = (float)l * this.verticalAppearingSpeed;
        float f2 = (float)l * this.horizontalAppearingSpeed;
        boolean bl = false;
        boolean bl2 = false;
        if (f > this.verticalClipMargin) {
            this.verticalClipMargin = 0.0f;
            bl = true;
        } else {
            this.verticalClipMargin -= f;
        }
        if (f2 > this.horizontalClipMargin) {
            this.horizontalClipMargin = 0.0f;
            bl2 = true;
        } else {
            this.horizontalClipMargin -= f2;
        }
        if (bl && bl2) {
            this.appearing = false;
            this.appeared = true;
            if (this.runOnAppear != null) {
                this.runOnAppear.run();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

