/*
 * Decompiled with CFR 0.152.
 */
package game2048.scene;

import game2048.scene.Dimensions;
import game2048.scene.Drawable;
import game2048.scene.ScoreDrawingTool;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Score
implements Drawable {
    private static final int BACKGROUND = 12299680;
    private static final int NUMBER_SPACING = 1;
    private static final int PADDING = 5;
    private int x;
    private int y;
    private final int roundness;
    private final Image titleImage;
    private int score;
    private Dimensions textDimensions;
    private int width;
    private int height;
    private int titleX;
    private int titleY;
    private int textX;
    private int textY;

    public Score(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        this.x = n;
        this.y = n2;
        this.roundness = n4;
        this.width = n3;
        this.titleImage = Image.createImage((InputStream)this.getClass().getResourceAsStream("images/score/" + (bl ? "best" : "score") + ".png"));
        this.setScore(0);
    }

    public final void setScore(int n) {
        this.score = n;
        this.textDimensions = ScoreDrawingTool.getScoreDimensions(n, 1);
        this.updatePositions();
    }

    private void updatePositions() {
        this.height = 15 + this.titleImage.getHeight() + this.textDimensions.height;
        this.titleX = this.x + (this.width - this.titleImage.getWidth()) / 2;
        this.titleY = this.y + 5;
        this.textX = this.x + (this.width - this.textDimensions.width) / 2;
        this.textY = this.titleY + this.titleImage.getHeight() + 5;
    }

    public final void draw(Graphics graphics) {
        graphics.setColor(12299680);
        graphics.fillRoundRect(this.x, this.y, this.width, this.height, this.roundness, this.roundness);
        graphics.drawImage(this.titleImage, this.titleX, this.titleY, 20);
        ScoreDrawingTool.drawScore(this.score, this.textX, this.textY, 1, graphics);
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final void setX(int n) {
        this.x = n;
        this.updatePositions();
    }

    public final void setY(int n) {
        this.y = n;
        this.updatePositions();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }
}

