/*
 * Decompiled with CFR 0.152.
 */
package game2048.scene;

import game2048.scene.Drawable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Grid
implements Drawable {
    private static final int CELL_BACKGROUND = 13484468;
    private static final int BORDER_COLOR = 12299680;
    private int x;
    private int y;
    private final int width;
    private final int height;
    private final int rows;
    private final int cols;
    private final int cellMargin;
    private final int cellWidth;
    private final int cellHeight;
    private final int roundness;
    private final Image gridImage;
    private int cellDrawStartX;
    private int cellDrawStartY;
    private int cellDrawOffsetX;
    private int cellDrawOffsetY;

    public Grid(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.x = n;
        this.y = n2;
        this.rows = n3;
        this.cols = n4;
        this.cellMargin = n7;
        this.cellWidth = n5;
        this.cellHeight = n6;
        this.roundness = n8;
        this.width = 2 * n7 + (2 * n7 + n5) * n4;
        this.height = 2 * n7 + (2 * n7 + n6) * n3;
        this.updatePrecomputedValues();
        this.gridImage = Image.createImage((int)this.width, (int)this.height);
        this.drawAt(0, 0, this.gridImage.getGraphics());
    }

    public final void draw(Graphics graphics) {
        graphics.drawImage(this.gridImage, this.x, this.y, 20);
    }

    private void drawAt(int n, int n2, Graphics graphics) {
        graphics.setColor(12299680);
        graphics.fillRoundRect(n, n2, this.width, this.height, this.roundness, this.roundness);
        graphics.setColor(13484468);
        int n3 = 0;
        int n4 = this.cellDrawStartY;
        while (n3 < this.rows) {
            int n5 = 0;
            int n6 = this.cellDrawStartX;
            while (n5 < this.cols) {
                graphics.fillRoundRect(n6, n4, this.cellWidth, this.cellHeight, this.roundness, this.roundness);
                ++n5;
                n6 += this.cellDrawOffsetX;
            }
            ++n3;
            n4 += this.cellDrawOffsetY;
        }
    }

    private void updatePrecomputedValues() {
        this.cellDrawStartX = this.x + 2 * this.cellMargin;
        this.cellDrawStartY = this.y + 2 * this.cellMargin;
        this.cellDrawOffsetX = this.cellWidth + 2 * this.cellMargin;
        this.cellDrawOffsetY = this.cellHeight + 2 * this.cellMargin;
    }

    public final int colToX(int n) {
        return this.cellDrawStartX + n * this.cellDrawOffsetX;
    }

    public final int rowToY(int n) {
        return this.cellDrawStartY + n * this.cellDrawOffsetY;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final void setX(int n) {
        this.x = n;
        this.updatePrecomputedValues();
    }

    public final void setY(int n) {
        this.y = n;
        this.updatePrecomputedValues();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }
}

