/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class MenuButton
extends CustomItem {
    private Image _image = null;
    private boolean _down = false;
    private int _clicks = 0;
    private String typo;
    private String tex;
    private int wid;

    public MenuButton(Image image, String type, String text, int width) {
        super("");
        this.typo = type;
        this._image = image;
        this.tex = text;
        this.wid = width;
    }

    public String getType() {
        return this.typo;
    }

    public void setImage(Image image) {
        this._image = image;
        this.repaint();
    }

    public Image getImage() {
        return this._image;
    }

    public void setText(String text) {
        this.tex = text;
        this.repaint();
    }

    public String getText() {
        return this.tex;
    }

    public boolean isClicked() {
        if (this._clicks > 0) {
            --this._clicks;
            return true;
        }
        return false;
    }

    public boolean isDown() {
        return this._down;
    }

    public void setDown(boolean down) {
        if (this._down) {
            ++this._clicks;
        }
        if (down != this._down) {
            this._down = down;
            this.repaint();
        }
    }

    public void setDown() {
        this.setDown(true);
    }

    public void setUp() {
        this.setDown(false);
    }

    protected int getMinContentHeight() {
        return this.getImage().getHeight();
    }

    protected int getMinContentWidth() {
        return this.wid;
    }

    protected int getPrefContentHeight(int height) {
        return this.getImage().getHeight() + 2;
    }

    protected int getPrefContentWidth(int width) {
        return this.wid;
    }

    protected void paint(Graphics g, int w, int h) {
        g.setColor(192, 192, 192);
        g.fillRect(0, 0, this.getMinContentWidth(), h);
        g.drawImage(this.getImage(), this.getImage().getWidth() / 2, h / 2, 3);
        g.setColor(this.isDown() ? 0 : 0xFFFFFF);
        g.drawLine(0, 0, w, 0);
        g.drawLine(0, 0, 0, h);
        g.setColor(this.isDown() ? 0xFFFFFF : 0);
        g.drawLine(0, h - 2, w, h - 2);
        g.drawLine(w - 2, 0, w - 2, h);
        g.setColor(0);
        g.drawString(this.tex, this.getImage().getWidth() + 10, h / 2 - 14, 0);
    }

    protected void keyPressed(int c) {
        if (this.getGameAction(c) == 8) {
            this.setDown();
        }
    }

    protected void keyReleased(int c) {
        if (this.getGameAction(c) == 8) {
            this.setUp();
        }
        this.notifyStateChanged();
    }

    protected void pointerPressed(int x, int y) {
        if (x > 0 && x < this.getMinContentWidth() && y < this.getMinContentHeight() && y > 0) {
            this.setDown();
        }
    }

    protected void pointerReleased(int x, int y) {
        if (x > 0 && x < this.getMinContentWidth() && y < this.getMinContentHeight() && y > 0) {
            this.setUp();
            this.notifyStateChanged();
        }
    }
}

