/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class UrlDecoder {
    private static Hashtable dict = new Hashtable();

    static {
        dict.put(" ", "%20");
        dict.put("\u0430", "%D0%B0");
        dict.put("\u0431", "%D0%B1");
        dict.put("\u0432", "%D0%B2");
        dict.put("\u0433", "%D0%B3");
        dict.put("\u0434", "%D0%B4");
        dict.put("\u0435", "%D0%B5");
        dict.put("\u0436", "%D0%B6");
        dict.put("\u0437", "%D0%B7");
        dict.put("\u0438", "%D0%B8");
        dict.put("\u0439", "%D0%B9");
        dict.put("\u043a", "%D0%Ba");
        dict.put("\u043b", "%D0%Bb");
        dict.put("\u043c", "%D0%Bc");
        dict.put("\u043d", "%D0%Bd");
        dict.put("\u043e", "%D0%Be");
        dict.put("\u043f", "%D0%Bf");
        dict.put("\u0440", "%D1%80");
        dict.put("\u0441", "%D1%81");
        dict.put("\u0442", "%D1%82");
        dict.put("\u0443", "%D1%83");
        dict.put("\u0444", "%D1%84");
        dict.put("\u0445", "%D1%85");
        dict.put("\u0446", "%D1%86");
        dict.put("\u0447", "%D1%87");
        dict.put("\u0448", "%D1%88");
        dict.put("\u0449", "%D1%89");
        dict.put("\u044a", "%D1%8a");
        dict.put("\u044b", "%D1%8b");
        dict.put("\u044c", "%D1%8c");
        dict.put("\u044d", "%D1%8d");
        dict.put("\u044e", "%D1%8e");
        dict.put("\u044f", "%D1%8f");
        dict.put("\u0410", "%D0%90");
        dict.put("\u0411", "%D0%91");
        dict.put("\u0412", "%D0%92");
        dict.put("\u0413", "%D0%93");
        dict.put("\u0414", "%D0%94");
        dict.put("\u0415", "%D0%95");
        dict.put("\u0416", "%D0%96");
        dict.put("\u0417", "%D0%97");
        dict.put("\u0418", "%D0%98");
        dict.put("\u0419", "%D0%99");
        dict.put("\u041a", "%D0%9a");
        dict.put("\u041b", "%D0%9b");
        dict.put("\u041c", "%D0%9c");
        dict.put("\u041d", "%D0%9d");
        dict.put("\u041e", "%D0%9e");
        dict.put("\u041f", "%D0%9f");
        dict.put("\u0420", "%D0%a0");
        dict.put("\u0421", "%D0%a1");
        dict.put("\u0422", "%D0%a2");
        dict.put("\u0423", "%D0%a3");
        dict.put("\u0424", "%D0%a4");
        dict.put("\u0425", "%D0%a5");
        dict.put("\u0426", "%D0%a6");
        dict.put("\u0427", "%D0%a7");
        dict.put("\u0428", "%D0%a8");
        dict.put("\u0429", "%D0%a9");
        dict.put("\u042a", "%D0%aa");
        dict.put("\u042b", "%D0%ab");
        dict.put("\u042c", "%D0%ac");
        dict.put("\u042d", "%D0%ad");
        dict.put("\u042e", "%D0%ae");
        dict.put("\u042f", "%D0%af");
        dict.put("\u0451", "%D1%91");
        dict.put("\u0401", "%D0%81");
        dict.put("\u00ab", "\"");
        dict.put("\u00bb", "\"");
        dict.put("-", "-");
        dict.put("_", "_");
        dict.put("\u2014", "-");
        dict.put("\u2212", "-");
        dict.put("\u2012", "-");
        dict.put("\u2043", "-");
        dict.put("\u2013", "-");
        dict.put("\u2015", "-");
        dict.put("\r", "<br>");
        dict.put("\n", "<br>");
        dict.put("0", "0");
        dict.put("1", "1");
        dict.put("2", "2");
        dict.put("3", "3");
        dict.put("4", "4");
        dict.put("5", "5");
        dict.put("6", "6");
        dict.put("7", "7");
        dict.put("8", "8");
        dict.put("9", "9");
        dict.put("a", "a");
        dict.put("b", "b");
        dict.put("c", "c");
        dict.put("d", "d");
        dict.put("e", "e");
        dict.put("f", "f");
        dict.put("g", "g");
        dict.put("h", "h");
        dict.put("i", "i");
        dict.put("j", "j");
        dict.put("k", "k");
        dict.put("l", "l");
        dict.put("m", "m");
        dict.put("n", "n");
        dict.put("o", "o");
        dict.put("p", "p");
        dict.put("q", "q");
        dict.put("r", "r");
        dict.put("s", "s");
        dict.put("t", "t");
        dict.put("u", "u");
        dict.put("v", "v");
        dict.put("w", "w");
        dict.put("x", "x");
        dict.put("y", "y");
        dict.put("z", "z");
        dict.put("A", "A");
        dict.put("B", "B");
        dict.put("C", "C");
        dict.put("D", "D");
        dict.put("E", "E");
        dict.put("F", "F");
        dict.put("G", "G");
        dict.put("H", "H");
        dict.put("I", "I");
        dict.put("G", "G");
        dict.put("K", "K");
        dict.put("L", "L");
        dict.put("M", "M");
        dict.put("N", "N");
        dict.put("O", "O");
        dict.put("P", "P");
        dict.put("Q", "Q");
        dict.put("R", "R");
        dict.put("S", "S");
        dict.put("T", "T");
        dict.put("U", "U");
        dict.put("V", "V");
        dict.put("W", "W");
        dict.put("X", "X");
        dict.put("Y", "Y");
        dict.put("Z", "Z");
        dict.put("?", "%3F");
        dict.put(".", ".");
        dict.put(",", "%2C");
        dict.put("!", "%21");
        dict.put("\"", "%22");
        dict.put("\u00bf", "%C2%BF");
        dict.put("<", "%3C");
        dict.put(">", "%3E");
        dict.put("/", "%2F");
        dict.put("@", "%40");
        dict.put("/", "%2F");
        dict.put("#", "%23");
        dict.put("\u2116", "%E2%84%96");
        dict.put("$", "%24");
        dict.put(";", "%3B");
        dict.put("^", "%5E");
        dict.put(":", "%3A");
        dict.put("&", "%26");
        dict.put("*", "%2A");
        dict.put("(", "%28");
        dict.put(")", "%29");
        dict.put("+", "%2B");
        dict.put("[", "%5B");
        dict.put("]", "%5D");
        dict.put("{", "%7B");
        dict.put("}", "%7D");
        dict.put("~", "~");
        dict.put("`", "%60");
        dict.put("\u00a1", "%C2%A1");
        dict.put("\u0404", "%D0%84");
        dict.put("\u0454", "%D1%94");
        dict.put("\u0490", "%D2%90");
        dict.put("\u0491", "%D2%91");
        dict.put("\u0406", "%D0%86");
        dict.put("\u0456", "%D1%96");
        dict.put("\u040e", "%D0%8E");
        dict.put("\u045e", "%D1%9E");
        dict.put("\u00d1", "%C3%91");
        dict.put("\u00f1", "%C3%B1");
        dict.put("\u0407", "%D0%87");
        dict.put("\u0457", "%D1%97");
    }

    public static String encode(String src) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < src.length()) {
            char ch = src.charAt(i);
            Object r = dict.get(String.valueOf(ch));
            if (r == null) {
                stringBuffer.append(ch);
            } else {
                String replacement = String.valueOf(r);
                stringBuffer.append(replacement);
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        if (enc.length() == 0) {
            throw new UnsupportedEncodingException("URLDecoder: empty string enc parameter");
        }
        byte[] bytes = null;
        while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    break;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, enc));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    break;
                }
                default: {
                    sb.append(c);
                    ++i;
                }
            }
        }
        return needToChange ? sb.toString() : s;
    }
}

