/*
 * Decompiled with CFR 0.152.
 */
package njtai.models;

import javax.microedition.lcdui.Canvas;
import njtai.Imgs;
import njtai.NJTAI;
import njtai.StringUtil;
import njtai.models.MangaObj;

public class ExtMangaObj
extends MangaObj
implements Runnable {
    public String tags;
    public int pages;
    public String[] imgs;
    private Thread urlFetcher = null;
    public int infoReady = -2;
    private boolean prefetched = false;

    public ExtMangaObj(int num, String html) throws NumberFormatException {
        this.num = num;
        String pagesStr = StringUtil.range(StringUtil.range(html, "Pages:", "</div", false), "<span class=\"name\">", "</span", false);
        System.out.println(pagesStr);
        this.pages = Integer.parseInt(pagesStr);
        this.imgs = new String[this.pages];
        this.imgUrl = StringUtil.range(html, "<noscript><img src=\"", "\"", false);
        this.title = StringUtil.range(StringUtil.range(html, "<h1 class=\"title\">", "</h1", false), "<span class=\"pretty\">", "</span", false);
        try {
            this.tags = ExtMangaObj.listTags(StringUtil.splitRanges(StringUtil.range(html, "Tags:", "</div", true), "<span class=\"name\">", "</span", false));
        }
        catch (Exception e) {
            this.tags = "(error)";
        }
        System.gc();
    }

    public byte[] getPage(int i) throws InterruptedException {
        if (this.imgs == null) {
            this.imgs = new String[this.pages];
        }
        if (this.imgs[i] == null) {
            this.loadUrl(i + 1);
            if (NJTAI.preloadUrl && NJTAI.cachingPolicy != 2) {
                if (!this.prefetched) {
                    Thread.sleep(100L);
                    this.prefetched = true;
                    this.urlFetcher = new Thread(this);
                    this.urlFetcher.setPriority(10);
                    this.urlFetcher.start();
                    Thread.sleep(500L);
                }
            } else {
                this.infoReady = 100;
            }
        }
        return Imgs.getImg(this.imgs[i]);
    }

    private void loadUrls() throws InterruptedException {
        try {
            int i = 1;
            while (i <= this.pages) {
                this.loadUrl(i);
                this.infoReady = i * 100 / this.pages;
                if (NJTAI.getScr() instanceof Canvas) {
                    ((Canvas)NJTAI.getScr()).repaint();
                }
                Thread.sleep(10L);
                ++i;
            }
        }
        catch (Exception e) {
            this.infoReady = -1;
        }
    }

    public void run() {
        try {
            this.loadUrls();
            this.urlFetcher = null;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void cancelPrefetch() {
        if (this.urlFetcher != null && this.urlFetcher.isAlive()) {
            this.urlFetcher.interrupt();
            this.urlFetcher = null;
        }
    }

    public synchronized String loadUrl(int pageN) {
        if (this.imgs == null) {
            this.imgs = new String[this.pages];
        }
        if (this.imgs[pageN - 1] != null) {
            return this.imgs[pageN - 1];
        }
        try {
            String url;
            String html = NJTAI.httpUtf(String.valueOf(NJTAI.proxy) + NJTAI.baseUrl + "/g/" + this.num + "/" + pageN);
            String span = StringUtil.range(html, "<section id=\"image-container", "</section", false);
            html = null;
            System.gc();
            this.imgs[pageN - 1] = url = StringUtil.range(span, "<img src=\"", "\"", false);
            return url;
        }
        catch (OutOfMemoryError e) {
            this.imgs = null;
            System.gc();
            this.imgs = new String[this.pages];
            return null;
        }
    }

    public static String listTags(String[] list) {
        if (list == null) {
            return "Error while getting tags.";
        }
        if (list.length == 0) {
            return "No tags.";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(list[0]);
        int i = 1;
        while (i < list.length) {
            sb.append(", ");
            sb.append(list[i]);
            ++i;
        }
        return sb.toString();
    }
}

