/*
 * Decompiled with CFR 0.152.
 */
package njtai.ui;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import njtai.MangaDownloader;
import njtai.NJTAI;
import njtai.models.ExtMangaObj;
import njtai.ui.MMenu;
import njtai.ui.ViewBase;

final class MangaPage
extends Form
implements Runnable,
CommandListener,
ItemCommandListener {
    private int id;
    private ExtMangaObj mo;
    private Thread l;
    private Displayable p;
    private Command back = new Command(NJTAI.rus ? "\u041d\u0430\u0437\u0430\u0434" : "Back", 2, 1);
    private Item page1 = new StringItem(null, NJTAI.rus ? "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0435\u0440\u0432\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443" : "Open first page", 2);
    private Item pageN = new StringItem(null, NJTAI.rus ? "\u0412\u0432\u0435\u0441\u0442\u0438 \u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b" : "Enter page number", 2);
    private Item save = new StringItem(null, NJTAI.rus ? "\u0421\u043a\u0430\u0447\u0430\u0442\u044c" : "Download", 2);
    public static Command open = new Command(NJTAI.rus ? "\u0412\u044b\u0431\u0440\u0430\u0442\u044c" : "Select", 8, 1);
    private Command goTo = new Command("Go", 4, 1);
    boolean stop = false;
    private StringItem prgrs = new StringItem(NJTAI.rus ? "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445" : "Loading data", "");

    public MangaPage(int num, Displayable prev) {
        super("Manga page");
        this.id = num;
        this.p = prev;
        this.setCommandListener(this);
        this.addCommand(this.back);
        this.append((Item)this.prgrs);
        this.setCommandListener(this);
        this.l = new Thread(this);
        this.l.setPriority(10);
        this.l.start();
    }

    public void run() {
        try {
            this.loadPage();
        }
        catch (OutOfMemoryError e) {
            System.gc();
            this.deleteAll();
            this.append((Item)this.prgrs);
            this.status("Not enough memory to load!");
        }
    }

    private void loadPage() {
        this.status(NJTAI.rus ? "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (1/3)" : "Fetching page (1/3)");
        String html = NJTAI.httpUtf(String.valueOf(NJTAI.proxy) + NJTAI.baseUrl + "/g/" + this.id);
        if (html == null) {
            this.status("Network error! Check connection, return to previous screen and try again.");
            return;
        }
        this.status(NJTAI.rus ? "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u044b\u0445 (2/3)" : "Processing data (2/3)");
        if (this.stop) {
            return;
        }
        this.mo = new ExtMangaObj(this.id, html);
        this.status(NJTAI.rus ? "\u0421\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u043b\u043e\u0436\u043a\u0438 (3/3)" : "Downloading cover (3/3)");
        if (this.stop) {
            return;
        }
        if (NJTAI.loadCoverAtPage) {
            this.mo.loadCover();
        }
        if (this.stop) {
            return;
        }
        this.deleteAll();
        this.append((Item)new ImageItem(this.mo.img == null ? (NJTAI.rus ? "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043e\u0431\u043b\u043e\u0436\u043a\u0438 \u0431\u044b\u043b\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430." : "Cover loading was disabled.") : null, this.mo.img, 0, null));
        this.setTitle(this.mo.title);
        this.append((Item)new StringItem(NJTAI.rus ? "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435" : "Title", this.mo.title));
        this.append((Item)new StringItem("ID", "#" + this.id));
        this.append((Item)new StringItem(NJTAI.rus ? "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u044b" : "Pages", "" + this.mo.pages));
        this.append((Item)new StringItem(NJTAI.rus ? "\u0422\u044d\u0433\u0438" : "Tags", this.mo.tags));
        this.page1.setItemCommandListener((ItemCommandListener)this);
        this.page1.setDefaultCommand(open);
        this.append(this.page1);
        this.pageN.setItemCommandListener((ItemCommandListener)this);
        this.pageN.setDefaultCommand(open);
        this.append(this.pageN);
        this.save.setItemCommandListener((ItemCommandListener)this);
        this.save.setDefaultCommand(open);
        this.append(this.save);
    }

    private void status(String string) {
        this.prgrs.setText(string);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.back) {
            this.stop = true;
            NJTAI.setScr((Displayable)(this.p == null ? new MMenu() : this.p));
        }
    }

    public void commandAction(Command c, Item i) {
        if (c == open) {
            if (i == this.page1) {
                NJTAI.setScr((Displayable)ViewBase.create(this.mo, (Displayable)this, 0));
            } else if (i == this.pageN) {
                TextBox tb = new TextBox(NJTAI.rus ? "\u041d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b:" : "Enter page number:", "", 7, 2);
                tb.addCommand(this.goTo);
                tb.addCommand(this.back);
                MangaPage menu = this;
                tb.setCommandListener(new CommandListener((Displayable)menu, tb){
                    private final /* synthetic */ Displayable val$menu;
                    private final /* synthetic */ TextBox val$tb;
                    {
                        this.val$menu = displayable;
                        this.val$tb = textBox;
                    }

                    public void commandAction(Command c, Displayable d) {
                        if (c == MangaPage.this.back) {
                            NJTAI.setScr(this.val$menu);
                        } else if (c == MangaPage.this.goTo) {
                            try {
                                int n = Integer.parseInt(this.val$tb.getString());
                                if (n < 1) {
                                    n = 1;
                                }
                                if (n > ((MangaPage)MangaPage.this).mo.pages) {
                                    n = ((MangaPage)MangaPage.this).mo.pages;
                                }
                                NJTAI.setScr((Displayable)ViewBase.create(MangaPage.this.mo, this.val$menu, n - 1));
                            }
                            catch (Exception e) {
                                NJTAI.setScr(this.val$menu);
                                NJTAI.pause(100);
                                NJTAI.setScr((Displayable)new Alert("Failed to go to page", "Have you entered correct number?", null, AlertType.ERROR));
                            }
                        }
                    }
                });
                NJTAI.setScr((Displayable)tb);
            } else if (i == this.save) {
                new MangaDownloader(this.mo, (Displayable)this).start();
            }
        }
    }
}

