/*
 * Decompiled with CFR 0.152.
 */
package njtai.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import njtai.MangaDownloader;
import njtai.NJTAI;
import njtai.models.ExtMangaObj;
import njtai.ui.ViewHWA;
import njtai.ui.ViewSWR;

public abstract class ViewBase
extends Canvas
implements Runnable {
    protected ExtMangaObj emo;
    protected Displayable prev;
    protected int page;
    protected ByteArrayOutputStream[] cache;
    protected MangaDownloader fs;
    protected int zoom = 1;
    protected int x = 0;
    protected int y = 0;
    protected Thread loader;
    protected Thread preloader;
    protected boolean error;
    int nokiaRam;
    int preloadProgress = 101;
    String[] touchCaps = new String[]{"x1", "x2", "x3", "<-", "->", NJTAI.rus ? "\u0437\u0430\u043a\u0440\u044b\u0442\u044c" : "close"};
    boolean touchCtrlShown = true;
    int touchHoldPos = 0;
    int lx;
    int ly;
    int sx;
    int sy;

    public ViewBase(ExtMangaObj emo, Displayable prev, int page) {
        this.emo = emo;
        this.prev = prev;
        this.page = page;
        this.nokiaRam = System.getProperty("microedition.platform").indexOf("sw_platform_version=5.") == -1 ? 0xF00000 : 0x2800000;
        NJTAI.clearHP();
        if (NJTAI.files) {
            this.fs = new MangaDownloader(emo, (Displayable)this);
        }
        this.reload();
        this.setFullScreenMode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteArrayOutputStream getImage(int n) throws InterruptedException {
        if (NJTAI.files) {
            ByteArrayOutputStream a = this.fs.read(n);
            if (a != null) {
                return a;
            }
            byte[] b = this.emo.getPage(n);
            try {
                a = new ByteArrayOutputStream(b.length);
                a.write(b);
                this.fs.cache(a, n);
                return a;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.cache == null) {
            this.cache = new ByteArrayOutputStream[this.emo.pages];
        }
        if (this.cache[n] != null) {
            return this.cache[n];
        }
        ByteArrayOutputStream[] byteArrayOutputStreamArray = this.cache;
        synchronized (this.cache) {
            byte[] b = this.emo.getPage(n);
            try {
                ByteArrayOutputStream s = new ByteArrayOutputStream(b.length);
                s.write(b);
                this.cache[n] = s;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return s;
            }
            catch (IOException e) {
                e.printStackTrace();
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return null;
            }
        }
    }

    protected synchronized void emergencyCacheClear() {
        if (NJTAI.files) {
            this.cache = null;
            return;
        }
        int i = 0;
        while (i < this.page - 1) {
            this.cache[i] = null;
            ++i;
        }
        i = this.emo.pages - 1;
        while (i > this.page) {
            if (this.cache[i] != null) {
                this.cache[i] = null;
                break;
            }
            --i;
        }
    }

    protected int canStorePages() {
        if (NJTAI.files) {
            return 999;
        }
        int f = (int)Runtime.getRuntime().freeMemory();
        int free = 0;
        try {
            String nokiaMem = System.getProperty("com.nokia.memoryramfree");
            free = (int)Math.min((long)Integer.parseInt(nokiaMem), (long)this.nokiaRam - (Runtime.getRuntime().totalMemory() - (long)f));
        }
        catch (Throwable t) {
            free = f;
        }
        int p = (free -= 0xA00000) / 307200;
        if (p < 0) {
            p = 0;
        }
        return p;
    }

    protected synchronized void checkCacheAfterPageSwitch() {
        if (NJTAI.files) {
            this.cache = null;
            return;
        }
        if (NJTAI.cachingPolicy == 0) {
            int i = 0;
            while (i < this.cache.length) {
                if (i != this.page) {
                    this.cache[i] = null;
                }
                ++i;
            }
        } else if (this.canStorePages() <= 2) {
            int i = 0;
            while (i < this.page - 1) {
                if (this.canStorePages() <= 2) {
                    this.cache[i] = null;
                }
                ++i;
            }
            i = this.emo.pages - 1;
            while (i > this.page) {
                if (this.canStorePages() == 0) {
                    this.cache[i] = null;
                    --i;
                    continue;
                }
                break;
            }
        } else if (NJTAI.cachingPolicy == 2) {
            this.runPreloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ViewBase viewBase = this;
            synchronized (viewBase) {
                this.error = false;
                this.zoom = 1;
                this.x = 0;
                this.y = 0;
                this.reset();
                try {
                    this.prepare(this.getImage(this.page));
                    this.repaint();
                    this.resize(1);
                    this.zoom = 1;
                }
                catch (InterruptedException e) {
                    this.error = true;
                    e.printStackTrace();
                }
                this.repaint();
                this.runPreloader();
            }
        }
        catch (OutOfMemoryError e) {
            this.cache = null;
            NJTAI.setScr(this.prev);
            NJTAI.pause(100);
            NJTAI.setScr((Displayable)new Alert("Error", "Not enough memory to continue viewing. Try to disable caching.", null, AlertType.ERROR));
            return;
        }
    }

    private void runPreloader() {
        if (this.preloader == null && NJTAI.cachingPolicy == 2) {
            this.preloader = new Thread(){

                public void run() {
                    try {
                        ViewBase.this.preload();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.preloader.start();
        }
    }

    void preload() throws InterruptedException {
        Thread.sleep(1000L);
        if (NJTAI.files) {
            int i = 0;
            while (i < this.emo.pages) {
                try {
                    this.getImage(i);
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.preloadProgress = 103;
                    this.repaint();
                    return;
                }
                catch (OutOfMemoryError e) {
                    this.preloadProgress = 104;
                    this.repaint();
                    return;
                }
                ++i;
            }
            this.preloadProgress = 100;
            return;
        }
        int i = this.page;
        while (i < this.emo.pages) {
            if (this.cache[i] == null) {
                try {
                    if (this.canStorePages() < 1) {
                        this.preloadProgress = 102;
                        this.preloader = null;
                        return;
                    }
                    this.getImage(i);
                    if (this.preloadProgress != 100) {
                        this.preloadProgress = i * 100 / this.emo.pages;
                    }
                    this.repaint();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.preloadProgress = 103;
                    this.repaint();
                    this.preloader = null;
                    return;
                }
                catch (OutOfMemoryError e) {
                    this.emergencyCacheClear();
                    this.preloadProgress = 104;
                    this.preloader = null;
                    this.repaint();
                    return;
                }
            }
            ++i;
        }
        this.preloadProgress = 100;
        this.preloader = null;
        this.repaint();
    }

    protected abstract void limitOffset();

    protected abstract void reset();

    protected abstract void prepare(ByteArrayOutputStream var1) throws InterruptedException;

    protected abstract void resize(int var1);

    protected abstract void reload();

    public abstract boolean canDraw();

    protected void keyPressed(int k) {
        if (k == -7) {
            this.cache = null;
            this.emo.cancelPrefetch();
            if (this.loader != null && this.loader.isAlive()) {
                this.loader.interrupt();
            }
            if (this.preloader != null && this.preloader.isAlive()) {
                this.preloader.interrupt();
            }
            NJTAI.setScr(this.prev);
            return;
        }
        if (!this.canDraw()) {
            this.repaint();
            return;
        }
        if (this.zoom != 1) {
            if (k == -5) {
                ++this.zoom;
                if (this.zoom > 3) {
                    this.zoom = 1;
                }
                this.resize(this.zoom);
            } else if (k == -1) {
                this.y += this.getHeight() / 4;
            } else if (k == -2) {
                this.y -= this.getHeight() / 4;
            } else if (k == -3) {
                this.x += this.getWidth() / 4;
            } else if (k == -4) {
                this.x -= this.getWidth() / 4;
            }
        } else if (k == -5) {
            this.zoom = 2;
            this.x = 0;
            this.y = 0;
            this.resize(this.zoom);
        } else if (k == -3) {
            this.changePage(-1);
        } else if (k == -4) {
            this.changePage(1);
        }
        this.repaint();
    }

    protected void keyRepeated(int k) {
        if (!this.canDraw()) {
            this.repaint();
            return;
        }
        if (this.zoom != 1) {
            if (k == -1) {
                this.y += this.getHeight() / 4;
            } else if (k == -2) {
                this.y -= this.getHeight() / 4;
            } else if (k == -3) {
                this.x += this.getWidth() / 4;
            } else if (k == -4) {
                this.x -= this.getWidth() / 4;
            }
        }
        this.repaint();
    }

    protected void changePage(int delta) {
        if (delta < 0) {
            if (this.page > 0) {
                --this.page;
                this.checkCacheAfterPageSwitch();
                this.reload();
            }
        } else if (delta > 0 && this.page < this.emo.pages - 1) {
            ++this.page;
            this.checkCacheAfterPageSwitch();
            this.reload();
        }
    }

    protected void pointerPressed(int x, int y) {
        if (!this.canDraw() && y > this.getHeight() - 50 && x > this.getWidth() * 2 / 3) {
            this.keyPressed(-7);
            return;
        }
        this.touchHoldPos = 0;
        this.lx = this.sx = x;
        this.ly = this.sy = y;
        if (!this.touchCtrlShown) {
            return;
        }
        if (y < 50 || y > this.getHeight() - 50) {
            int add;
            int n = add = y < 50 ? 1 : 4;
            int b = x < this.getWidth() / 3 ? 0 : (x < this.getWidth() * 2 / 3 ? 1 : 2);
            this.touchHoldPos = b + add;
        }
        this.repaint();
    }

    protected void pointerDragged(int tx, int ty) {
        if (this.touchHoldPos != 0) {
            return;
        }
        this.x += tx - this.lx;
        this.y += ty - this.ly;
        this.lx = tx;
        this.ly = ty;
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        if (!(this.touchCtrlShown && this.touchHoldPos != 0 || Math.abs(this.sx - x) >= 10 || Math.abs(this.sy - y) >= 10)) {
            this.touchCtrlShown = !this.touchCtrlShown;
        }
        int zone = 0;
        if (y < 50 || y > this.getHeight() - 50) {
            int add;
            int n = add = y < 50 ? 1 : 4;
            int b = x < this.getWidth() / 3 ? 0 : (x < this.getWidth() * 2 / 3 ? 1 : 2);
            zone = b + add;
        }
        if (zone == this.touchHoldPos) {
            if (zone >= 1 && zone <= 3) {
                this.zoom = zone;
                this.resize(this.zoom);
            } else if (zone == 4) {
                this.changePage(-1);
            } else if (zone == 5) {
                this.changePage(1);
            } else if (zone == 6) {
                this.keyPressed(-7);
            }
        }
        this.repaint();
    }

    public static void fillGrad(Graphics g, int x, int y, int w, int h, int c1, int c2) {
        int i = 0;
        while (i < h) {
            g.setColor(NJTAI.blend(c2, c1, i * 255 / h));
            g.drawLine(x, y + i, x + w, y + i);
            ++i;
        }
    }

    public static ViewBase create(ExtMangaObj mo, Displayable d, int i) {
        if (NJTAI.view == 1) {
            return new ViewSWR(mo, d, i);
        }
        if (NJTAI.view == 2) {
            return new ViewHWA(mo, d, i);
        }
        if (System.getProperty("microedition.platform").indexOf("sw_platform_version=5.") != -1) {
            return new ViewHWA(mo, d, i);
        }
        return new ViewSWR(mo, d, i);
    }
}

