/*
 * Decompiled with CFR 0.152.
 */
package njtai.ui;

import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import njtai.NJTAI;
import njtai.models.ExtMangaObj;
import njtai.ui.View;

public class ViewHWA
extends View {
    protected Material _material = new Material();
    protected CompositingMode _compositing;
    protected PolygonMode _polMode;
    PagePart[] p = null;
    int iw;
    int ih;

    public ViewHWA(ExtMangaObj emo, Displayable prev, int page) {
        super(emo, prev, page);
        this._material.setColor(2048, -1);
        this._material.setColor(8192, -1);
        this._material.setShininess(128.0f);
        this._material.setVertexColorTrackingEnable(true);
        this._compositing = new CompositingMode();
        this._compositing.setAlphaThreshold(0.0f);
        this._compositing.setBlending(64);
        this._polMode = new PolygonMode();
        this._polMode.setWinding(169);
        this._polMode.setCulling(162);
        this._polMode.setShading(165);
    }

    protected void reset() {
        this.p = null;
    }

    protected void prepare(ByteArrayOutputStream data) throws InterruptedException {
        this.reset();
        byte[] d = data.toByteArray();
        Image i = Image.createImage((byte[])d, (int)0, (int)d.length);
        d = null;
        this.ih = i.getHeight();
        this.iw = i.getWidth();
        Vector<PagePart> v = new Vector<PagePart>();
        int s = 512;
        int x = 0;
        while (x < i.getWidth() + s - 1) {
            int y = 0;
            while (y < i.getHeight() + s - 1) {
                v.addElement(new PagePart(i, x, y, (short)s));
                ++y;
            }
            ++x;
        }
        Object[] tmp = new PagePart[v.size()];
        v.copyInto(tmp);
        v = null;
        this.p = tmp;
        this.x = this.iw / 2;
        this.y = this.ih / 2;
    }

    protected void resize(int size) {
    }

    protected void reload() {
        this.reset();
        System.gc();
        this.loader = new Thread(this);
        this.loader.start();
    }

    public boolean canDraw() {
        return this.p != null;
    }

    protected void paint(Graphics g) {
        try {
            Font f = Font.getFont((int)0, (int)0, (int)8);
            g.setFont(f);
            if (this.p == null) {
                g.setGrayScale(0);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintNullImg(g, f);
                g.setColor(0, 0, 255);
                g.fillRect(0, 0, this.getWidth(), 4);
                g.drawString(String.valueOf(this.iw) + "x" + this.ih, this.getWidth() / 2, 4, 17);
            } else {
                this.limitOffset();
                Graphics3D g3 = Graphics3D.getInstance();
                g3.bindTarget((Object)g);
                Background b = new Background();
                b.setColorClearEnable(true);
                b.setDepthClearEnable(true);
                g3.clear(b);
                this.setupM3G(g3);
                int i = 0;
                while (i < this.p.length) {
                    this.p[i].paint(g3);
                    ++i;
                }
                g3.releaseTarget();
                if (this.hasPointerEvents() && this.touchCtrlShown) {
                    this.drawTouchControls(g, f);
                }
            }
            this.paintHUD(g, f);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                NJTAI.setScr((Displayable)new Alert("Repaint error", e.toString(), null, AlertType.ERROR));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void limitOffset() {
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.x > this.iw) {
            this.x = this.iw;
        }
        if (this.y < 0) {
            this.y = 0;
        }
        if (this.y > this.ih) {
            this.y = this.ih;
        }
    }

    protected void setupM3G(Graphics3D g3d) {
        Camera cam = new Camera();
        cam.setParallel((float)(this.ih / this.zoom), (float)this.getWidth() / (float)this.getHeight(), 0.1f, 900.0f);
        Transform t = new Transform();
        t.postTranslate((float)this.x, (float)this.y, 100.0f);
        Light l = new Light();
        l.setColor(0xFFFFFF);
        l.setIntensity(1.0f);
        l.setMode(128);
        g3d.setCamera(cam, t);
        g3d.resetLights();
        g3d.addLight(l, t);
    }

    class PagePart {
        int size;
        Appearance ap;
        Transform t;
        VertexBuffer vb;
        IndexBuffer ind;

        public PagePart(Image page, int x, int y, short s) {
            Image part = Image.createImage((int)s, (int)s);
            Graphics pg = part.getGraphics();
            pg.setColor(0);
            pg.fillRect(0, 0, (int)s, (int)s);
            pg.drawImage(page, -x, -y, 0);
            Image spart = Image.createImage((Image)part);
            part = null;
            Image2D image2D = new Image2D(99, (Object)spart);
            Texture2D tex = new Texture2D(image2D);
            tex.setFiltering(209, 209);
            tex.setWrapping(240, 240);
            tex.setBlending(227);
            this.ap = new Appearance();
            this.ap.setTexture(0, tex);
            this.ap.setMaterial(ViewHWA.this._material);
            this.ap.setCompositingMode(ViewHWA.this._compositing);
            this.ap.setPolygonMode(ViewHWA.this._polMode);
            this.t = new Transform();
            this.t.postTranslate((float)x, (float)y, 0.0f);
            short[] sArray = new short[12];
            sArray[0] = s;
            sArray[6] = s;
            sArray[7] = s;
            sArray[10] = s;
            short[] vert = sArray;
            short[] sArray2 = new short[8];
            sArray2[0] = 1;
            sArray2[4] = 1;
            sArray2[5] = 1;
            sArray2[7] = 1;
            short[] uv = sArray2;
            VertexArray vertArray = new VertexArray(vert.length / 3, 3, 2);
            vertArray.set(0, vert.length / 3, vert);
            VertexArray texArray = new VertexArray(uv.length / 2, 2, 2);
            texArray.set(0, uv.length / 2, uv);
            VertexBuffer vb = new VertexBuffer();
            vb.setPositions(vertArray, 1.0f, null);
            vb.setTexCoords(0, texArray, 1.0f, null);
            vb.setDefaultColor(-1);
        }

        public void paint(Graphics3D g) {
            g.render(this.vb, this.ind, this.ap, this.t);
        }
    }
}

