/*
 * Decompiled with CFR 0.152.
 */
package njtai.ui;

import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import njtai.NJTAI;
import njtai.models.ExtMangaObj;
import njtai.ui.View;

public class ViewSWR
extends View {
    Image toDraw;
    Image orig;

    public ViewSWR(ExtMangaObj emo, Displayable prev, int page) {
        super(emo, prev, page);
    }

    protected void resize(int size) {
        try {
            Image origImg;
            this.toDraw = null;
            System.gc();
            this.repaint();
            if (NJTAI.keepBitmap) {
                origImg = this.orig;
            } else {
                byte[] b = this.getImage(this.page).toByteArray();
                origImg = Image.createImage((byte[])b, (int)0, (int)b.length);
                b = null;
                System.gc();
            }
            int h = this.getHeight();
            int w = (int)((float)h / (float)origImg.getHeight() * (float)origImg.getWidth());
            if (w > this.getWidth()) {
                w = this.getWidth();
                h = (int)((float)w / (float)origImg.getWidth() * (float)origImg.getHeight());
            }
            this.toDraw = NJTAI.resize(origImg, w *= size, h *= size);
        }
        catch (Throwable e) {
            this.error = true;
        }
    }

    protected void paint(Graphics g) {
        try {
            Font f = Font.getFont((int)0, (int)0, (int)8);
            g.setFont(f);
            g.setGrayScale(0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.toDraw == null) {
                this.paintNullImg(g, f);
            } else {
                this.limitOffset();
                if (this.zoom != 1) {
                    g.drawImage(this.toDraw, this.x + this.getWidth() / 2, this.y + this.getHeight() / 2, 3);
                } else {
                    g.drawImage(this.toDraw, (this.getWidth() - this.toDraw.getWidth()) / 2, (this.getHeight() - this.toDraw.getHeight()) / 2, 0);
                }
                if (this.hasPointerEvents() && this.touchCtrlShown) {
                    this.drawTouchControls(g, f);
                }
            }
            this.paintHUD(g, f);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                NJTAI.setScr((Displayable)new Alert("Repaint error", e.toString(), null, AlertType.ERROR));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void limitOffset() {
        int hw = this.toDraw.getWidth() / 2;
        int hh = this.toDraw.getHeight() / 2;
        if (this.x < -hw) {
            this.x = -hw;
        }
        if (this.x > hw) {
            this.x = hw;
        }
        if (this.y < -hh) {
            this.y = -hh;
        }
        if (this.y > hh) {
            this.y = hh;
        }
    }

    protected void reload() {
        this.toDraw = null;
        System.gc();
        this.loader = new Thread(this);
        this.loader.start();
    }

    public boolean canDraw() {
        return this.toDraw != null;
    }

    protected void reset() {
        this.toDraw = null;
        this.orig = null;
    }

    protected void prepare(ByteArrayOutputStream d) throws InterruptedException {
        if (NJTAI.keepBitmap) {
            byte[] b = d.toByteArray();
            this.orig = Image.createImage((byte[])b, (int)0, (int)b.length);
            b = null;
            System.gc();
        }
    }
}

