#pragma ident "@(#)cgpbuildbuffer.h	1.8 98/08/25 SMI"

/*
 * Copyright (c) 1997 by Sun Microsystems, Inc.
 * All Rights Reserved
 */


/******************************************************************************
 *
 * cgpbuildbuffer.h
 *
 * All internal data structures and constants used by routines to build
 * the compressed geometry buffer.
 *
 *****************************************************************************/


#define CGP_COMPRESS_GEOM_BUFFER_SIZE	2000
#define CGP_COMPRESS_BUFFER_BIT_WIDTH   64

/* values for current state field */
#define CGP_STATE_CAP	    0x01
#define CGP_STATE_BCV	    0x02
#define CGP_STATE_BNV	    0x04
#define CGP_STATE_USE_MBR_N 0x08 /* flag to indicate that the current normal */
                                 /*  info needs to be updated from the mesh  */
#define CGP_STATE_USE_MBR_C 0x10 /* ditto for color */
#define CGP_STATE_PUSH      0x20 /* a mesh buffer push is occuring */


/*
 * compressed geometry instruction codes.  These codes are used to
 * build the 8 bit instruction header.
 */
#define CGP_VERTEX       0x40

/* note: reversed from paper to work around AFB problem  */
#define CGP_SET_NORMAL   0xC0
#define CGP_SET_COLOR    0x80 

#define CGP_MESH_B_R     0x20
#define CGP_SET_STATE    0x18
#define CGP_SET_TABLE    0x10
#define CGP_V_NO_OP      0x01


CGvoid cgpBuildCompressedBuffer(CGPcommandstream *, CGenum, CGboolean, 
                                CGboolean, CGboolean, CGviewport *,
                                CGubyte **, CGint *);
