/*
 * typedefs.h 
 *
 *	@(#)typedefs.h 1.9 96/07/04 14:59:13
 *
 * Copyright (c) 1996, Sun Microsystems Computer Company, Mountain View, CA
 *
 *			All Rights Reserved
 *
 *	This is a program for manipulating 3D objects.  It is currently being
 *	developed by Mike M. Chow under the directions of Scott R. Nelson. 
 *
 *      This module contains the type definitions.
 */

#ifndef _mviewer_typedefs_
#define _mviewer_typedefs_

typedef int VertIndex;  
typedef float Point[3]; /* a Point is [x y z] */
typedef double Matrix[16]; /* General 4x4 matrix */

/* Forward defs */
typedef struct Vertex Vertex;
typedef struct Edge Edge;
typedef struct Facet Facet;
typedef struct Part Part;
typedef struct PartList PartList;
typedef struct FacetList FacetList;
typedef struct EdgeList EdgeList;
typedef struct BBox BBox;
typedef struct ModelObject ModelObject;
typedef struct ModelTrans ModelTrans;
typedef struct TriStrip TriStrip;
typedef struct TriStrips TriStrips;
typedef struct LineStrips LineStrips;
typedef struct SurfaceProp SurfaceProp;
typedef struct Attrib Attrib;
typedef struct Stack Stack;
typedef struct Node Node;
typedef struct NodeList NodeList;
typedef struct CurveData CurveData;
typedef struct CurveDataNode CurveDataNode;
typedef struct TextureData TextureData;
typedef struct TextureMap  TextureMap;
typedef struct MeshRegion  MeshRegion;

#endif
