#ifndef _mviewer_libcommon_utils_
#define _mviewer_libcommon_utils_

/*
 * utils.h 
 *
 *	@(#)utils.h 1.9 96/10/10 
 *
 * Copyright (c) 1996, Sun Microsystems Computer Company, Mountain View, CA
 *
 *			All Rights Reserved
 *
 *	This is a program for manipulating 3D objects.  It is currently being
 *	developed by Mike M. Chow and Scott R. Nelson. 
 *
 *      This module contains useful utilities.
 */


typedef struct LinkedList LinkedList;

struct LinkedList {
  void *current;
  LinkedList *next;
};

float randNum (float low, float high);
char *genString(char *name);
char *strCut(char *word, int start, int end);
void spaces(FILE *fp, int n);
char *strAdd (char *str1, char *str2);

LinkedList *linkedListNewNode ();
void linkedListAddNode (LinkedList **list, void *nptr);

/*Don't check existence*/
void linkedListAddNodeFast (LinkedList **list, void *nptr); 

void linkedListRemoveNode (LinkedList **list, void *nptr);
void linkedListForEachNode (LinkedList *list,  
			    int (*f)(void *, void *), void *data);
void linkedListDestroy (LinkedList *list);
int linkedListFindNode (LinkedList *list,  
			void *node);

#endif
