/* Some debugging aids, in the spirit of X Consortium's ZDEBUG */
/* by Mike M. Chow (mchow@graphics.lcs.mit.edu) */
/* To use this file for debugging, simply include this file
   in your code and define a variable called zzdebug and set it 
   to 1:

int zzdebug = 1;
   
   Next, whenever you need to print debugging comments, use zdo:

zdo printf("testing");

   Once you are done with debugging, change zdo to zdo6:
	
zdo6 printf("testing");

*/

extern int zzdebug;

#define zprintf(format) \
	if (zzdebug) printf(format) 

#define zdo if (zzdebug)

#define zdo6 if (zzdebug >= 6)
#define zdo5 if (zzdebug >= 5)
#define zdo4 if (zzdebug >= 4)
#define zdo3 if (zzdebug >= 3)
#define zdo2 if (zzdebug >= 2)

#define zdebugOff(x) { zzdebug = 0; x zzdebug = 1; }
#define zdebugOn(x) { x }
#define zdebugAll(x) { zzdebug = 7; x zzdebug = 1; }
