/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.client.event;

import com.sun.scm.admin.client.event.ClientEventMC;
import com.sun.scm.admin.client.util.ClientUtilMC;
import com.sun.scm.admin.client.util.SCMApplet;
import com.sun.scm.admin.client.util.SCMTableModel;
import com.sun.scm.admin.client.util.SCMTreeNodeData;
import com.sun.scm.admin.server.eventq.SCMEventQueueI;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SCM_MC;
import com.sun.scm.admin.util.UtilMC;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Vector;

public class SCMEventTableModel
extends SCMTableModel {
    private static final String sccs_id = "@(#)SCMEventTableModel.java 1.7 99/02/05 SMI";
    private static final String MY_CLASSNAME = new String("SCMEventTableModel");
    private SCMEventQueueI event_queue;
    private SCMApplet applet;
    private String msg_str;

    public SCMEventTableModel(SCMApplet sCMApplet, SCMEventQueueI sCMEventQueueI, SCMTreeNodeData sCMTreeNodeData) {
        this.event_queue = sCMEventQueueI;
        this.applet = sCMApplet;
        this.updateTableData(sCMTreeNodeData);
    }

    public synchronized void initColumnNames() {
        this.columnNames = new String[7];
        this.columnNames[0] = new String(ClientEventMC.SEVERITY_LB);
        this.columnNames[1] = new String(ClientEventMC.DATE_LB);
        this.columnNames[2] = new String(ClientEventMC.TIME_LB);
        this.columnNames[3] = new String(ClientEventMC.DESC_LB);
        this.columnNames[4] = new String(ClientUtilMC.NAME_LB);
        this.columnNames[5] = new String(ClientEventMC.TYPE_LB);
        this.columnNames[6] = new String(ClientEventMC.STATE_LB);
        this.columnMinWidth = new int[7];
        this.columnMinWidth[0] = 60;
        this.columnMinWidth[1] = 80;
        this.columnMinWidth[2] = 80;
        this.columnMinWidth[3] = 400;
        this.columnMinWidth[4] = 120;
        this.columnMinWidth[5] = 120;
        this.columnMinWidth[6] = 180;
    }

    public synchronized void updateTableData(SCMTreeNodeData sCMTreeNodeData) {
        try {
            this.getTableData(sCMTreeNodeData);
            return;
        }
        catch (Exception exception) {
            this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "updateTableData", exception.getMessage());
            System.out.println(this.msg_str);
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void getTableData(SCMTreeNodeData sCMTreeNodeData) {
        this.rows = new Vector();
        Vector<String> vector = null;
        Vector vector2 = null;
        SCMEvent sCMEvent = null;
        try {
            vector2 = this.event_queue.getEventList(this.applet.getFilterMode(), sCMTreeNodeData.getTypeKey(), sCMTreeNodeData.getRsrcObject());
            if (vector2 == null) {
                return;
            }
            DateFormat dateFormat = DateFormat.getDateInstance();
            DateFormat dateFormat2 = DateFormat.getTimeInstance();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                sCMEvent = (SCMEvent)enumeration.nextElement();
                vector = new Vector<String>();
                vector.addElement(sCMEvent.severity.getLabel());
                vector.addElement(dateFormat.format(sCMEvent.date));
                vector.addElement(dateFormat2.format(sCMEvent.date));
                vector.addElement(sCMEvent.description);
                if (sCMEvent.object_external_name != null) {
                    vector.addElement(sCMEvent.object_external_name);
                } else {
                    vector.addElement("");
                }
                vector.addElement(sCMEvent.object_type.getLabel());
                if (sCMEvent.state_string != null) {
                    vector.addElement(sCMEvent.state_string);
                } else {
                    vector.addElement("");
                }
                this.rows.addElement(vector);
            }
            return;
        }
        catch (Exception exception) {
            this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "getTableData", exception.getMessage());
            System.out.println(this.msg_str);
            exception.printStackTrace();
            return;
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }
}

