/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.client.syslog;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.TitledBorder;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.DefaultTreeModel;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreeNode;
import com.sun.java.swing.tree.TreePath;
import com.sun.scm.admin.client.syslog.ClientSyslogMC;
import com.sun.scm.admin.client.syslog.SCMSyslogTreeNode;
import com.sun.scm.admin.client.util.ClientUtilMC;
import com.sun.scm.admin.client.util.SCMApplet;
import com.sun.scm.admin.client.util.SCMGenPanel;
import com.sun.scm.admin.client.util.SCMPage;
import com.sun.scm.admin.client.util.SCMSelectable;
import com.sun.scm.admin.client.util.SCMSplitFolder;
import com.sun.scm.admin.client.util.SCMTree;
import com.sun.scm.admin.client.util.SCMTreeCellRenderer;
import com.sun.scm.admin.client.util.SCMTreeModel;
import com.sun.scm.admin.client.util.SCMTreeMouseListener;
import com.sun.scm.admin.client.util.SCMTreeNode;
import com.sun.scm.admin.client.util.SCMTreeNodeData;
import com.sun.scm.admin.client.util.SCMUtil;
import com.sun.scm.admin.server.syslog.SCMSyslogAdminI;
import com.sun.scm.admin.server.syslog.SCMSyslogBufferI;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.EventObserverI;
import com.sun.scm.admin.util.OBJECT_STATE;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.REGISTRY_NAME;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SCM_MC;
import com.sun.scm.admin.util.UtilMC;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;

public class SCMSyslogPanel
extends JPanel
implements TreeSelectionListener,
ActionListener,
EventObserverI,
SCMSelectable,
Serializable {
    private static final String sccs_id = "@(#)SCMSyslogPanel.java 1.11 99/02/22 SMI";
    private static final String MY_CLASSNAME = new String("SCMSyslogPanel");
    private SCMApplet applet;
    private SCMPage page;
    private SCMTree tree;
    private JLabel hostNameLB;
    private JTextArea slMsgTA;
    private JButton prevBtn;
    private JButton nextBtn;
    private SCMSyslogAdminI syslogAdm;
    private SCMSyslogBufferI syslogBuf;
    private String hostName;
    private String msg_str;
    public static final String prevCommand = new String("Previous");
    public static final String nextCommand = new String("Next");
    public static final String currCommand = new String("Current");

    public SCMSyslogPanel(SCMPage sCMPage) {
        this.page = sCMPage;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Component)((Object)this)).setName("Syslog Panel");
        this.applet = (SCMApplet)((Object)sCMPage.getApplet());
        SCMSplitFolder sCMSplitFolder = new SCMSplitFolder();
        SCMResourceI sCMResourceI = this.applet.getCurrCluster();
        SCMTreeNodeData sCMTreeNodeData = new SCMTreeNodeData(sCMResourceI);
        SCMSyslogTreeNode sCMSyslogTreeNode = new SCMSyslogTreeNode(sCMTreeNodeData);
        SCMTreeModel sCMTreeModel = new SCMTreeModel((TreeNode)sCMSyslogTreeNode);
        this.tree = new SCMTree((TreeModel)sCMTreeModel, sCMSplitFolder);
        ((Component)((Object)this.tree)).setBackground(Color.white);
        this.tree.setCellRenderer(new SCMTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        SCMTreeMouseListener sCMTreeMouseListener = new SCMTreeMouseListener(this.tree);
        ((Component)((Object)this.tree)).addMouseListener(sCMTreeMouseListener);
        this.tree.expandRow(1);
        sCMSplitFolder.setIndexComponent((Component)((Object)this.tree));
        JPanel jPanel = this.createSyslogDisplay();
        sCMSplitFolder.setContextComponent((Component)jPanel);
        JPanel jPanel2 = new JPanel();
        this.prevBtn = new JButton(ClientSyslogMC.PREV_LB);
        this.prevBtn.setFont(SCMUtil.labelFont);
        this.prevBtn.setToolTipText(ClientSyslogMC.PREV_TT_LB);
        this.prevBtn.setActionCommand(prevCommand);
        this.prevBtn.addActionListener((ActionListener)this);
        this.nextBtn = new JButton(ClientSyslogMC.NEXT_LB);
        this.nextBtn.setFont(SCMUtil.labelFont);
        this.nextBtn.setToolTipText(ClientSyslogMC.NEXT_TT_LB);
        this.nextBtn.setActionCommand(nextCommand);
        this.nextBtn.addActionListener((ActionListener)this);
        jPanel2.add((Component)this.prevBtn);
        jPanel2.add((Component)this.nextBtn);
        ((Container)((Object)this)).add((Component)((Object)sCMSplitFolder), "Center");
        ((Container)((Object)this)).add((Component)jPanel2, "South");
        String string = null;
        try {
            String string2 = this.applet.getServerName();
            String string3 = this.applet.getServerPort();
            string = "rmi://" + string2 + ":" + string3 + "/" + REGISTRY_NAME.SYSLOG_NAME;
            Remote remote = Naming.lookup(string);
            if (!(remote instanceof SCMSyslogAdminI)) {
                this.msg_str = SCM_MC.CL_SYSLOG.formatMCMsg(ClientSyslogMC.SCMSyslogPanel_msg1, MY_CLASSNAME, MY_CLASSNAME);
                System.out.println(this.msg_str);
                return;
            }
            this.syslogAdm = (SCMSyslogAdminI)remote;
        }
        catch (Exception exception) {
            this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, MY_CLASSNAME, exception.getMessage());
            System.out.println(this.msg_str);
            exception.printStackTrace();
            return;
        }
        this.tree.setSelectionRow(2);
        this.applet.registerComponent(this);
    }

    public synchronized JPanel createSyslogDisplay() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.setBorder(SCMUtil.loweredBorder);
        SCMGenPanel sCMGenPanel = new SCMGenPanel(ClientSyslogMC.DNODE_TITLE);
        sCMGenPanel.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel((LayoutManager)new GridLayout(0, 2, 10, 5));
        JLabel jLabel = new JLabel(String.valueOf(ClientSyslogMC.DNODE_LB) + ":  ");
        this.hostNameLB = new JLabel("          ");
        jPanel2.add((Component)jLabel);
        jPanel2.add((Component)this.hostNameLB);
        sCMGenPanel.addInfo((Component)jPanel2);
        jPanel.add((Component)((Object)sCMGenPanel));
        JPanel jPanel3 = new JPanel();
        jPanel3.setName("SCM Syslog Messages Panel");
        jPanel3.setBorder(SCMUtil.emptyBorder10);
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder((String)ClientSyslogMC.SLMSG_TITLE);
        titledBorder.setTitleFont(SCMUtil.titleFont);
        titledBorder.setTitleColor(SCMUtil.titleColor);
        jPanel4.setBorder((Border)titledBorder);
        this.slMsgTA = new JTextArea(40, 80);
        this.slMsgTA.setBackground(Color.white);
        this.slMsgTA.setEditable(false);
        this.slMsgTA.setBorder(SCMUtil.loweredBorder);
        JScrollPane jScrollPane = new JScrollPane((Component)this.slMsgTA);
        jScrollPane.getViewport().setBackground(Color.white);
        jPanel4.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel3);
        return jPanel;
    }

    public synchronized void updateSyslog(String string) {
        SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)this.getSelection();
        SCMResourceI sCMResourceI = sCMTreeNodeData.getRsrcObject();
        String string2 = sCMTreeNodeData.getName();
        String string3 = sCMTreeNodeData.getTypeKey();
        String string4 = null;
        try {
            string4 = sCMResourceI.getName();
        }
        catch (Exception exception) {
            this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "updateSyslog", exception.getMessage());
            System.out.println(this.msg_str);
            exception.printStackTrace();
            return;
        }
        if (string3.compareTo(OBJECT_TYPE.CLUSTER.toString()) == 0 || sCMTreeNodeData.isResourceType()) {
            this.hostName = null;
            this.hostNameLB.setText("");
            this.slMsgTA.setText(null);
            this.prevBtn.setEnabled(false);
            this.nextBtn.setEnabled(false);
            this.updateUIDisplay();
            this.postNotCNodeDialog();
            return;
        }
        OBJECT_STATE oBJECT_STATE = sCMTreeNodeData.getCurrentState();
        if (!oBJECT_STATE.equalTo(OBJECT_STATE.ONLINE) && !oBJECT_STATE.equalTo(OBJECT_STATE.COMPONENT_DOWN)) {
            this.hostName = null;
            this.hostNameLB.setText("");
            this.slMsgTA.setText(null);
            this.prevBtn.setEnabled(false);
            this.nextBtn.setEnabled(false);
            this.updateUIDisplay();
            this.postCNodeDownDialog();
            return;
        }
        if (this.hostName == null || string4.compareTo(this.hostName) != 0) {
            try {
                this.syslogAdm.createSCMSyslogLoader(string4);
            }
            catch (Exception exception) {
                this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "updateSyslog", exception.getMessage());
                System.out.println(this.msg_str);
                exception.printStackTrace();
                return;
            }
            this.hostName = string4;
        }
        String string5 = null;
        boolean bl = true;
        try {
            this.syslogBuf = null;
            if (string.compareTo(currCommand) == 0) {
                this.syslogBuf = this.syslogAdm.lastBuffer();
            } else if (string.compareTo(nextCommand) == 0) {
                this.syslogBuf = this.syslogAdm.nextBuffer();
            } else if (string.compareTo(prevCommand) == 0) {
                this.syslogBuf = this.syslogAdm.previousBuffer();
            }
            if (this.syslogBuf != null) {
                string5 = this.syslogBuf.getText().toString();
            }
            bl = this.syslogAdm.moreData(string);
        }
        catch (Exception exception) {
            this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "updateSyslog", exception.getMessage());
            System.out.println(this.msg_str);
            exception.printStackTrace();
            return;
        }
        this.hostNameLB.setText(string2);
        this.slMsgTA.setText(string5);
        if (string.compareTo(currCommand) == 0) {
            this.nextBtn.setEnabled(false);
            this.prevBtn.setEnabled(true);
            this.updateUIDisplay();
            return;
        }
        if (string.compareTo(prevCommand) == 0) {
            this.nextBtn.setEnabled(true);
            if (bl) {
                this.prevBtn.setEnabled(false);
            } else {
                this.prevBtn.setEnabled(true);
            }
            this.updateUIDisplay();
            return;
        }
        if (string.compareTo(nextCommand) == 0) {
            this.prevBtn.setEnabled(true);
            if (bl) {
                this.nextBtn.setEnabled(false);
            } else {
                this.nextBtn.setEnabled(true);
            }
            this.updateUIDisplay();
            return;
        }
        this.prevBtn.setEnabled(true);
        this.nextBtn.setEnabled(true);
        this.updateUIDisplay();
    }

    public synchronized void updateUIDisplay() {
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
        ((Component)((Object)this)).repaint();
        this.page.updateUIDisplay();
    }

    public synchronized void postNotCNodeDialog() {
        if (this.page.getCurrentFolder() != this) {
            return;
        }
        JLabel jLabel = new JLabel(ClientSyslogMC.NOT_NODE_LB1);
        jLabel.setFont(SCMUtil.labelFont);
        JLabel jLabel2 = new JLabel(ClientSyslogMC.NOT_NODE_LB2);
        jLabel2.setFont(SCMUtil.labelFont);
        Object[] objectArray = new Object[]{jLabel, jLabel2};
        JOptionPane.showMessageDialog((Component)((Object)this.page), (Object)objectArray, (String)ClientUtilMC.INFO_DG_TITLE, (int)1);
    }

    public synchronized void postCNodeDownDialog() {
        if (this.page.getCurrentFolder() != this) {
            return;
        }
        JLabel jLabel = new JLabel(ClientSyslogMC.NODE_DOWN_LB1);
        jLabel.setFont(SCMUtil.labelFont);
        JLabel jLabel2 = new JLabel(ClientSyslogMC.NODE_DOWN_LB2);
        jLabel2.setFont(SCMUtil.labelFont);
        Object[] objectArray = new Object[]{jLabel, jLabel2};
        JOptionPane.showMessageDialog((Component)((Object)this.page), (Object)objectArray, (String)ClientUtilMC.INFO_DG_TITLE, (int)1);
    }

    public synchronized void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath == null) {
            return;
        }
        if (!treeSelectionEvent.isAddedPath(treePath)) {
            return;
        }
        this.updateSyslog(currCommand);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(nextCommand)) {
            this.updateSyslog(nextCommand);
            return;
        }
        if (string.equals(prevCommand)) {
            this.updateSyslog(prevCommand);
            return;
        }
        this.msg_str = SCM_MC.CL_SYSLOG.formatMCMsg(ClientSyslogMC.INVALID_CMD_msg, MY_CLASSNAME, "actionPerformed", string);
        System.out.println(this.msg_str);
    }

    public synchronized void receiveEvent(SCMEvent sCMEvent, SCMResourceI sCMResourceI) throws RemoteException {
        if (!sCMEvent.object_type.equalTo(OBJECT_TYPE.CNODE)) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            SCMSyslogTreeNode sCMSyslogTreeNode = (SCMSyslogTreeNode)((Object)defaultTreeModel.getRoot());
            SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)sCMSyslogTreeNode.getUserObject();
            SCMResourceI sCMResourceI2 = sCMTreeNodeData.getRsrcObject();
            OBJECT_STATE oBJECT_STATE = null;
            try {
                oBJECT_STATE = sCMResourceI2.getState();
            }
            catch (Exception exception) {
                this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "receiveEvent", exception.getMessage());
                System.out.println(this.msg_str);
                exception.printStackTrace();
                return;
            }
            if (!sCMTreeNodeData.getCurrentState().equalTo(oBJECT_STATE)) {
                sCMTreeNodeData.setCurrentState(oBJECT_STATE);
                SCMSyslogTreeNode sCMSyslogTreeNode2 = (SCMSyslogTreeNode)sCMSyslogTreeNode.getChildAt(0);
                defaultTreeModel.nodeChanged((TreeNode)sCMSyslogTreeNode2);
                this.updateUIDisplay();
            }
            return;
        }
        this.tree.receiveEvent(sCMEvent, sCMResourceI);
        SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)this.getSelection();
        SCMResourceI sCMResourceI3 = sCMTreeNodeData.getRsrcObject();
        String string = null;
        try {
            string = sCMResourceI3.getName();
        }
        catch (Exception exception) {
            this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "receiveEvent", exception.getMessage());
            System.out.println(this.msg_str);
            exception.printStackTrace();
            return;
        }
        if (sCMEvent.object_name.compareTo(string) != 0) {
            return;
        }
        OBJECT_STATE oBJECT_STATE = sCMTreeNodeData.getCurrentState();
        if (!oBJECT_STATE.equalTo(OBJECT_STATE.ONLINE) && !oBJECT_STATE.equalTo(OBJECT_STATE.COMPONENT_DOWN)) {
            this.hostName = null;
            this.hostNameLB.setText("");
            this.slMsgTA.setText(null);
            this.updateUIDisplay();
            return;
        }
        if (this.hostName == null) {
            this.updateSyslog(currCommand);
        }
    }

    public synchronized void setSelection(Object object) {
        SCMTreeNode sCMTreeNode;
        URL uRL = ((Applet)((Object)this.applet)).getDocumentBase();
        String string = uRL.getHost();
        int n = string.indexOf(".");
        String string2 = string;
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        TreePath treePath = this.tree.getPathForRow(1);
        SCMTreeNode sCMTreeNode2 = (SCMTreeNode)((Object)treePath.getLastPathComponent());
        JPanel jPanel = this.page.getPreviousFolder();
        if (jPanel == this.page.getPropertyPanel() || jPanel == this.page.getEventPanel()) {
            sCMTreeNode = (SCMTreeNode)((Object)((TreePath)object).getLastPathComponent());
            SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)sCMTreeNode.getUserObject();
            SCMResourceI sCMResourceI = sCMTreeNodeData.getRsrcObject();
            String string3 = sCMTreeNodeData.getTypeKey();
            if (string3.compareTo(OBJECT_TYPE.CNODE.toString()) == 0) {
                try {
                    string2 = sCMResourceI.getName();
                }
                catch (Exception exception) {
                    this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "setSelection", exception.getMessage());
                    System.out.println(this.msg_str);
                    exception.printStackTrace();
                    return;
                }
            }
        }
        if (this.hostName != null && string2.compareTo(this.hostName) == 0) {
            return;
        }
        if (string2.length() <= 0) {
            this.tree.setSelectionRow(2);
            return;
        }
        sCMTreeNode = sCMTreeNode2.lookupChildNode(string2);
        if (sCMTreeNode != null) {
            this.tree.setSelectionPath(new TreePath((Object[])sCMTreeNode.getPath()));
            return;
        }
        this.tree.setSelectionRow(2);
    }

    public synchronized Object getSelection() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        return defaultMutableTreeNode.getUserObject();
    }

    public String getClassVersion() {
        return sccs_id;
    }
}

