/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.client.util;

import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JApplet;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.UnsupportedLookAndFeelException;
import com.sun.scm.admin.client.util.ClientUtilMC;
import com.sun.scm.admin.client.util.SCMAlertDialog;
import com.sun.scm.admin.client.util.SCMImage;
import com.sun.scm.admin.client.util.SCMMenuBar;
import com.sun.scm.admin.client.util.SCMPage;
import com.sun.scm.admin.client.util.SCMServerMonitor;
import com.sun.scm.admin.client.util.SCMToolBar;
import com.sun.scm.admin.client.util.SCMTreeNodeData;
import com.sun.scm.admin.client.util.SCMUtil;
import com.sun.scm.admin.server.eventq.SCMEventQueueI;
import com.sun.scm.admin.server.scmgr.ClusterManagerI;
import com.sun.scm.admin.server.util.SCMRegistryI;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.EventFilterMode;
import com.sun.scm.admin.util.EventObserverI;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.REGISTRY_NAME;
import com.sun.scm.admin.util.SCMClientI;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SCMServerI;
import com.sun.scm.admin.util.SCM_MC;
import com.sun.scm.admin.util.SEVERITY;
import com.sun.scm.admin.util.UtilMC;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class SCMApplet
extends JApplet
implements EventObserverI,
SCMClientI,
Serializable {
    private static final String sccs_id = "@(#)SCMApplet.java 1.13 99/03/10 SMI";
    private static final String MY_CLASSNAME = new String("SCMApplet");
    private Container appletPane;
    private ImageIcon banner;
    private JLabel bannerLB;
    private JPanel bannerPanel;
    private SCMPage scmPage;
    private Applet thisApplet;
    private SCMAlertDialog alertDialog;
    private SCMRegistryI registry;
    private SCMResourceI currCluster;
    private SCMEventQueueI currEventQueue;
    private Thread monThread;
    private EventFilterMode filterMode = new EventFilterMode();
    private int selectedTab;
    private boolean audioAlertEnabled = true;
    private Vector comp_list = new Vector();
    private Hashtable comp_table = new Hashtable(20);
    private String str;

    public void init() {
        SCMServerMonitor sCMServerMonitor;
        Remote remote;
        System.gc();
        this.thisApplet = this;
        SCMImage.setApplet(this);
        String string = System.getProperty("java.version");
        if (string.compareTo("1.1.2") < 0) {
            this.str = SCM_MC.CL_UTIL.formatMCMsg(ClientUtilMC.SCMApplet_msg1, MY_CLASSNAME, "init");
            System.out.println(this.str);
            return;
        }
        try {
            PrivilegeManager.enablePrivilege((String)"UniversalAwtEventQueueAccess");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {}
        try {
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {}
        String string2 = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel((String)string2);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            this.str = SCM_MC.CL_UTIL.formatMCMsg(ClientUtilMC.SCMApplet_msg2, MY_CLASSNAME, "init", string2);
            System.err.println(this.str);
            unsupportedLookAndFeelException.printStackTrace();
        }
        catch (Exception exception) {
            this.str = SCM_MC.CL_UTIL.formatMCMsg(ClientUtilMC.SCMApplet_msg3, MY_CLASSNAME, "init", string2, exception);
            System.err.println(this.str);
            exception.printStackTrace();
        }
        try {
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {}
        try {
            UnicastRemoteObject.exportObject(this);
            String string3 = "rmi://" + this.getServerName() + ":" + this.getServerPort() + "/" + REGISTRY_NAME.CM_NAME;
            remote = Naming.lookup(string3);
            if (!(remote instanceof SCMRegistryI)) {
                this.str = SCM_MC.CL_UTIL.formatMCMsg(ClientUtilMC.SCMApplet_msg4, MY_CLASSNAME, "init");
                System.out.println(this.str);
                return;
            }
            this.registry = (SCMRegistryI)remote;
            sCMServerMonitor = new SCMServerMonitor(this, (SCMServerI)((Object)this.registry));
            this.monThread = new Thread(sCMServerMonitor);
            this.monThread.start();
        }
        catch (Exception exception) {
            this.postConnLostDialog();
            return;
        }
        this.appletPane = this.getContentPane();
        this.appletPane.setLayout(new BorderLayout());
        remote = new JPanel();
        ((Container)((Object)remote)).setLayout(new BorderLayout());
        this.bannerPanel = new JPanel();
        this.bannerPanel.setLayout(new BorderLayout());
        this.banner = SCMImage.SCM_HEADER.getImageIcon();
        this.bannerLB = new JLabel((Icon)this.banner);
        this.bannerPanel.add((Component)this.bannerLB, "Center");
        sCMServerMonitor = new JPanel((LayoutManager)new BorderLayout());
        ((Container)((Object)sCMServerMonitor)).add((Component)((Object)new SCMMenuBar(this)), "North");
        ((Container)((Object)sCMServerMonitor)).add((Component)((Object)new SCMToolBar(this)), "South");
        ((Container)((Object)remote)).add((Component)this.bannerPanel, "North");
        ((Container)((Object)remote)).add((Component)((Object)sCMServerMonitor), "South");
        this.appletPane.add((Component)((Object)remote), "North");
    }

    public void start() {
        super.start();
        if (this.registry == null) {
            if (this.scmPage != null) {
                this.postConnLostDialog();
                this.serverDown();
            }
            return;
        }
        if (this.scmPage == null) {
            this.createSCMPage();
            try {
                this.registry.registerClient(this);
                return;
            }
            catch (Exception exception) {
                this.str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "start", exception.getMessage());
                System.out.println(this.str);
                exception.printStackTrace();
                return;
            }
        }
        try {
            ((SCMServerI)((Object)this.registry)).isAlive();
        }
        catch (Exception exception) {
            this.postConnLostDialog();
            this.serverDown();
            return;
        }
        this.readyForDisplay();
    }

    public void stop() {
        System.gc();
        super.stop();
    }

    public void destroy() {
        Object object = this.registry;
        synchronized (object) {
            try {
                if (this.registry != null) {
                    this.registry.unregisterClient(this);
                }
            }
            catch (Exception exception) {
                Object var2_2 = null;
                return;
            }
        }
        object = this.monThread;
        synchronized (object) {
            if (this.monThread != null) {
                this.monThread.stop();
            }
        }
        super.destroy();
    }

    public synchronized boolean refresh() {
        if (this.registry == null) {
            return false;
        }
        SCMUtil.setBusy(true, (Component)((Object)this));
        this.unregisterAllComponents();
        try {
            this.registry.refresh();
        }
        catch (Exception exception) {
            return false;
        }
        this.selectedTab = this.scmPage.getSelectedTabIndex();
        ((Container)((Object)this.scmPage)).removeAll();
        this.appletPane.remove((Component)((Object)this.scmPage));
        this.scmPage = null;
        this.createSCMPage();
        System.gc();
        SCMUtil.setBusy(false, (Component)((Object)this));
        return true;
    }

    public synchronized void createSCMPage() {
        this.getCurrentObjHandles();
        this.scmPage = new SCMPage(this);
        this.appletPane.add((Component)((Object)this.scmPage), "Center");
        this.readyForDisplay();
    }

    public void readyForDisplay() {
        this.bannerPanel.invalidate();
        if (this.bannerPanel.getParent() != null) {
            this.bannerPanel.getParent().invalidate();
        }
        ((Container)((Object)this.scmPage)).invalidate();
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
        ((Component)((Object)this)).repaint();
        ((Component)((Object)this)).setVisible(true);
    }

    public synchronized void getCurrentObjHandles() {
        ClusterManagerI clusterManagerI = (ClusterManagerI)((Object)this.registry);
        try {
            this.currCluster = clusterManagerI.getCluster();
            this.currEventQueue = clusterManagerI.getEventQueue();
            return;
        }
        catch (Exception exception) {
            this.str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "getCurrentObjHandles", exception.getMessage());
            System.out.println(this.str);
            exception.printStackTrace();
            return;
        }
    }

    public void setFilterMode(int n, boolean bl) {
        this.filterMode.setMode(n, bl);
    }

    public void setEventSeverityLevel(SEVERITY sEVERITY) {
        this.filterMode.setSeverity(sEVERITY);
    }

    public void updateFilterMode(SCMTreeNodeData sCMTreeNodeData) {
        if (sCMTreeNodeData.isResourceType()) {
            this.setFilterMode(1, true);
            this.setFilterMode(2, false);
            return;
        }
        this.setFilterMode(1, false);
        String string = sCMTreeNodeData.getTypeKey();
        if (string.compareTo(OBJECT_TYPE.CLUSTER.toString()) == 0) {
            this.setFilterMode(2, false);
            return;
        }
        this.setFilterMode(2, true);
    }

    public synchronized void setAAlertEnabled(boolean bl) {
        this.audioAlertEnabled = bl;
        if (this.alertDialog != null && ((Window)((Object)this.alertDialog)).isShowing()) {
            this.alertDialog.activateAudioAlert(bl);
        }
    }

    public synchronized boolean isAAlertEnabled() {
        return this.audioAlertEnabled;
    }

    public void postAlertDialog() {
        SCMApplet sCMApplet = this;
        synchronized (sCMApplet) {
            if (!((Component)((Object)this)).isShowing()) {
                ((Component)((Object)this)).setVisible(true);
            }
            if (this.alertDialog == null) {
                this.alertDialog = new SCMAlertDialog(SCMUtil.findFrame((Component)((Object)this)), this);
                ((Window)((Object)this.alertDialog)).pack();
            }
            ((Dialog)((Object)this.alertDialog)).show();
            this.alertDialog.activateAudioAlert(this.audioAlertEnabled);
            return;
        }
    }

    public synchronized void postConnLostDialog() {
        JLabel jLabel = new JLabel(ClientUtilMC.CONNLOST_DG_LB1);
        jLabel.setFont(SCMUtil.labelFont);
        JLabel jLabel2 = new JLabel(ClientUtilMC.CONNLOST_DG_LB2);
        jLabel2.setFont(SCMUtil.labelFont);
        Object[] objectArray = new Object[]{jLabel, jLabel2};
        JOptionPane.showMessageDialog((Component)((Object)this), (Object)objectArray, (String)ClientUtilMC.WARNING_DG_TITLE, (int)0);
    }

    public Container getAppletPane() {
        return this.appletPane;
    }

    public Applet getThisApplet() {
        return this.thisApplet;
    }

    public synchronized SCMPage getSCMPage() {
        return this.scmPage;
    }

    public SCMRegistryI getRegistry() {
        return this.registry;
    }

    public SCMResourceI getCurrCluster() {
        return this.currCluster;
    }

    public SCMEventQueueI getCurrEventQueue() {
        return this.currEventQueue;
    }

    public EventFilterMode getFilterMode() {
        return this.filterMode;
    }

    public int getSelectedTab() {
        return this.selectedTab;
    }

    public synchronized void registerComponent(EventObserverI eventObserverI) {
        if (!this.comp_list.contains(eventObserverI)) {
            this.comp_list.addElement(eventObserverI);
        }
    }

    public synchronized void registerComponent(EventObserverI eventObserverI, SCMResourceI sCMResourceI) {
        String string;
        try {
            string = sCMResourceI.getType().toString();
        }
        catch (Exception exception) {
            this.str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "registerComponent", exception.getMessage());
            System.out.println(this.str);
            exception.printStackTrace();
            return;
        }
        this.registerComponent(eventObserverI, string);
    }

    public synchronized void registerComponent(EventObserverI eventObserverI, String string) {
        Vector<EventObserverI> vector = (Vector<EventObserverI>)this.comp_table.get(string);
        if (vector == null) {
            vector = new Vector<EventObserverI>();
            this.comp_table.put(string, vector);
        }
        if (!vector.contains(eventObserverI)) {
            vector.addElement(eventObserverI);
        }
    }

    public synchronized void unregisterComponent(EventObserverI eventObserverI, String string) {
        Vector vector = (Vector)this.comp_table.get(string);
        if (vector != null) {
            vector.removeElement(eventObserverI);
            if (vector.isEmpty()) {
                this.comp_table.remove(string);
            }
        }
    }

    public synchronized void unregisterComponent(EventObserverI eventObserverI) {
        this.comp_list.removeElement(eventObserverI);
        Enumeration enumeration = this.comp_table.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.comp_table.get(string);
            if (vector == null) {
                return;
            }
            vector.removeElement(eventObserverI);
            if (!vector.isEmpty()) continue;
            this.comp_table.remove(string);
        }
    }

    public synchronized void unregisterAllComponents() {
        this.comp_list.removeAllElements();
        this.comp_table.clear();
    }

    public void deliverEvent(Vector vector, SCMEvent sCMEvent, SCMResourceI sCMResourceI) throws RemoteException {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EventObserverI eventObserverI = (EventObserverI)enumeration.nextElement();
            try {
                eventObserverI.receiveEvent(sCMEvent, sCMResourceI);
            }
            catch (Exception exception) {
                this.str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "deliverEvent", exception.getMessage());
                System.out.println(this.str);
                exception.printStackTrace();
            }
        }
    }

    public void receiveEvent(SCMEvent sCMEvent, SCMResourceI sCMResourceI) throws RemoteException {
        try {
            Vector vector = this.comp_list;
            synchronized (vector) {
                if (!this.comp_list.isEmpty()) {
                    this.deliverEvent(this.comp_list, sCMEvent, sCMResourceI);
                }
            }
            vector = (Vector)this.comp_table.get(sCMEvent.object_type.toString());
            if (vector != null) {
                this.deliverEvent(vector, sCMEvent, sCMResourceI);
            }
        }
        catch (Exception exception) {
            this.str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "receiveEvent", exception.getMessage());
            System.out.println(this.str);
            exception.printStackTrace();
        }
        this.postAlertDialog();
    }

    public synchronized void serverDown() {
        if (this.alertDialog != null) {
            this.alertDialog.activateAudioAlert(false);
            ((Component)((Object)this.alertDialog)).setVisible(false);
        }
        if (this.scmPage != null) {
            ((Container)((Object)this.scmPage)).removeAll();
            this.appletPane.remove((Component)((Object)this.scmPage));
            ((Component)((Object)this)).setVisible(false);
        }
        this.registry = null;
        this.currCluster = null;
        this.currEventQueue = null;
        this.unregisterAllComponents();
        if (this.monThread != null) {
            this.monThread.stop();
            this.monThread = null;
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public String getServerName() {
        URL uRL = ((Applet)((Object)this)).getDocumentBase();
        return uRL.getHost();
    }

    public String getServerPort() {
        String string = ((Applet)((Object)this)).getParameter("registerPort");
        if (string == null) {
            return "1097";
        }
        return string;
    }

    public ImageIcon getImageIcon(String string, String string2) {
        URL uRL = null;
        try {
            uRL = new URL(((Applet)((Object)this)).getCodeBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = SCM_MC.CL_UTIL.formatMCMsg(ClientUtilMC.SCMContext_msg1, MY_CLASSNAME, "getImageIcon", string);
            System.err.println(string3);
        }
        return new ImageIcon(uRL, string2);
    }

    public void showPage(String string, String string2) throws MalformedURLException {
        ((Applet)((Object)this)).showStatus(string);
        URL uRL = new URL(((Applet)((Object)this)).getCodeBase(), string);
        ((Applet)((Object)this)).getAppletContext().showDocument(uRL, string2);
    }
}

