/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.event;

import com.sun.scm.admin.server.event.EventQueue;
import com.sun.scm.admin.server.util.SCMRegistry;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.EventObserverI;
import com.sun.scm.admin.util.REGISTRY_NAME;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SCMPropertyKey;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;

public class Connection
implements Serializable,
Runnable {
    private int nBroadcastEventCount;
    private EventQueue hEventQueue;
    private SCMResourceI hNode;
    private String sHost;
    private EventObserverI hEventObserver;
    private SCMRegistry hSCMRegistry;
    private int registryPort = 1097;

    public Connection(SCMResourceI sCMResourceI, SCMRegistry sCMRegistry) {
        this.hNode = sCMResourceI;
        this.hEventObserver = this.hEventObserver;
        this.hSCMRegistry = sCMRegistry;
        this.hEventQueue = new EventQueue();
        try {
            this.registryPort = sCMRegistry.getRegistryPort();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (this.hNode != null) {
            try {
                this.sHost = this.hNode.getName();
                return;
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public EventObserverI getEventObserver() {
        return this.hEventObserver;
    }

    public void setEventObserver(EventObserverI eventObserverI) {
        this.hEventObserver = eventObserverI;
    }

    public String toString() {
        String string = "\nHost:\t" + this.sHost;
        return string;
    }

    public void run() {
        while (true) {
            SCMEvent sCMEvent = null;
            System.out.println("SCM:: Connection.run - get event from queue");
            sCMEvent = this.hEventQueue.get();
            System.out.println("SCM:: Connection.run - got event from queue");
            if (sCMEvent != null) {
                System.out.println("SCM:: Connection.run - sending event to " + this.sHost);
                this.sendNextEvent(sCMEvent);
            }
            System.out.println("SCM:: Connection.run - yielding");
            Thread.yield();
        }
    }

    public void forwardEvent(SCMEvent sCMEvent) {
        this.hEventQueue.put(sCMEvent);
    }

    private void sendNextEvent(SCMEvent sCMEvent) {
        if (this.hEventObserver == null) {
            try {
                String string = this.hNode.getProperty(SCMPropertyKey.PRIVATE_VIP.toString()).toString();
                this.hEventObserver = this.locateRemoteEventObserver(string);
                if (this.hEventObserver == null) {
                    this.hEventObserver = this.locateRemoteEventObserver(this.hNode.getName());
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        if (this.hEventObserver == null) {
            System.out.println("Connection.sendNextEvent - giving up");
            return;
        }
        ++this.nBroadcastEventCount;
        System.out.println("SCM:: Connection.broadcastEvent - sending event #" + this.nBroadcastEventCount + " to " + this.sHost);
        try {
            this.hEventObserver.receiveEvent(sCMEvent, null);
            System.out.println("Connection.sendNextEvent - sent event");
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("SCM:: Connection.broadcastEvent -  failed to send event. Will try again");
            this.hEventObserver = null;
            this.sendNextEvent(sCMEvent);
            return;
        }
    }

    private EventObserverI locateRemoteEventObserver(String string) {
        EventObserverI eventObserverI = null;
        try {
            String string2 = new String("rmi://" + string + ":" + this.registryPort + "/" + REGISTRY_NAME.ED_NAME);
            System.out.println("SCM:: Connection.locateRemoteEventObserver - looking for EventObserver: " + string2);
            Remote remote = Naming.lookup(string2);
            System.out.println("SCM:: Connection.locateRemoteEventObserver - EventObserver: " + string2 + " found");
            if (remote instanceof EventObserverI) {
                eventObserverI = (EventObserverI)remote;
            }
        }
        catch (NotBoundException notBoundException) {
            System.out.println("SCM:: Connection.locateRemoteEventObserver - not found over " + string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("SCM:: Connection.locateRemoteEventObserver - not found over " + string);
        }
        catch (RemoteException remoteException) {
            System.out.println("SCM:: Connection.locateRemoteEventObserver - not found over " + string);
        }
        return eventObserverI;
    }
}

