/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.event;

import com.sun.scm.admin.server.event.DecodedMessage;
import com.sun.scm.admin.server.event.EventMapKey;
import com.sun.scm.admin.server.event.EventMapRecord;
import com.sun.scm.admin.server.event.EventMapTable;
import com.sun.scm.admin.server.event.EventQueue;
import com.sun.scm.admin.server.event.FACILITY;
import com.sun.scm.admin.server.event.SyslogMessage;
import com.sun.scm.admin.server.util.SCMRegistry;
import com.sun.scm.admin.server.util.SCMResource;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.EVENT_TYPE;
import com.sun.scm.admin.util.OBJECT_STATE;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SEVERITY;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class SyslogManager
extends Thread {
    private String sHost;
    private String sSyslogFile = "/dev/log";
    private EventQueue hEventQueue;
    private SCMRegistry hSCMRegistry;
    private EventMapTable hEventMapTable;
    private int nMessageCount;
    private static String sText = "";
    private static int nSyslogEventCount;

    private native int openSyslog();

    private native int readSyslog(SyslogMessage var1);

    private native int initSyslogRE();

    private native int freeSyslogRE();

    private native int decodeSyslog(String var1, DecodedMessage var2);

    public SyslogManager(String string, EventQueue eventQueue, SCMRegistry sCMRegistry) {
        this.sHost = string;
        this.hEventQueue = eventQueue;
        this.hSCMRegistry = sCMRegistry;
        this.hEventMapTable = new EventMapTable();
    }

    public void run() {
        int n = this.openSyslog();
        if (n != 0) {
            System.out.println("SCM:: SyslogManager.run - can't open Syslog");
            System.out.println("SCM:: SyslogManager.run - exit program");
            System.exit(-1);
        }
        if (this.initSyslogRE() != 0) {
            System.out.println("SCM:: SyslogManager.run -  can't initialize SyslogRE table");
            System.out.println("SCM:: SyslogManager.run - exit program");
            System.exit(-1);
        }
        while (true) {
            int n2 = 0;
            int n3 = -1;
            int n4 = -1;
            SyslogMessage syslogMessage = new SyslogMessage();
            n = this.readSyslog(syslogMessage);
            sText = String.valueOf(sText) + syslogMessage.getText();
            while ((n4 = sText.indexOf(10, n2)) >= n2) {
                String string = sText.substring(n2, n4);
                SCMEvent sCMEvent = null;
                sCMEvent = this.makeSCMEvent(syslogMessage.getFacility(), syslogMessage.getPriority(), string);
                if (sCMEvent != null) {
                    System.out.println("SCM:: SyslogManager.run - put event #" + ++nSyslogEventCount + " into queue");
                    this.hEventQueue.put(sCMEvent);
                }
                n2 = n4 + 1;
                n3 = n4;
                Thread.yield();
            }
            sText = sText.substring(n3 + 1);
            Thread.yield();
        }
    }

    private SCMEvent makeSCMEvent(int n, int n2, String string) {
        String string2 = null;
        int n3 = 0;
        Date date = new Date();
        String string3 = null;
        FACILITY.get(n);
        SEVERITY sEVERITY = SEVERITY.get(n2);
        EVENT_TYPE eVENT_TYPE = null;
        OBJECT_TYPE oBJECT_TYPE = null;
        OBJECT_STATE oBJECT_STATE = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        String string8 = null;
        DecodedMessage decodedMessage = new DecodedMessage();
        int n4 = 0;
        String string9 = null;
        SCMEvent sCMEvent = null;
        n4 = this.parseSyslogMessage(string, decodedMessage);
        if (n4 == 0) {
            string2 = decodedMessage.getSyslogResourceType();
            n3 = decodedMessage.getSyslogMessageNum();
            EventMapRecord eventMapRecord = this.hEventMapTable.get(new EventMapKey(string2, n3));
            string3 = decodedMessage.getResourceName();
            eVENT_TYPE = eventMapRecord.getEventType();
            oBJECT_TYPE = eventMapRecord.getResourceType();
            oBJECT_STATE = eventMapRecord.getState();
            string4 = eventMapRecord.getDetail();
            string9 = decodedMessage.getMisc();
            string5 = decodedMessage.getCurrentMaster();
            string6 = decodedMessage.getDataServiceType();
            string7 = decodedMessage.getDataServiceSpecific();
            bl = eventMapRecord.getBroadcastEnabled();
            string8 = decodedMessage.getDescription();
            string8 = this.getNewDescription(string2, n3, string3, string8);
            if (oBJECT_TYPE == OBJECT_TYPE.PUBLIC_NC) {
                string9 = this.parseNAFOMessage(string9, n3, string3, eVENT_TYPE, sEVERITY, string8, date, string5, string6, string7, bl);
                string3 = String.valueOf(this.sHost) + "." + string3;
                if (oBJECT_STATE == OBJECT_STATE.UNKNOWN) {
                    oBJECT_STATE = this.getPNCState(string9, n3);
                    string4 = "nafo group " + string9.toLowerCase();
                }
            }
            if (string2.equals("SUNWcluster.loghost") && n3 == 1020) {
                this.generateNFSEvents(eVENT_TYPE, sEVERITY, oBJECT_TYPE, oBJECT_STATE, string4, string3, string8, date, string5, string6, string7, this.sHost, bl);
            }
            if (oBJECT_TYPE == OBJECT_TYPE.SERVICE && string6.equals("NFS")) {
                if ((oBJECT_STATE = this.getNFSState(oBJECT_STATE, string9, n3)) == OBJECT_STATE.UNKNOWN) {
                    return null;
                }
                string4 = "nfs instance " + oBJECT_STATE.toString();
                this.generateNFSEvents(eVENT_TYPE, sEVERITY, oBJECT_TYPE, oBJECT_STATE, string4, string3, string8, date, string5, string6, string7, this.sHost, bl);
                return null;
            }
            if (oBJECT_TYPE == OBJECT_TYPE.SERVICE_TYPE && string6.equals("NFS")) {
                System.out.println("makeSCMEvent - in the if condition to generate event for NFS instances");
                sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, oBJECT_TYPE, oBJECT_STATE, string4, string3, string8, date, string5, string6, string7, this.sHost, bl);
                System.out.println("SCM:: SyslogManager.run - put event #" + ++nSyslogEventCount + " into queue");
                this.hEventQueue.put(sCMEvent);
                if (eVENT_TYPE == EVENT_TYPE.STATE_UPDATE) {
                    oBJECT_TYPE = OBJECT_TYPE.SERVICE;
                    string4 = "nfs instance " + oBJECT_STATE.toString();
                    this.generateNFSEvents(eVENT_TYPE, sEVERITY, oBJECT_TYPE, oBJECT_STATE, string4, string3, string8, date, string5, string6, string7, this.sHost, bl);
                }
                return null;
            }
            if (oBJECT_TYPE == OBJECT_TYPE.CNODE && eVENT_TYPE == EVENT_TYPE.STATE_UPDATE && (oBJECT_STATE == OBJECT_STATE.OFFLINE || oBJECT_STATE == OBJECT_STATE.FAULTED || oBJECT_STATE == OBJECT_STATE.UNKNOWN)) {
                this.processNodeEvent(eVENT_TYPE, sEVERITY, oBJECT_TYPE, oBJECT_STATE, string4, string3, string8, date, string5, string6, string7, this.sHost, bl);
                return null;
            }
            if (eVENT_TYPE == EVENT_TYPE.OWNERSHIP_CHANGE) {
                string5 = this.sHost;
            }
            if (oBJECT_TYPE == OBJECT_TYPE.CVM_ACCESS) {
                string3 = String.valueOf(this.sHost) + ".CVM";
            }
            if (oBJECT_TYPE == OBJECT_TYPE.PRIVATE_NC) {
                string3 = String.valueOf(this.sHost) + "." + string3;
            }
            if (oBJECT_TYPE == OBJECT_TYPE.SRVC_REPLICA) {
                string3 = String.valueOf(this.sHost) + ".DB";
            }
            if (oBJECT_STATE != null) {
                sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, oBJECT_TYPE, oBJECT_STATE, string4, string3, string8, date, string5, string6, string7, this.sHost, bl);
            }
        }
        return sCMEvent;
    }

    private int parseSyslogMessage(String string, DecodedMessage decodedMessage) {
        if (string.length() >= 16 && string.charAt(3) == ' ' && string.charAt(6) == ' ' && string.charAt(9) == ':' && string.charAt(12) == ':' && string.charAt(15) == ' ') {
            string = string.substring(16);
        }
        return this.decodeSyslog(string, decodedMessage);
    }

    private OBJECT_STATE getPNCAdapterState(String string) {
        OBJECT_STATE oBJECT_STATE = null;
        if (string.equals("OK")) {
            oBJECT_STATE = OBJECT_STATE.ONLINE;
            return oBJECT_STATE;
        }
        if (string.equals("DOUBT")) {
            oBJECT_STATE = OBJECT_STATE.WAIT;
            return oBJECT_STATE;
        }
        if (string.equals("DOWN")) {
            oBJECT_STATE = OBJECT_STATE.OFFLINE;
            return oBJECT_STATE;
        }
        if (string.equals("NETWORK DOWN")) {
            oBJECT_STATE = OBJECT_STATE.FAULTED;
            return oBJECT_STATE;
        }
        if (string.equals("NOT MONITORING")) {
            oBJECT_STATE = OBJECT_STATE.UNKNOWN;
            return oBJECT_STATE;
        }
        return oBJECT_STATE;
    }

    private OBJECT_STATE getPNCState(String string, int n) {
        OBJECT_STATE oBJECT_STATE = null;
        if (n == 2001 || n == 6003) {
            oBJECT_STATE = OBJECT_STATE.ONLINE;
            return oBJECT_STATE;
        }
        if (string.equals("OK")) {
            oBJECT_STATE = OBJECT_STATE.ONLINE;
            return oBJECT_STATE;
        }
        if (string.equals("DOUBT")) {
            oBJECT_STATE = OBJECT_STATE.WAIT;
            return oBJECT_STATE;
        }
        if (string.equals("DOWN")) {
            oBJECT_STATE = OBJECT_STATE.OFFLINE;
            return oBJECT_STATE;
        }
        if (string.equals("NETWORK DOWN")) {
            oBJECT_STATE = OBJECT_STATE.FAULTED;
            return oBJECT_STATE;
        }
        if (string.equals("NOT MONITORING")) {
            oBJECT_STATE = OBJECT_STATE.UNKNOWN;
            return oBJECT_STATE;
        }
        return oBJECT_STATE;
    }

    private void generateTakeoverEvents(EVENT_TYPE eVENT_TYPE, SEVERITY sEVERITY, OBJECT_TYPE oBJECT_TYPE, String string, String string2, Date date, String string3, boolean bl) {
        SCMEvent sCMEvent = null;
        sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, oBJECT_TYPE, null, null, string, string2, date, null, null, null, string3, bl);
        ++nSyslogEventCount;
        this.hEventQueue.put(sCMEvent);
        sCMEvent = new SCMEvent(EVENT_TYPE.STATE_UPDATE, SEVERITY.MESSAGE, oBJECT_TYPE, OBJECT_STATE.ONLINE, "Up", string, string2, new Date(), null, null, null, string3, bl);
        ++nSyslogEventCount;
        this.hEventQueue.put(sCMEvent);
    }

    private OBJECT_STATE getNFSState(OBJECT_STATE oBJECT_STATE, String string, int n) {
        if (n == 1050) {
            if (string.equals("start")) {
                oBJECT_STATE = OBJECT_STATE.ONLINE;
                return oBJECT_STATE;
            }
            if (string.equals("stop")) {
                oBJECT_STATE = OBJECT_STATE.OFFLINE;
                return oBJECT_STATE;
            }
            if (string.equals("abort")) {
                oBJECT_STATE = OBJECT_STATE.OFFLINE;
                return oBJECT_STATE;
            }
        }
        if (n == 3010) {
            if (string.equals("start")) {
                oBJECT_STATE = OBJECT_STATE.OFFLINE;
                return oBJECT_STATE;
            }
            if (string.equals("stop")) {
                oBJECT_STATE = OBJECT_STATE.FAULTED;
                return oBJECT_STATE;
            }
            if (string.equals("abort")) {
                oBJECT_STATE = OBJECT_STATE.FAULTED;
                return oBJECT_STATE;
            }
        }
        return oBJECT_STATE;
    }

    private void generateNFSEvents(EVENT_TYPE eVENT_TYPE, SEVERITY sEVERITY, OBJECT_TYPE oBJECT_TYPE, OBJECT_STATE oBJECT_STATE, String string, String string2, String string3, Date date, String string4, String string5, String string6, String string7, boolean bl) {
        try {
            SCMResourceI sCMResourceI = this.hSCMRegistry.lookupServer("NFS", OBJECT_TYPE.SERVICE_TYPE.toString());
            if (sCMResourceI == null) {
                System.out.println("generateNFSEvents - server-side object for NFS DS Type not found");
                return;
            }
            Vector vector = sCMResourceI.getChildList(OBJECT_TYPE.SERVICE.toString());
            if (vector == null) {
                System.out.println("generateNFSEvents - no children of NFS found");
                return;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                SCMResource sCMResource = (SCMResource)enumeration.nextElement();
                if (sCMResource == null) continue;
                OBJECT_STATE oBJECT_STATE2 = sCMResource.getState();
                if (!sCMResource.getResourceState(OBJECT_TYPE.SERVICE.getId(), sCMResource.getName())) {
                    return;
                }
                OBJECT_STATE oBJECT_STATE3 = sCMResource.getState();
                if (oBJECT_STATE2 == oBJECT_STATE3) continue;
                oBJECT_STATE = oBJECT_STATE3;
                string = sCMResource.getStateString();
                SCMEvent sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, OBJECT_TYPE.SERVICE, oBJECT_STATE, string, sCMResource.getName(), string3, date, null, null, null, string7, true);
                ++nSyslogEventCount;
                this.hEventQueue.put(sCMEvent);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private String parseNAFOMessage(String string, int n, String string2, EVENT_TYPE eVENT_TYPE, SEVERITY sEVERITY, String string3, Date date, String string4, String string5, String string6, boolean bl) {
        String string7 = string;
        String string8 = null;
        String string9 = null;
        int n2 = 0;
        int n3 = 0;
        n3 = string.indexOf(58, n2);
        if (n3 >= n2) {
            string7 = string.substring(n2, n3);
            n2 = n3 + 1;
            if ((n3 = string.indexOf(58, n2)) >= n2) {
                string8 = string.substring(n2, n3);
                string9 = string.substring(n3 + 1);
            } else {
                string8 = string.substring(n2);
            }
            this.generateNAFOAdapterEvent(string7, string8, string9, n, string2, eVENT_TYPE, sEVERITY, string3, date, string4, string5, string6, bl);
        }
        return string7;
    }

    private void generateNAFOAdapterEvent(String string, String string2, String string3, int n, String string4, EVENT_TYPE eVENT_TYPE, SEVERITY sEVERITY, String string5, Date date, String string6, String string7, String string8, boolean bl) {
        String string9 = null;
        String string10 = null;
        OBJECT_STATE oBJECT_STATE = null;
        String string11 = null;
        switch (n) {
            case 2001: {
                string9 = String.valueOf(this.sHost) + "." + string4 + "." + string2;
                string10 = "OK";
                oBJECT_STATE = this.getPNCAdapterState(string10);
                string11 = "nafo adapter " + string10.toLowerCase();
                SCMEvent sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, OBJECT_TYPE.PNC_ADAPTER, oBJECT_STATE, string11, string9, string5, date, string6, string7, string8, this.sHost, bl);
                System.out.println("SCM:: SyslogManager.generateNAFOAdapterEvent - put event #" + ++nSyslogEventCount + " into queue");
                this.hEventQueue.put(sCMEvent);
                return;
            }
            case 2002: 
            case 4501: 
            case 4502: 
            case 5001: 
            case 6001: 
            case 6002: {
                string9 = String.valueOf(this.sHost) + "." + string4 + "." + string2;
                string10 = string3;
                oBJECT_STATE = this.getPNCAdapterState(string10);
                string11 = "nafo adapter " + string10.toLowerCase();
                SCMEvent sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, OBJECT_TYPE.PNC_ADAPTER, oBJECT_STATE, string11, string9, string5, date, string6, string7, string8, this.sHost, bl);
                System.out.println("SCM:: SyslogManager.generateNAFOAdapterEvent - put event #" + ++nSyslogEventCount + " into queue");
                this.hEventQueue.put(sCMEvent);
                return;
            }
            case 6003: {
                string9 = String.valueOf(this.sHost) + "." + string4 + "." + string3;
                string10 = "DOWN";
                oBJECT_STATE = this.getPNCAdapterState(string10);
                string11 = "nafo adapter " + string10.toLowerCase();
                SCMEvent sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, OBJECT_TYPE.PNC_ADAPTER, oBJECT_STATE, string11, string9, string5, date, string6, string7, string8, this.sHost, bl);
                System.out.println("SCM:: SyslogManager.generateNAFOAdapterEvent - put event #" + ++nSyslogEventCount + " into queue");
                this.hEventQueue.put(sCMEvent);
                string9 = String.valueOf(this.sHost) + "." + string4 + "." + string2;
                string10 = "OK";
                oBJECT_STATE = this.getPNCAdapterState(string10);
                string11 = "nafo adapter " + string10.toLowerCase();
                sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, OBJECT_TYPE.PNC_ADAPTER, oBJECT_STATE, string11, string9, string5, date, string6, string7, string8, this.sHost, bl);
                System.out.println("SCM:: SyslogManager.generateNAFOAdapterEvent - put event #" + ++nSyslogEventCount + " into queue");
                this.hEventQueue.put(sCMEvent);
                return;
            }
        }
    }

    private String getNewDescription(String string, int n, String string2, String string3) {
        String string4 = string3;
        if (string.equals("SUNWcluster.loghost")) {
            if (n == 1010) {
                string4 = "Logical host " + string2 + " is going to be given up";
            }
            if (n == 1020) {
                string4 = "Logical host " + string2 + " is being given up successfully";
            }
            if (n == 1030) {
                string4 = "Logical host " + string2 + " is going to be taken over";
            }
            if (n == 1040) {
                string4 = "Logical host " + string2 + " is being taken over successfully";
            }
        }
        if (string.equals("SUNWcluster.reconf.loghost")) {
            if (n == 4010) {
                string4 = "Current master failed to give up logical host " + string2;
            }
            if (n == 4020) {
                string4 = "New master failed to take over logical host " + string2;
            }
        }
        return string4;
    }

    private void processNodeEvent(EVENT_TYPE eVENT_TYPE, SEVERITY sEVERITY, OBJECT_TYPE oBJECT_TYPE, OBJECT_STATE oBJECT_STATE, String string, String string2, String string3, Date date, String string4, String string5, String string6, String string7, boolean bl) {
        SCMEvent sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, oBJECT_TYPE, oBJECT_STATE, string, string2, string3, date, string4, string5, string6, string7, bl);
        ++nSyslogEventCount;
        this.hEventQueue.put(sCMEvent);
        this.generateNFSEvents(eVENT_TYPE, sEVERITY, oBJECT_TYPE, oBJECT_STATE, string, string2, string3, date, string4, string5, string6, string7, bl);
        try {
            SCMResourceI sCMResourceI = this.hSCMRegistry.lookupServer(string2, oBJECT_TYPE.toString());
            if (sCMResourceI == null) {
                return;
            }
            Vector vector = sCMResourceI.getPossMasteredList(OBJECT_TYPE.LHOST.toString());
            if (vector == null) {
                return;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                SCMResource sCMResource = (SCMResource)enumeration.nextElement();
                if (sCMResource == null) continue;
                OBJECT_STATE oBJECT_STATE2 = sCMResource.getState();
                if (!sCMResource.getResourceState(OBJECT_TYPE.LHOST.getId(), sCMResource.getName())) {
                    return;
                }
                OBJECT_STATE oBJECT_STATE3 = sCMResource.getState();
                if (oBJECT_STATE2 == oBJECT_STATE3) continue;
                oBJECT_STATE = oBJECT_STATE3;
                string = sCMResource.getStateString();
                sCMEvent = new SCMEvent(eVENT_TYPE, sEVERITY, OBJECT_TYPE.LHOST, oBJECT_STATE, string, sCMResource.getName(), string3, date, null, null, null, string7, true);
                ++nSyslogEventCount;
                this.hEventQueue.put(sCMEvent);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

