/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.eventq;

import com.sun.scm.admin.server.eventq.SCMEventQueueI;
import com.sun.scm.admin.server.scmgr.ClusterManagerI;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.EventFilterMode;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SEVERITY;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SCMEventQueue
extends UnicastRemoteObject
implements SCMEventQueueI,
Serializable {
    private static final int EVENT_MAX = 300;
    private static final double EVENT_THRESHOLD = 0.8;
    private ClusterManagerI cm;
    private Vector event_queue;
    private Hashtable otype_tbl = new Hashtable(20);
    private Hashtable severity_tbl = new Hashtable(5);

    public SCMEventQueue(ClusterManagerI clusterManagerI) throws RemoteException {
        this.cm = clusterManagerI;
        this.event_queue = new Vector(300);
    }

    public synchronized Vector getEventList(EventFilterMode eventFilterMode, String string, SCMResourceI sCMResourceI) throws RemoteException {
        if (eventFilterMode.noFiltering()) {
            return this.getAllEvents();
        }
        if (eventFilterMode.getMode(0)) {
            SEVERITY sEVERITY = eventFilterMode.getSeverity();
            if (sEVERITY == null) {
                System.out.println("SCM:: SCMEventQueue.getEventList - Can not get severity level; processing terminated.");
                return null;
            }
            if (eventFilterMode.getMode(1)) {
                return this.getFilteredBySOT(sEVERITY, string);
            }
            if (eventFilterMode.getMode(2)) {
                return this.getFilteredByAll(sEVERITY.toString(), string, sCMResourceI.getName());
            }
            return this.getFilteredBySeverity(sEVERITY.toString());
        }
        if (eventFilterMode.getMode(1)) {
            return this.getFilteredByObjType(string);
        }
        if (eventFilterMode.getMode(2)) {
            return this.getFilteredByResource(string, sCMResourceI.getName());
        }
        return null;
    }

    public synchronized Vector getAllEvents() throws RemoteException {
        return this.event_queue;
    }

    public synchronized Vector getFilteredBySeverity(String string) throws RemoteException {
        return (Vector)this.severity_tbl.get(string);
    }

    public synchronized Vector getFilteredBySOT(SEVERITY sEVERITY, String string) throws RemoteException {
        Vector vector = (Vector)this.otype_tbl.get(string);
        if (vector == null) {
            return null;
        }
        Vector<SCMEvent> vector2 = new Vector<SCMEvent>();
        SCMEvent sCMEvent = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            sCMEvent = (SCMEvent)enumeration.nextElement();
            if (!sCMEvent.severity.equalTo(sEVERITY)) continue;
            vector2.addElement(sCMEvent);
        }
        return vector2;
    }

    public synchronized Vector getFilteredByObjType(String string) throws RemoteException {
        return (Vector)this.otype_tbl.get(string);
    }

    public synchronized Vector getFilteredByResource(String string, String string2) throws RemoteException {
        Vector vector = (Vector)this.otype_tbl.get(string);
        if (vector == null) {
            return null;
        }
        Vector<SCMEvent> vector2 = new Vector<SCMEvent>();
        SCMEvent sCMEvent = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            sCMEvent = (SCMEvent)enumeration.nextElement();
            if (sCMEvent.object_name.compareTo(string2) != 0) continue;
            vector2.addElement(sCMEvent);
        }
        return vector2;
    }

    public synchronized Vector getFilteredByAll(String string, String string2, String string3) throws RemoteException {
        Vector vector = (Vector)this.severity_tbl.get(string);
        if (vector == null) {
            return null;
        }
        Vector<SCMEvent> vector2 = new Vector<SCMEvent>();
        SCMEvent sCMEvent = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            sCMEvent = (SCMEvent)enumeration.nextElement();
            OBJECT_TYPE oBJECT_TYPE = sCMEvent.object_type;
            if (oBJECT_TYPE == null || sCMEvent.object_name == null || oBJECT_TYPE.toString().compareTo(string2) != 0 || string3.compareTo(sCMEvent.object_name) != 0) continue;
            vector2.addElement(sCMEvent);
        }
        return vector2;
    }

    public synchronized boolean isFull() throws RemoteException {
        return this.event_queue.size() == 300;
    }

    public synchronized boolean isAtThreshold() throws RemoteException {
        Integer n = new Integer(300);
        Double d = new Double(n.doubleValue() * 0.8);
        return this.event_queue.size() == d.intValue();
    }

    public synchronized void addEvent(SCMEvent sCMEvent) throws RemoteException {
        String string;
        if (this.event_queue.contains(sCMEvent)) {
            return;
        }
        if (this.isFull()) {
            this.deleteEvent();
        }
        this.event_queue.insertElementAt(sCMEvent, this.event_queue.size());
        OBJECT_TYPE oBJECT_TYPE = sCMEvent.object_type;
        SEVERITY sEVERITY = sCMEvent.severity;
        Vector vector = null;
        if (oBJECT_TYPE != null) {
            string = oBJECT_TYPE.toString();
            vector = (Vector)this.otype_tbl.get(string);
            if (vector == null) {
                vector = new Vector();
                this.otype_tbl.put(string, vector);
            }
            if (!vector.contains(sCMEvent)) {
                vector.insertElementAt(sCMEvent, vector.size());
            }
        }
        if (sEVERITY != null) {
            string = sEVERITY.toString();
            vector = (Vector)this.severity_tbl.get(string);
            if (vector == null) {
                vector = new Vector();
                this.severity_tbl.put(string, vector);
            }
            if (!vector.contains(sCMEvent)) {
                vector.insertElementAt(sCMEvent, vector.size());
            }
        }
    }

    public synchronized void deleteEvent() throws RemoteException {
        this.deleteEvent(0);
    }

    public synchronized void deleteEvent(int n) throws RemoteException {
        String string;
        SCMEvent sCMEvent = (SCMEvent)this.event_queue.elementAt(n);
        OBJECT_TYPE oBJECT_TYPE = sCMEvent.object_type;
        SEVERITY sEVERITY = sCMEvent.severity;
        Vector vector = null;
        if (oBJECT_TYPE != null && (vector = (Vector)this.otype_tbl.get(string = oBJECT_TYPE.toString())) != null) {
            vector.removeElement(sCMEvent);
            if (vector.isEmpty()) {
                this.otype_tbl.remove(string);
            }
        }
        if (sEVERITY != null && (vector = (Vector)this.severity_tbl.get(string = sEVERITY.toString())) != null) {
            vector.removeElement(sCMEvent);
            if (vector.isEmpty()) {
                this.severity_tbl.remove(string);
            }
        }
        this.event_queue.removeElementAt(n);
    }
}

